/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.v8.dt.internal.resourcestorage.Activator;
import com.e1c.langtool.v8.dt.resourcestorage.IDictionaryRowProcessor;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;

public class TranslationsFileReader {
    private final IFile file;

    public TranslationsFileReader(@NonNull IFile file) {
        this.file = file;
    }

    public boolean read(IDictionaryRowProcessor processor) {
        if (this.file == null || !this.file.exists()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader reader = new InputStreamReader(this.file.getContents(), StandardCharsets.UTF_8);){
                this.load(new LineReader(reader), processor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        catch (IOException | CoreException e) {
            Activator.logError(e);
            return false;
        }
    }

    private void load(LineReader lr, IDictionaryRowProcessor processor) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            char c = '\u0000';
            int keyLen = 0;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            while (keyLen < limit) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                ++keyLen;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            FeatureKey key = this.loadConvertKey(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            if (System.lineSeparator() != "\n") {
                value = value.replace("\n", System.lineSeparator());
            }
            String keyComment = null;
            if (lr.comment != null) {
                keyComment = String.join((CharSequence)System.lineSeparator(), lr.comment.split("\\n"));
            }
            processor.process(key, value, keyComment, lr.lineNumber);
        }
    }

    public IFile getFile() {
        return this.file;
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private FeatureKey loadConvertKey(char[] in, int off, int len, char[] convtBuf) {
        ArrayList segments = Lists.newArrayList();
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 116) {
                    aChar = 9;
                } else {
                    if (aChar == 114) continue;
                    if (aChar == 110) {
                        aChar = 10;
                    } else if (aChar == 102) {
                        aChar = 12;
                    }
                }
                out[outLen++] = aChar;
                continue;
            }
            if (aChar == 46) {
                segments.add(new String(out, 0, outLen));
                out = convtBuf;
                outLen = 0;
                continue;
            }
            out[outLen++] = aChar;
        }
        if (outLen > 0) {
            segments.add(new String(out, 0, outLen));
        }
        return SegmentFeatureKey.create((List)segments);
    }

    private class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;
        String comment = null;
        char[] commentBuf = new char[1024];
        int lineNumber = 0;
        boolean skipLF = false;

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            this.commentBuf = new char[1024];
            this.comment = null;
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if ((c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++]) == '\r' || c == '\n' && (this.lineNumber == 0 || !this.skipLF && this.inOff >= 2 && this.inCharBuf[this.inOff - 2] != '\r')) {
                    ++this.lineNumber;
                }
                if (this.skipLF) {
                    this.skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f') continue;
                    if (!(appendedLineBegin || c != '\r' && c != '\n')) {
                        if (c != '\r') continue;
                        this.skipLF = true;
                        continue;
                    }
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        if (isCommentLine) {
                            this.commentBuf[len++] = 10;
                            this.commentBuf = this.increaseBuffer(this.commentBuf, len);
                        } else {
                            this.commentBuf = new char[1024];
                        }
                        isCommentLine = true;
                        skipWhiteSpace = true;
                        appendedLineBegin = true;
                        continue;
                    }
                    if (isCommentLine) {
                        this.comment = new String(this.commentBuf, 0, len);
                        this.commentBuf = new char[1024];
                        len = 0;
                    } else {
                        this.comment = null;
                        this.commentBuf = new char[1024];
                    }
                    isCommentLine = false;
                }
                if (c != '\n' && c != '\r') {
                    if (isCommentLine) {
                        this.commentBuf[len++] = c;
                        this.commentBuf = this.increaseBuffer(this.commentBuf, len);
                    } else {
                        this.lineBuf[len++] = c;
                        this.lineBuf = this.increaseBuffer(this.lineBuf, len);
                    }
                    if (c == '\\' && !isCommentLine) {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isNewLine = true;
                    skipWhiteSpace = true;
                    if (isCommentLine) {
                        appendedLineBegin = true;
                    }
                    if (c != '\r') continue;
                    this.skipLF = true;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                this.skipLF = true;
            }
            return len;
        }

        private char[] increaseBuffer(char[] currentBuf, int len) {
            if (len == currentBuf.length) {
                int newLength = currentBuf.length * 2;
                if (newLength < 0) {
                    newLength = Integer.MAX_VALUE;
                }
                char[] buf = new char[newLength];
                System.arraycopy(currentBuf, 0, buf, 0, currentBuf.length);
                return buf;
            }
            return currentBuf;
        }
    }
}

