/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage.validation;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.v8.dt.resourcestorage.DictionaryRow;
import com.e1c.langtool.v8.dt.resourcestorage.validation.CheckContext;
import com.e1c.langtool.v8.dt.resourcestorage.validation.ICheckAcceptor;
import com.e1c.langtool.v8.dt.resourcestorage.validation.IDictionaryStorageCheck;
import com.e1c.langtool.v8.dt.resourcestorage.validation.Messages;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class SpecialSymbolCountCheck
implements IDictionaryStorageCheck {
    private static final String ID = "SpecialSymbolCountCheck";
    private static final Pattern SYMBOLS_PATTERN = Pattern.compile("([\\W0-9_])", 256);

    @Override
    public void validate(DictionaryRow row, ICheckAcceptor acceptor, CheckContext context, IProgressMonitor monitor) {
        FeatureKey key = row.getKey();
        if (key.getSegments().size() == 0) {
            return;
        }
        Map<String, Integer> keySymbolsCounter = this.countSymbols(key.toString());
        Map<String, Integer> valueSymbolsCounter = this.countSymbols(row.getValue());
        MapDifference symbolsDifference = Maps.difference(keySymbolsCounter, valueSymbolsCounter);
        symbolsDifference.entriesOnlyOnLeft().forEach((symbol, difference) -> {
            String message = MessageFormat.format(Messages.SpecialSymbolCountCheckNotInValue, symbol);
            acceptor.acceptError(ID, message, row);
        });
        symbolsDifference.entriesOnlyOnRight().forEach((symbol, difference) -> {
            String message = MessageFormat.format(Messages.SpecialSymbolCountCheckNotInKey, symbol);
            acceptor.acceptError(ID, message, row);
        });
        symbolsDifference.entriesDiffering().forEach((symbol, difference) -> {
            String message = MessageFormat.format(Messages.SpecialSymbolCountCheckMessage, symbol, difference.leftValue(), difference.rightValue());
            acceptor.acceptError(ID, message, row);
        });
    }

    private Map<String, Integer> countSymbols(String word) {
        HashMap<String, Integer> symbolsCount = new HashMap<String, Integer>();
        Matcher keyMatcher = SYMBOLS_PATTERN.matcher(word);
        while (keyMatcher.find()) {
            String symbol = keyMatcher.group(1);
            symbolsCount.compute(symbol, (counterKey, counter) -> {
                if (counter == null) {
                    return 1;
                }
                counter = counter + 1;
                return counter;
            });
        }
        return symbolsCount;
    }
}

