/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage.validation;

import com.e1c.langtool.v8.dt.internal.resourcestorage.Activator;
import com.e1c.langtool.v8.dt.resourcestorage.DictionaryRow;
import com.e1c.langtool.v8.dt.resourcestorage.validation.ICheckAcceptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class StorageCheckAcceptor
implements ICheckAcceptor {
    private static String MARKER_ID = "com.e1c.langtool.v8.dt.resourcestorage.validation.marker";
    private static final String SKIP_ANNOTATION = "@skip-check";
    private static final String CHECK_ID = "checkid";
    private static final String[] MARKERY_ATTRIBUTES = new String[]{"checkid", "lineNumber", "message", "severity", "priority"};
    private final List<MarkerInfo> markers = new ArrayList<MarkerInfo>();
    private final IResource source;

    public StorageCheckAcceptor(IFile dictionary) {
        this.source = dictionary;
    }

    @Override
    public void clean() {
        try {
            this.source.deleteMarkers(MARKER_ID, true, 0);
        }
        catch (CoreException e) {
            Activator.logError(e);
        }
    }

    @Override
    public void acceptError(String checkId, String message, DictionaryRow row) {
        this.accept(checkId, message, row, 2);
    }

    @Override
    public void acceptWarning(String checkId, String message, DictionaryRow row) {
        this.accept(checkId, message, row, 1);
    }

    @Override
    public void acceptInfo(String checkId, String message, DictionaryRow row) {
        this.accept(checkId, message, row, 0);
    }

    @Override
    public void flush(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.markers.size());
        try {
            for (MarkerInfo info : this.markers) {
                if (monitor.isCanceled()) {
                    return;
                }
                IMarker marker = this.source.createMarker(MARKER_ID);
                marker.setAttributes(MARKERY_ATTRIBUTES, info.vlaues);
                subMonitor.worked(1);
            }
        }
        catch (CoreException e) {
            Activator.logError(e);
        }
        subMonitor.done();
    }

    private void accept(String checkId, String message, DictionaryRow row, int severenity) {
        String comment = row.getComment();
        if (comment != null && comment.contains(SKIP_ANNOTATION)) {
            return;
        }
        int line = row.getLineNumber();
        MarkerInfo info = new MarkerInfo();
        info.vlaues = new Object[]{checkId, line, message, severenity, 2};
        this.markers.add(info);
    }

    private final class MarkerInfo {
        Object[] vlaues;

        private MarkerInfo() {
        }
    }
}

