/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.editor.Messages;
import com.e1c.langtool.ui.editor.StorageMediator;
import com.e1c.langtool.ui.editor.main.MainPage;
import com.e1c.langtool.ui.editor.main.MainPageEditor;
import com.e1c.langtool.ui.internal.editor.EditorPlugin;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class TranslationEditor
extends MultiPageEditorPart {
    public static final String ID = "com.e1c.langtool.ui.editor.TranslationEditor";
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private ITranslatingProjectManager projectManager;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager translationStorageManager;
    private StorageMediator storageMediator;
    private MainPage mainPage;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setPartName(editorInput.getName());
        super.init(site, editorInput);
        if (!this.collectingService.hasCollector((Object)editorInput)) {
            throw new PartInitException("Invalid Input: mast be at least one registred IFeatureCollector");
        }
        TranslationSource source = TranslationUtils.getTranslationSource((Object)editorInput);
        if (source == null) {
            throw new PartInitException("Invalid Input: mast be a Translation source");
        }
        ITranslatingProject project = this.projectManager.getProject(source.getProject());
        this.storageMediator = new StorageMediator(project, this.collectingService, source);
        StorageID id = this.storageSettingsManager.getSettingsOrDefault(project.getProject()).getEdit().getStorageId();
        ITranslationStorageProvider.Storage storage = this.translationStorageManager.getStorage(source.getProject(), id);
        this.storageMediator.setStorage(storage);
    }

    protected void createPages() {
        try {
            MainPageEditor mainPageEditor = new MainPageEditor(this.storageMediator);
            int index = this.addPage((IEditorPart)mainPageEditor, null);
            this.mainPage = mainPageEditor.getMainPage();
            this.setPageText(index, Messages.TranslationEditor_Main_page_title);
            this.setPageImage(index, EditorPlugin.getImage("com.e1c.langtool.ui.editor/view16/main_page_editor.png"));
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating MainPageEditor page.", (String)e.getLocalizedMessage(), (IStatus)e.getStatus());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.mainPage.refreshEditorOnChanges();
        this.storageMediator.save(monitor);
        this.mainPage.refreshTextBoxes();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        if (this.mainPage != null) {
            this.mainPage.dispose();
        }
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 0) {
            this.mainPage.refreshTextBoxes();
            return;
        }
    }
}

