/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.main;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.ui.SearchText;
import com.e1c.langtool.ui.TextSearchFilter;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.ui.editor.EditorPreferences;
import com.e1c.langtool.ui.editor.StorageMediator;
import com.e1c.langtool.ui.editor.main.FeatureTreeLabelProvider;
import com.e1c.langtool.ui.tree.FeatureTreeComparator;
import com.e1c.langtool.ui.tree.FeatureTreeContentProvider;
import com.e1c.langtool.ui.tree.IFeatureTree;
import com.e1c.langtool.ui.tree.IFeatureValueItem;
import com.e1c.langtool.ui.tree.ITreeItem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class FeatureTreeComposite
extends Composite {
    private final StorageMediator storageMediator;
    private Cursor waitCursor;
    private Cursor defaultCursor;
    private TreeViewer treeViewer;
    private IFeatureTree featureTree;
    private boolean featureTreeHierarchical = EditorPreferences.getKeyTreeHierarchical();
    private FeatureTreeLabelProvider labelProvider;
    private SearchText searchText;
    private TextSearchFilter searchFilter;

    public FeatureTreeComposite(Composite parent, StorageMediator storageMediator) {
        super(parent, 2048);
        this.storageMediator = storageMediator;
        this.featureTree = storageMediator.getFeatureTree();
        this.setLayout((Layout)new GridLayout(1, false));
        this.createTopSection();
        this.createTreeSection();
        this.waitCursor = parent.getDisplay().getSystemCursor(1);
        this.defaultCursor = parent.getDisplay().getSystemCursor(0);
    }

    public void dispose() {
        super.dispose();
        this.featureTree = null;
    }

    private void createTopSection() {
        Composite topComposite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        topComposite.setLayout((Layout)gridLayout);
        topComposite.setLayoutData((Object)new GridData(768));
        this.searchText = new SearchText(topComposite);
        this.searchText.setLayoutData((Object)new GridData(768));
        Composite topRightComposite = new Composite(topComposite, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        topRightComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        topRightComposite.setLayoutData((Object)gridData);
        final Button hierModeButton = new Button(topRightComposite, 2);
        hierModeButton.setImage(TransSharedImages.getImage((String)"com.e1c.langtool.ui/elcl16/hierarchical_mode.png"));
        hierModeButton.setToolTipText("Tree");
        final Button flatModeButton = new Button(topRightComposite, 2);
        flatModeButton.setImage(TransSharedImages.getImage((String)"com.e1c.langtool.ui/elcl16/flat_mode.png"));
        flatModeButton.setToolTipText("Flat");
        if (this.featureTreeHierarchical) {
            hierModeButton.setSelection(true);
            hierModeButton.setEnabled(false);
        } else {
            flatModeButton.setSelection(true);
            flatModeButton.setEnabled(false);
        }
        hierModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (hierModeButton.getSelection()) {
                    flatModeButton.setSelection(false);
                    flatModeButton.setEnabled(true);
                    hierModeButton.setEnabled(false);
                    FeatureTreeComposite.this.setCursor(FeatureTreeComposite.this.waitCursor);
                    FeatureTreeComposite.this.setVisible(false);
                    FeatureTreeComposite.this.storageMediator.updateTree(true);
                    FeatureTreeComposite.this.treeViewer.refresh();
                    if (EditorPreferences.getKeyTreeExpanded()) {
                        FeatureTreeComposite.this.treeViewer.getControl().setRedraw(false);
                        FeatureTreeComposite.this.treeViewer.expandAll();
                        FeatureTreeComposite.this.treeViewer.getControl().setRedraw(true);
                    }
                    FeatureTreeComposite.this.setVisible(true);
                    FeatureTreeComposite.this.setCursor(FeatureTreeComposite.this.defaultCursor);
                }
            }
        });
        flatModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (flatModeButton.getSelection()) {
                    hierModeButton.setSelection(false);
                    hierModeButton.setEnabled(true);
                    flatModeButton.setEnabled(false);
                    FeatureTreeComposite.this.setCursor(FeatureTreeComposite.this.waitCursor);
                    FeatureTreeComposite.this.setVisible(false);
                    FeatureTreeComposite.this.storageMediator.updateTree(false);
                    FeatureTreeComposite.this.treeViewer.refresh();
                    FeatureTreeComposite.this.setVisible(true);
                    FeatureTreeComposite.this.setCursor(FeatureTreeComposite.this.defaultCursor);
                }
            }
        });
    }

    private void createTreeSection() {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.treeViewer = new TreeViewer((Composite)this, 2820);
        this.treeViewer.setContentProvider((IContentProvider)new FeatureTreeContentProvider());
        this.labelProvider = new FeatureTreeLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.featureTree);
        if (EditorPreferences.getKeyTreeExpanded()) {
            this.treeViewer.expandAll();
        }
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FeatureTreeComposite.this.featureTree.setSelection(FeatureTreeComposite.this.getSelection());
            }
        });
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                ITreeItem element = FeatureTreeComposite.this.getSelection();
                if (FeatureTreeComposite.this.treeViewer.isExpandable((Object)element)) {
                    if (FeatureTreeComposite.this.treeViewer.getExpandedState((Object)element)) {
                        FeatureTreeComposite.this.treeViewer.collapseToLevel((Object)element, 1);
                    } else {
                        FeatureTreeComposite.this.treeViewer.expandToLevel((Object)element, 1);
                    }
                }
            }
        });
        this.treeViewer.setComparator((ViewerComparator)new FeatureTreeComparator());
        this.searchFilter = new TextSearchFilter();
        this.treeViewer.addFilter((ViewerFilter)this.searchFilter);
        this.searchText.addPostSearchModifyListener(e -> {
            Display display = this.treeViewer.getControl().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    this.setCursor(this.waitCursor);
                    this.treeViewer.getControl().setRedraw(false);
                    this.searchFilter.setSearchText(e.getText());
                    this.treeViewer.refresh();
                    if (StringUtils.isNotEmpty((String)e.getText()) || EditorPreferences.getKeyTreeExpanded()) {
                        this.treeViewer.expandAll();
                    }
                    this.treeViewer.getControl().setRedraw(true);
                    this.setCursor(this.defaultCursor);
                });
            }
        });
        this.setCursor(this.waitCursor);
        CollectingJob job = new CollectingJob(this.treeViewer.getTree().getDisplay());
        job.schedule();
    }

    public ITreeItem getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        return (ITreeItem)selection.getFirstElement();
    }

    public FeatureValue getSelectedValue() {
        FeatureValue value = null;
        ITreeItem item = this.getSelection();
        if (item != null && item instanceof IFeatureValueItem) {
            value = ((IFeatureValueItem)item).getFeatureValue();
        }
        return value;
    }

    private class CollectingJob
    extends Job {
        private final Display display;

        public CollectingJob(Display display) {
            super("Collecting feature values");
            this.display = display;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(this.getName(), -1);
            FeatureTreeComposite.this.featureTree.getChildren().clear();
            FeatureTreeComposite.this.storageMediator.collectValues(monitor);
            if (!monitor.isCanceled()) {
                FeatureTreeComposite.this.storageMediator.updateTree(FeatureTreeComposite.this.featureTreeHierarchical);
            }
            boolean isCanceled = monitor.isCanceled();
            if (!this.display.isDisposed()) {
                this.display.asyncExec(() -> {
                    if (!isCanceled) {
                        FeatureTreeComposite.this.treeViewer.refresh();
                        if (FeatureTreeComposite.this.featureTreeHierarchical) {
                            FeatureTreeComposite.this.treeViewer.getControl().setRedraw(false);
                            FeatureTreeComposite.this.treeViewer.expandAll();
                            FeatureTreeComposite.this.treeViewer.getControl().setRedraw(true);
                        }
                    }
                    FeatureTreeComposite.this.setCursor(FeatureTreeComposite.this.defaultCursor);
                });
            }
            return isCanceled ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

