/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.main;

import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.ui.tree.DeltaChangedEvent;
import com.e1c.langtool.ui.tree.IDeltaListener;
import com.e1c.langtool.ui.tree.IFeatureTree;
import com.e1c.langtool.ui.tree.ITreeItem;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class QuerySelectionProvider
implements IPostSelectionProvider {
    private final IFeatureTree tree;
    private final Display display;
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private ListenerList<ISelectionChangedListener> postSelectionChangedListeners = new ListenerList();
    private IDeltaListener listner = new DeltaListener();
    private ISingleTranslationQuery query;

    public QuerySelectionProvider(IFeatureTree featureTree, Display display) {
        this.tree = featureTree;
        this.display = display;
        this.tree.addDeltaListener(this.listner);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.query == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.query);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object item : ss) {
                if (!(item instanceof ITreeItem)) continue;
                this.tree.setSelection((ITreeItem)item);
                return;
            }
        }
        this.tree.setSelection(null);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.remove((Object)listener);
    }

    public void fireQuery(ISingleTranslationQuery query) {
        this.query = query;
        this.handleSet();
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.selectionChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)listener;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    protected void firePostSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.postSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    private void handleSet() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)QuerySelectionProvider.this, QuerySelectionProvider.this.getSelection());
                    QuerySelectionProvider.this.firePostSelectionChanged(event);
                }
            });
        }
    }

    private class DeltaListener
    implements IDeltaListener {
        private DeltaListener() {
        }

        public void selectionChanged(DeltaChangedEvent event) {
            ITreeItem item = event.getSelection();
            if (item instanceof ISingleTranslationQuery) {
                QuerySelectionProvider.this.fireQuery((ISingleTranslationQuery)item);
            }
        }
    }
}

