/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.regex;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.regex.RegExFile;
import com.e1c.langtool.storage.regex.RegExUtil;
import com.e1c.langtool.storage.regex.model.RegExItem;
import com.e1c.langtool.storage.regex.model.RegExSettings;
import com.e1c.langtool.ui.editor.regex.CheckBoxLabelProvider;
import com.e1c.langtool.ui.editor.regex.Messages;
import com.e1c.langtool.ui.editor.regex.RegExGroup;
import com.e1c.langtool.ui.editor.regex.RegExGroupCheckStateProvider;
import com.e1c.langtool.ui.editor.regex.RegExGroupComputer;
import com.e1c.langtool.ui.editor.regex.RegExTranslationComputedValue;
import com.e1c.langtool.ui.internal.editor.EditorPlugin;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class RegExEditor
extends EditorPart {
    public static final String ID = "com.e1c.langtool.ui.editor.RegEx";
    private static final int TEXT_FIELD_WIDTH = 50;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    private final IObservableValue<TranslateLanguage> currentLanguage = new WritableValue();
    private TableViewer regExViewer;
    private final IObservableValue<RegExFile> currentFile = new WritableValue();
    private final IObservableValue<RegExSettings> settings = new WritableValue();
    private IObservableList<RegExItem> itemsInput;
    private DataBindingContext dbc;
    private IObservableList<RegExGroup> groupInput;
    private IObservableValue<String> currentRegEx;
    private IObservableValue<String> currentTestSource;
    private IObservableValue<Boolean> currentModel;
    private IObservableValue<Boolean> currentInterface;
    private FontMetrics fontMetrics;
    private Image titleImage;

    public void doSave(IProgressMonitor monitor) {
        if (this.currentFile.getValue() != null) {
            try {
                this.fixRemoveUnknownGroupsFromStorage((RegExFile)this.currentFile.getValue(), monitor);
                ((RegExFile)this.currentFile.getValue()).save(monitor);
            }
            catch (IOException e) {
                EditorPlugin.logError(e);
            }
            this.firePropertyChange(257);
        }
    }

    private void fixRemoveUnknownGroupsFromStorage(RegExFile file, IProgressMonitor monitor) {
        for (RegExItem item : file.getItems()) {
            if (monitor.isCanceled()) {
                return;
            }
            List groupNames = RegExUtil.getRegExGroups((RegExItem)item);
            Iterator iterator = item.getGroupsFromStorage().iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                String group = (String)iterator.next();
                if (groupNames.contains(group)) continue;
                iterator.remove();
            }
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.internalInit(site.getWorkbenchWindow(), site, input);
    }

    public boolean isDirty() {
        return this.currentFile.getValue() != null && ((RegExFile)this.currentFile.getValue()).isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        this.dbc = new DataBindingContext();
        this.addTopSection(composite);
        this.addSeparator(composite);
        this.addRegExTableSection(composite);
        this.addSeparator(composite);
        this.addRegExEditSection(composite);
        this.addRegExTranslationSection(composite);
        this.addCommentSection(composite);
        this.loadLanguages();
    }

    public void setFocus() {
        this.regExViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.dispose();
    }

    private final void internalInit(IWorkbenchWindow window, IEditorSite site, IEditorInput input) throws PartInitException {
        RegExFile regExFile = (RegExFile)input.getAdapter(RegExFile.class);
        if (regExFile == null) {
            throw new PartInitException(Messages.RegExEditor_Editor_could_not_be_initialized);
        }
        IRunnableWithProgress runnable = monitor -> {
            try {
                regExFile.load();
                this.currentFile.getRealm().exec(() -> {
                    this.currentFile.setValue((Object)regExFile);
                    this.settings.setValue((Object)((RegExSettings)regExFile.getData()));
                });
                this.doSetInput(input);
                this.loadLanguages();
            }
            catch (CoreException x) {
                throw new InvocationTargetException(x);
            }
        };
        try {
            window.run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            throw new PartInitException((IStatus)new Status(4, "com.e1c.langtool.ui.editor", 0, Messages.RegExEditor_Editor_could_not_be_initialized, t));
        }
    }

    private void doSetInput(IEditorInput input) throws CoreException {
        super.setInput(input);
        this.initializeTitle(input);
    }

    private void initializeTitle(IEditorInput input) {
        Image oldImage = this.titleImage;
        this.titleImage = null;
        String title = "";
        if (input != null) {
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
            ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
            this.titleImage = imageDesc != null ? imageDesc.createImage() : null;
            title = input.getName();
        }
        if (this.regExViewer != null && !this.regExViewer.getControl().isDisposed() && !this.regExViewer.getControl().getDisplay().isDisposed()) {
            this.regExViewer.getControl().getDisplay().asyncExec(() -> this.setTitleImage(this.titleImage));
        }
        this.setPartName(title);
        this.firePropertyChange(257);
        if (oldImage != null && !oldImage.isDisposed()) {
            oldImage.dispose();
        }
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addTopSection(Composite parent) {
        Composite top = this.createDefaultComposite(parent);
        Label langLable = new Label(top, 0);
        langLable.setText(Messages.RegExEditor_Selected_language);
        langLable.pack();
        Text language = new Text(top, 2056);
        language.setText(Messages.RegExEditor_Not_found);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)language);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)language), this.currentLanguage, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(IConverter.create(l -> {
            if (l == null) {
                return Messages.RegExEditor_Not_found;
            }
            return StringUtils.isNullOrEmpty((String)l.getPresentation()) ? l.getName() : l.getPresentation();
        })));
    }

    private void addCommentSection(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.RegExEditor_File_comment);
        group.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).minSize(50, 70).applyTo((Control)group);
        Text commentText = new Text((Composite)group, 2626);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commentText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)commentText), BeanProperties.value(RegExSettings.class, (String)"comment", String.class).observeDetail(this.settings));
        PropertyChangeListener itemChange = event -> {
            if (this.currentFile.getValue() != null) {
                ((RegExFile)this.currentFile.getValue()).markDirty();
            }
            this.firePropertyChange(257);
        };
        this.settings.addValueChangeListener(event -> {
            RegExSettings newValue;
            RegExSettings old = (RegExSettings)event.diff.getOldValue();
            if (old != null) {
                old.removePropertyChangeListener(itemChange);
            }
            if ((newValue = (RegExSettings)event.diff.getNewValue()) != null) {
                newValue.addPropertyChangeListener(itemChange);
            }
        });
        if (this.settings.getValue() != null) {
            ((RegExSettings)this.settings.getValue()).addPropertyChangeListener(itemChange);
        }
    }

    private void loadLanguages() {
        this.currentLanguage.getRealm().exec(() -> {
            this.currentLanguage.setValue(null);
            RegExFile regExFile = (RegExFile)this.currentFile.getValue();
            if (regExFile == null) {
                return;
            }
            Collection languages = this.translatingProjectManager.getLanguagesForExternalProject(regExFile.getFile().getProject());
            for (TranslateLanguage language : languages) {
                if (!language.getLanguageCode().equals(((RegExSettings)regExFile.getData()).getLanguageCode())) continue;
                this.currentLanguage.setValue((Object)language);
                break;
            }
        });
    }

    private void addRegExTableSection(Composite parent) {
        Font font = parent.getFont();
        Composite composite = this.createDefaultComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComposite = this.createDefaultComposite(composite);
        ((GridLayout)tableComposite.getLayout()).numColumns = 1;
        tableComposite.setLayoutData((Object)new GridData(1808));
        this.regExViewer = new TableViewer(tableComposite, 68352);
        Table table = this.regExViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewerColumn column = new TableViewerColumn(this.regExViewer, 0);
        column.getColumn().setText(Messages.RegExEditor_Description);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 150));
        column.getColumn().setMoveable(true);
        column.setEditingSupport((EditingSupport)new InlineEditingSupport((ColumnViewer)this.regExViewer, this.dbc));
        TableViewerColumn column2 = new TableViewerColumn(this.regExViewer, 0x1000000);
        column2.getColumn().setText(Messages.RegExEditor_Model_title);
        column2.getColumn().setToolTipText(Messages.RegExEditor_If_checked_regular_expression_available_for_model_features);
        column2.getColumn().setResizable(false);
        tableColumnLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnPixelData(30, false));
        column2.getColumn().setMoveable(true);
        TableViewerColumn column3 = new TableViewerColumn(this.regExViewer, 0x1000000);
        column3.getColumn().setText(Messages.RegExEditor_Interface_title);
        column3.getColumn().setToolTipText(Messages.RegExEditor_If_checked_regular_expression_available_for_interface_features);
        column3.getColumn().setResizable(false);
        tableColumnLayout.setColumnData((Widget)column3.getColumn(), (ColumnLayoutData)new ColumnPixelData(30, false));
        column3.getColumn().setMoveable(true);
        TableViewerColumn column4 = new TableViewerColumn(this.regExViewer, 0);
        column4.getColumn().setText(Messages.RegExEditor_RegEx);
        tableColumnLayout.setColumnData((Widget)column4.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 150));
        column4.getColumn().setMoveable(true);
        TableViewerColumn column5 = new TableViewerColumn(this.regExViewer, 0);
        column5.getColumn().setText(Messages.RegExEditor_Translation_template);
        tableColumnLayout.setColumnData((Widget)column5.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 150));
        column5.getColumn().setMoveable(true);
        this.itemsInput = new RegExItemInputList(this.currentFile);
        IBeanValueProperty[] labelProperties = BeanProperties.values((String[])new String[]{"description", "model", "interface", "regEx", "translation"});
        ViewerSupport.bind((StructuredViewer)this.regExViewer, this.itemsInput, (IValueProperty[])labelProperties);
        ObservableListContentProvider provider = (ObservableListContentProvider)this.regExViewer.getContentProvider();
        IObservableMap attribute = labelProperties[1].observeDetail(provider.getKnownElements());
        column2.setLabelProvider((CellLabelProvider)new CheckBoxLabelProvider((ColumnViewer)this.regExViewer, attribute));
        IObservableMap attribute2 = labelProperties[2].observeDetail(provider.getKnownElements());
        column3.setLabelProvider((CellLabelProvider)new CheckBoxLabelProvider((ColumnViewer)this.regExViewer, attribute2));
        if (!this.itemsInput.isEmpty()) {
            this.regExViewer.setInput(this.itemsInput);
        }
        Composite buttons = this.createDefaultComposite(composite);
        ((GridLayout)buttons.getLayout()).numColumns = 1;
        final Button addButton = this.createButton(buttons, Messages.RegExEditor_Add);
        addButton.setEnabled(false);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (addButton.isEnabled()) {
                    RegExEditor.this.addNewRegeExItem();
                }
            }
        });
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)addButton), this.currentLanguage, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter(IConverter.create(Objects::nonNull)));
        final Button removeButton = this.createButton(buttons, Messages.RegExEditor_Remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (removeButton.isEnabled()) {
                    RegExEditor.this.removeRegeExItem(RegExEditor.this.regExViewer.getStructuredSelection());
                }
            }
        });
        this.regExViewer.addSelectionChangedListener(event -> {
            IStructuredSelection sel = event.getStructuredSelection();
            removeButton.setEnabled(sel != null && !sel.isEmpty());
        });
        final Button upButton = this.createButton(buttons, Messages.RegExEditor_Up);
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (upButton.isEnabled()) {
                    RegExEditor.this.moveItem(RegExEditor.this.regExViewer.getStructuredSelection(), true);
                }
            }
        });
        final Button downButton = this.createButton(buttons, Messages.RegExEditor_Down);
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (downButton.isEnabled()) {
                    RegExEditor.this.moveItem(RegExEditor.this.regExViewer.getStructuredSelection(), false);
                }
            }
        });
        this.regExViewer.addSelectionChangedListener(event -> {
            IStructuredSelection sel = event.getStructuredSelection();
            boolean up = false;
            boolean down = false;
            if (sel != null && !sel.isEmpty() && this.currentFile.getValue() != null) {
                Object obj2 = sel.getFirstElement();
                RegExFile file = (RegExFile)this.currentFile.getValue();
                up = file.getItems().indexOf(obj2) > 0;
                for (Object obj2 : sel) {
                }
                down = file.getItems().indexOf(obj2) < file.getItems().size() - 1;
            }
            upButton.setEnabled(up);
            downButton.setEnabled(down);
        });
    }

    private void addNewRegeExItem() {
        if (this.currentFile.getValue() != null) {
            RegExItem item = new RegExItem();
            item.setDescription(MessageFormat.format(Messages.RegExEditor_Reg_ex, ((RegExFile)this.currentFile.getValue()).getItems().size() + 1));
            item.setModel(true);
            item.setInterface(true);
            this.itemsInput.add((Object)item);
            this.firePropertyChange(257);
            this.regExViewer.setSelection((ISelection)new StructuredSelection((Object)item));
        }
    }

    private void moveItem(IStructuredSelection ss, boolean up) {
        int index = this.itemsInput.indexOf(ss.getFirstElement());
        if (up && index > 0) {
            this.itemsInput.move(index, index - 1);
        } else if (!up && index < this.itemsInput.size() - 1) {
            this.itemsInput.move(index, index + 1);
        }
        this.firePropertyChange(257);
    }

    private void removeRegeExItem(IStructuredSelection selection) {
        if (this.currentFile.getValue() != null) {
            for (Object item : selection) {
                if (!(item instanceof RegExItem)) continue;
                this.itemsInput.remove(item);
            }
        }
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return button;
    }

    private void addRegExEditSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        IViewerObservableValue selection = ViewerProperties.singleSelection(RegExItem.class).observe((Viewer)this.regExViewer);
        PropertyChangeListener itemChange = event -> {
            if (this.currentFile.getValue() != null) {
                ((RegExFile)this.currentFile.getValue()).markDirty();
            }
            this.firePropertyChange(257);
        };
        selection.addValueChangeListener(event -> {
            RegExItem newItem;
            RegExItem old = (RegExItem)event.diff.getOldValue();
            if (old != null) {
                old.removePropertyChangeListener(itemChange);
            }
            if ((newItem = (RegExItem)event.diff.getNewValue()) != null) {
                newItem.addPropertyChangeListener(itemChange);
            }
        });
        this.regExViewer.addSelectionChangedListener(event -> {
            IStructuredSelection sel = event.getStructuredSelection();
            composite.setEnabled(sel != null && !sel.isEmpty());
        });
        Composite fields = this.createDefaultComposite(composite);
        ((GridLayout)fields.getLayout()).numColumns = 1;
        Label regExLabel = new Label(fields, 0);
        regExLabel.setText(Messages.RegExEditor_Regular_expression);
        Text regExtText = new Text(fields, 2052);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        regExtText.setLayoutData((Object)gd);
        this.currentRegEx = BeanProperties.value(RegExItem.class, (String)"regEx", String.class).observeDetail((IObservableValue)selection);
        IValidator validator1 = arg_0 -> RegExEditor.lambda$13((IObservableValue)selection, arg_0);
        UpdateValueStrategy targetToModel1 = new UpdateValueStrategy();
        targetToModel1.setBeforeSetValidator(validator1);
        Binding bindValue1 = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)regExtText), this.currentRegEx, targetToModel1, null);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue1, (int)16512);
        Label testStringLabel = new Label(fields, 0);
        testStringLabel.setText(Messages.RegExEditor_Test_source_string);
        Text testStringText = new Text(fields, 2052);
        GridData gd2 = new GridData();
        gd2.widthHint = this.convertWidthInCharsToPixels(50);
        testStringText.setLayoutData((Object)gd2);
        this.currentTestSource = BeanProperties.value(RegExItem.class, (String)"testString", String.class).observeDetail((IObservableValue)selection);
        UpdateValueStrategy targetToModel2 = new UpdateValueStrategy();
        IValidator validator2 = arg_0 -> RegExEditor.lambda$14((IObservableValue)selection, arg_0);
        targetToModel2.setBeforeSetValidator(validator2);
        Binding bindValue2 = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)testStringText), this.currentTestSource, targetToModel2, null);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue2, (int)16512);
        Group usesCheckBoxes = new Group(composite, 16);
        usesCheckBoxes.setText(Messages.RegExEditor_Use_Regular_expression_for);
        usesCheckBoxes.setLayout((Layout)new GridLayout(2, false));
        usesCheckBoxes.setLayoutData((Object)new GridData(4, 4, true, false));
        Button modelButton = this.createCheckbox((Composite)usesCheckBoxes, Messages.RegExEditor_Model_strings, "model", false);
        Button interfaceButton = this.createCheckbox((Composite)usesCheckBoxes, Messages.RegExEditor_Interface_strings, "interface", false);
        this.currentModel = BeanProperties.value(RegExItem.class, (String)"model", Boolean.class).observeDetail((IObservableValue)selection);
        IConverter converter = IConverter.create(Boolean.class, Boolean.class, s -> {
            if (s == null) {
                return false;
            }
            return s;
        });
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)modelButton), this.currentModel, new UpdateValueStrategy().setConverter(converter), new UpdateValueStrategy().setConverter(converter));
        this.currentInterface = BeanProperties.value(RegExItem.class, (String)"interface", Boolean.class).observeDetail((IObservableValue)selection);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)interfaceButton), this.currentInterface, new UpdateValueStrategy().setConverter(converter), new UpdateValueStrategy().setConverter(converter));
    }

    private Button createCheckbox(Composite parent, String label, String key, boolean isCheck) {
        final Button but = new Button(parent, 32);
        but.setData((Object)key);
        but.setSelection(isCheck);
        but.pack();
        Label buttonLabel = new Label(parent, 0);
        buttonLabel.setText(label);
        buttonLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                but.setSelection(!but.getSelection());
                but.notifyListeners(13, new Event());
            }
        });
        buttonLabel.pack();
        return but;
    }

    private void addRegExTranslationSection(Composite parent) {
        Font font = parent.getFont();
        IViewerObservableValue selection = ViewerProperties.singleSelection(RegExItem.class).observe((Viewer)this.regExViewer);
        Composite composite = this.createDefaultComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).minSize(100, 50).applyTo((Control)composite);
        this.regExViewer.addSelectionChangedListener(event -> {
            IStructuredSelection sel = event.getStructuredSelection();
            composite.setEnabled(sel != null && !sel.isEmpty());
        });
        Group groups = new Group(composite, 16);
        groups.setText(Messages.RegExEditor_Get_Regular_expression_groups_form_dictionary);
        groups.setToolTipText(Messages.RegExEditor_Get_Regular_expression_groups_form_dictionary);
        GridLayout layout = new GridLayout();
        layout.marginTop = 4;
        groups.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).minSize(50, 80).applyTo((Control)groups);
        Composite tableComposite = new Composite((Composite)groups, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        GridDataFactory.fillDefaults().grab(true, true).minSize(50, 100).applyTo((Control)tableComposite);
        CheckboxTableViewer groupViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)68354);
        groupViewer.setCheckStateProvider((ICheckStateProvider)new RegExGroupCheckStateProvider((IObservableValue<RegExItem>)selection));
        Table table = groupViewer.getTable();
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setToolTipText(Messages.RegExEditor_Get_Regular_expression_groups_form_dictionary);
        TableViewerColumn column = new TableViewerColumn((TableViewer)groupViewer, 0);
        column.getColumn().setText(Messages.RegExEditor_Group);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100));
        column.getColumn().setMoveable(true);
        TableViewerColumn column2 = new TableViewerColumn((TableViewer)groupViewer, 0);
        column2.getColumn().setText(Messages.RegExEditor_Test_source);
        tableColumnLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100));
        column2.getColumn().setMoveable(true);
        TableViewerColumn column3 = new TableViewerColumn((TableViewer)groupViewer, 0);
        column3.getColumn().setText(Messages.RegExEditor_Translation);
        tableColumnLayout.setColumnData((Widget)column3.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100));
        column3.getColumn().setMoveable(true);
        this.groupInput = new WritableList();
        ViewerSupport.bind((StructuredViewer)groupViewer, this.groupInput, (IValueProperty[])BeanProperties.values((String[])new String[]{"name", "testSource", "translation"}));
        RegExGroupComputer groupsComputer = new RegExGroupComputer(this.currentFile, this.groupInput, (IObservableValue<RegExItem>)selection, this.currentLanguage, this.storageManager, this.translatingProjectManager, this.storageSettingsManager);
        this.dbc.bindValue((IObservableValue)groupsComputer, this.currentRegEx, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        this.dbc.bindValue((IObservableValue)groupsComputer, this.currentTestSource, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        this.dbc.bindValue((IObservableValue)groupsComputer, this.currentModel, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        this.dbc.bindValue((IObservableValue)groupsComputer, this.currentInterface, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        groupViewer.addCheckStateListener(arg_0 -> this.lambda$17((IObservableValue)selection, groupsComputer, arg_0));
        Composite translations = this.createDefaultComposite(composite);
        ((GridLayout)translations.getLayout()).numColumns = 1;
        GridDataFactory.fillDefaults().grab(true, true).minSize(50, 200).applyTo((Control)translations);
        Label translationLabel = new Label(translations, 0);
        translationLabel.setText(Messages.RegExEditor_Translation_template);
        Composite translationField = this.createDefaultComposite(translations);
        Button button = new Button(translationField, 8);
        button.setFont(translationField.getFont());
        button.setText("->");
        button.setToolTipText(Messages.RegExEditor_Add_all_or_selected_RegEx_groups_to_translation_template);
        button.setEnabled(false);
        this.groupInput.addChangeListener(event -> button.setEnabled(!this.groupInput.isEmpty()));
        button.addSelectionListener((SelectionListener)new SelectionAdapter((IObservableValue)selection, groupViewer){
            private final /* synthetic */ IObservableValue val$selection;
            private final /* synthetic */ CheckboxTableViewer val$groupViewer;
            {
                this.val$selection = iObservableValue;
                this.val$groupViewer = checkboxTableViewer;
            }

            public void widgetSelected(SelectionEvent e) {
                if (!RegExEditor.this.groupInput.isEmpty() && this.val$selection.getValue() != null) {
                    String translation = ((RegExItem)this.val$selection.getValue()).getTranslation();
                    if (StringUtils.isNullOrEmpty((String)translation)) {
                        translation = "";
                    }
                    StringBuilder sb = new StringBuilder(translation);
                    IStructuredSelection ss = this.val$groupViewer.getStructuredSelection();
                    if (ss == null || ss.isEmpty()) {
                        for (RegExGroup group : RegExEditor.this.groupInput) {
                            sb.append(group.getName());
                        }
                    } else {
                        for (RegExGroup group : ss) {
                            sb.append(group.getName());
                        }
                    }
                    ((RegExItem)this.val$selection.getValue()).setTranslation(sb.toString());
                }
            }
        });
        Text translationText = new Text(translationField, 2052);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        translationText.setLayoutData((Object)gd);
        IObservableValue translationObservable = BeanProperties.value(RegExItem.class, (String)"translation", String.class).observeDetail((IObservableValue)selection);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)translationText), translationObservable);
        Label reslultLabel = new Label(translations, 0);
        reslultLabel.setText(Messages.RegExEditor_Test_string_translation_result);
        Text resultText = new Text(translations, 2060);
        GridData gd2 = new GridData();
        gd2.widthHint = this.convertWidthInCharsToPixels(50);
        resultText.setLayoutData((Object)gd2);
        RegExTranslationComputedValue translation = new RegExTranslationComputedValue(this.groupInput, (IObservableValue<RegExItem>)selection);
        this.dbc.bindValue((IObservableValue)translation, (IObservableValue)groupsComputer, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        this.dbc.bindValue((IObservableValue)translation, translationObservable, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        PropertyChangeListener listener = arg_0 -> RegExEditor.lambda$19((IObservableValue)translation, arg_0);
        this.groupInput.addListChangeListener(arg_0 -> RegExEditor.lambda$20(listener, (IObservableValue)translation, arg_0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)resultText), (IObservableValue)translation, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
    }

    private int convertWidthInCharsToPixels(int chars) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)chars);
    }

    private int convertHorizontalDLUsToPixels(int dlus) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)dlus);
    }

    private static /* synthetic */ IStatus lambda$13(IObservableValue iObservableValue, String s) {
        if (StringUtils.isNotEmpty((String)s)) {
            try {
                Pattern.compile(s);
            }
            catch (PatternSyntaxException e) {
                return ValidationStatus.error((String)e.getLocalizedMessage());
            }
        } else if (iObservableValue.getValue() != null) {
            return ValidationStatus.warning((String)Messages.RegExEditor_Regular_expression_cannot_be_empty);
        }
        return ValidationStatus.ok();
    }

    private static /* synthetic */ IStatus lambda$14(IObservableValue iObservableValue, String s) {
        Matcher matcher;
        if (StringUtils.isBlank((String)s) && iObservableValue.getValue() != null) {
            return ValidationStatus.warning((String)Messages.RegExEditor_Test_string_cannot_be_empty);
        }
        if (iObservableValue.getValue() != null && ((RegExItem)iObservableValue.getValue()).getPattern() != null && !(matcher = ((RegExItem)iObservableValue.getValue()).getPattern().matcher(s)).matches()) {
            return ValidationStatus.error((String)Messages.RegExEditor_Test_string_is_not_valid_for_expression);
        }
        return ValidationStatus.ok();
    }

    private /* synthetic */ void lambda$17(IObservableValue iObservableValue, RegExGroupComputer regExGroupComputer, CheckStateChangedEvent event) {
        if (iObservableValue.getValue() != null && event.getElement() instanceof RegExGroup) {
            RegExItem item = (RegExItem)iObservableValue.getValue();
            RegExGroup element = (RegExGroup)event.getElement();
            if (event.getChecked()) {
                if (!item.getGroupsFromStorage().contains(element.getName())) {
                    item.getGroupsFromStorage().add(element.getName());
                }
            } else {
                item.getGroupsFromStorage().remove(element.getName());
            }
            Collections.sort(item.getGroupsFromStorage());
            ((RegExFile)this.currentFile.getValue()).markDirty();
            this.firePropertyChange(257);
            regExGroupComputer.updateTranslation(element);
        }
    }

    private static /* synthetic */ void lambda$19(IObservableValue iObservableValue, PropertyChangeEvent event) {
        if (event.getPropertyName().equals("translation")) {
            iObservableValue.setValue(null);
        }
    }

    private static /* synthetic */ void lambda$20(PropertyChangeListener propertyChangeListener, IObservableValue iObservableValue, ListChangeEvent event) {
        boolean hasdeletion = false;
        int i = 0;
        while (i < event.diff.getDifferences().length) {
            ListDiffEntry diff = event.diff.getDifferences()[i];
            if (diff.isAddition()) {
                ((RegExGroup)diff.getElement()).addPropertyChangeListener(propertyChangeListener);
            } else {
                hasdeletion = true;
            }
            ++i;
        }
        if (hasdeletion) {
            iObservableValue.setValue(null);
        }
    }

    private static class InlineEditingSupport
    extends ObservableValueEditingSupport<RegExItem, String, String> {
        private CellEditor cellEditor;

        public InlineEditingSupport(ColumnViewer viewer, DataBindingContext dbc) {
            super(viewer, dbc);
            this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected IObservableValue<String> doCreateCellEditorObservable(CellEditor cellEditor) {
            return WidgetProperties.text((int)24).observe((Widget)cellEditor.getControl());
        }

        protected IObservableValue<String> doCreateElementObservable(RegExItem element, ViewerCell cell) {
            return BeanProperties.value(RegExItem.class, (String)"description", String.class).observe((Object)element);
        }
    }

    private class RegExItemInputList
    extends WritableList<RegExItem> {
        private final IObservableValue<RegExFile> file;
        private AtomicBoolean isUpdate = new AtomicBoolean(false);

        public RegExItemInputList(IObservableValue<RegExFile> file) {
            this.file = file;
            this.file.addValueChangeListener(event -> {
                this.isUpdate.set(true);
                if (event.getObservableValue().getValue() == null) {
                    this.wrappedList = new ArrayList();
                    this.clear();
                } else {
                    this.setNewList(((RegExFile)file.getValue()).getItems());
                }
                this.isUpdate.set(false);
            });
            this.addChangeListener(event -> {
                if (!this.isUpdate.get() && file.getValue() != null) {
                    ((RegExFile)file.getValue()).markDirty();
                    RegExEditor.this.firePropertyChange(257);
                }
            });
            if (file.getValue() != null) {
                this.isUpdate.set(true);
                this.setNewList(((RegExFile)file.getValue()).getItems());
                this.isUpdate.set(false);
            }
        }

        private void setNewList(List<RegExItem> list) {
            ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>(this.wrappedList.size() + list.size());
            int addIndex = 0;
            for (RegExItem element : this.wrappedList) {
                entries.add(Diffs.createListDiffEntry((int)addIndex++, (boolean)false, (Object)element));
            }
            this.wrappedList = list;
            addIndex = 0;
            for (RegExItem element : this.wrappedList) {
                entries.add(Diffs.createListDiffEntry((int)addIndex++, (boolean)true, (Object)element));
            }
            this.fireListChange(Diffs.createListDiff(entries));
        }
    }
}

