/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.regex;

import com.e1c.langtool.DictionaryTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslateProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.CommonFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.TranslationStorageUtils;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.e1c.langtool.storage.regex.RegExFile;
import com.e1c.langtool.storage.regex.RegExUtil;
import com.e1c.langtool.storage.regex.model.RegExItem;
import com.e1c.langtool.ui.editor.regex.RegExGroup;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class RegExGroupComputer
extends AbstractObservableValue<Object> {
    private static final String FEATURE_SETTINGS_NAME = "name";
    private final IObservableValue<RegExFile> currentFile;
    private final IObservableList<RegExGroup> groupsModel;
    private final IObservableValue<RegExItem> currentItem;
    private final IObservableValue<TranslateLanguage> currentLanguage;
    private final ITranslationStorageManager storageManager;
    private final ITranslatingProjectManager translatingProjectManager;
    private final IStorageSettingsManager storageSettingsManager;
    private DictionaryStorageSettings settings;
    private FeatureSettings modelFeatueSettings;
    private FeatureSettings interfaceFeatureSettings = new CommonFeatureSettings.Builder().setFeature("name").setInterface().build();

    public RegExGroupComputer(IObservableValue<RegExFile> currentFile, IObservableList<RegExGroup> groups, IObservableValue<RegExItem> item, IObservableValue<TranslateLanguage> currentLanguage, ITranslationStorageManager storageManager, ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager) {
        this.currentFile = currentFile;
        this.groupsModel = groups;
        this.currentItem = item;
        this.currentLanguage = currentLanguage;
        this.storageManager = storageManager;
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
    }

    public Object getValueType() {
        return Object.class;
    }

    protected Object doGetValue() {
        return null;
    }

    protected void doSetValue(Object value) {
        if (this.currentItem.getValue() == null) {
            this.groupsModel.clear();
            return;
        }
        List groupNames = RegExUtil.getRegExGroups((RegExItem)((RegExItem)this.currentItem.getValue()));
        Pattern pattern = ((RegExItem)this.currentItem.getValue()).getPattern();
        Matcher matcher = null;
        if (pattern != null && ((RegExItem)this.currentItem.getValue()).getTestString() != null) {
            matcher = pattern.matcher(((RegExItem)this.currentItem.getValue()).getTestString());
        }
        int current = 0;
        while (current < groupNames.size()) {
            String groupName = (String)groupNames.get(current);
            RegExGroup element = this.getOrCreateElement(current);
            element.setName(groupName);
            element.setTestSource(this.getTestSource(matcher, groupName));
            this.updateTranslation(element);
            ++current;
        }
        while (current < this.groupsModel.size()) {
            this.groupsModel.remove(current);
        }
        Iterator iterator = ((RegExItem)this.currentItem.getValue()).getGroupsFromStorage().iterator();
        while (iterator.hasNext()) {
            String group = (String)iterator.next();
            if (groupNames.contains(group)) continue;
            iterator.remove();
        }
    }

    public void updateTranslation(RegExGroup element) {
        element.setTranslation(this.getTranslation(element));
    }

    private RegExGroup getOrCreateElement(int i) {
        if (i < this.groupsModel.size()) {
            return (RegExGroup)this.groupsModel.get(i);
        }
        RegExGroup element = new RegExGroup();
        this.groupsModel.add((Object)element);
        return element;
    }

    private String getTestSource(Matcher matcher, String groupName) {
        if (matcher == null || groupName == null) {
            return "";
        }
        return RegExUtil.getGroupSource((Matcher)matcher, (String)groupName);
    }

    private String getTranslation(RegExGroup element) {
        IProject external;
        IProject project;
        IProjectTranslationReader reader;
        String translation;
        TranslateLanguage language = (TranslateLanguage)this.currentLanguage.getValue();
        RegExItem item = (RegExItem)this.currentItem.getValue();
        RegExFile fileEditor = (RegExFile)this.currentFile.getValue();
        if (language == null || item == null || fileEditor == null) {
            return "";
        }
        if (!item.getGroupsFromStorage().contains(element.getName())) {
            return element.getTestSource();
        }
        DictionaryTranslationKey source = null;
        if (item.isModel()) {
            source = new DictionaryTranslationKey(this.getModelFeatueSettings(), element.getTestSource());
        } else if (item.isInterface()) {
            source = new DictionaryTranslationKey(this.getInterfaceFeatureSettings(), element.getTestSource());
        }
        if (source != null && StringUtils.isNotEmpty((String)(translation = (reader = this.storageManager.getTranslationReader(project = this.translatingProjectManager.getTranslatingForExternalProject(external = fileEditor.getFile().getProject()).map(ITranslateProject::getProject).orElse(external))).getStoredTranslation((TranslationKey)source, language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.COMMON})))) {
            return translation;
        }
        return "";
    }

    private DictionaryStorageSettings getSettings() {
        if (this.settings == null) {
            RegExFile fileEditor = (RegExFile)this.currentFile.getValue();
            TranslateLanguage language = (TranslateLanguage)this.currentLanguage.getValue();
            if (fileEditor != null && language != null) {
                IFile file = fileEditor.getFile();
                IPath path = file.getProjectRelativePath();
                IProject external = file.getProject();
                IProject project = this.translatingProjectManager.getTranslatingForExternalProject(external).map(ITranslateProject::getProject).orElse(external);
                for (Map.Entry entry : this.storageSettingsManager.getSettingsOrDefault(project).allStorageSettings().entrySet()) {
                    DictionaryStorageSettings currentSettings;
                    IPath settingsPath;
                    if (!(entry.getValue() instanceof DictionaryStorageSettings) || !"dict-regex".equals(((DictionaryStorageSettings)entry.getValue()).getFormat()) || !path.equals((Object)(settingsPath = TranslationStorageUtils.getDictionaryFilePath((DictionaryStorageSettings)(currentSettings = (DictionaryStorageSettings)entry.getValue()), (TranslateLanguage)language)))) continue;
                    this.settings = currentSettings;
                    break;
                }
            }
        }
        return this.settings;
    }

    private FeatureSettings getModelFeatueSettings() {
        if (this.modelFeatueSettings == null) {
            CommonFeatureSettings.Builder builder = new CommonFeatureSettings.Builder().setFeature(FEATURE_SETTINGS_NAME).setModel();
            DictionaryStorageSettings current = this.getSettings();
            if (current != null) {
                StorageSettingsUtils.appendFeatureSettingsByStorage((CommonFeatureSettings.Builder)builder, (StorageSettings)current);
            }
            this.modelFeatueSettings = builder.build();
        }
        return this.modelFeatueSettings;
    }

    private FeatureSettings getInterfaceFeatureSettings() {
        if (this.interfaceFeatureSettings == null) {
            CommonFeatureSettings.Builder builder = new CommonFeatureSettings.Builder().setFeature(FEATURE_SETTINGS_NAME).setInterface();
            DictionaryStorageSettings current = this.getSettings();
            if (current != null) {
                StorageSettingsUtils.appendFeatureSettingsByStorage((CommonFeatureSettings.Builder)builder, (StorageSettings)current);
            }
            this.interfaceFeatureSettings = builder.build();
        }
        return this.interfaceFeatureSettings;
    }
}

