/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.regex.wizard;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.TranslationStorageUtils;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import com.e1c.langtool.ui.editor.regex.wizard.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SmartRegExNewWizardPage
extends WizardPage {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IStorageSettingsManager storageSettingsManager;
    private final IObservableValue<ITranslatingProject> translatingProject = new WritableValue();
    private final IObservableValue<TranslateLanguage> language = new WritableValue();
    private final IObservableValue<Boolean> createNewSettings = new WritableValue();
    private final IObservableValue<DictionaryStorageSettings> dictionarySettings = new WritableValue();
    private final IObservableValue<String> fileExtensionValue = PojoProperties.value(ResourceStorageSettings.class, (String)"fileExtension", String.class).observeDetail(this.dictionarySettings);
    private final IObservableValue<String> filePathValue = PojoProperties.value(DictionaryStorageSettings.class, (String)"filePath", String.class).observeDetail(this.dictionarySettings);
    private final IObservableValue<String> file = new FilePathComputer();
    private DataBindingContext dbc;

    public SmartRegExNewWizardPage(ITranslatingProject translatingProject, ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager) {
        super("SmartRegExNewWizardPage");
        this.setTitle(Messages.SmartRegExNewWizardPage_title);
        this.setDescription(Messages.SmartRegExNewWizardPage_description);
        this.translatingProject.setValue((Object)translatingProject);
        this.createNewSettings.setValue((Object)false);
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
    }

    public ITranslatingProject getTranslatingProject() {
        return (ITranslatingProject)this.translatingProject.getValue();
    }

    public TranslateLanguage getLanguage() {
        return (TranslateLanguage)this.language.getValue();
    }

    public ResourceStorageSettings getResourceSettings() {
        return (ResourceStorageSettings)this.dictionarySettings.getValue();
    }

    public boolean getCreateNewSettings() {
        return (Boolean)this.createNewSettings.getValue();
    }

    public void createControl(Composite parent) {
        this.dbc = new DataBindingContext();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        this.addProjectSection(composite);
        this.addSeparator(composite);
        this.addSettingsSection(composite);
        this.addSeparator(composite);
        this.addFileSection(composite);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        for (ValidationStatusProvider provider : this.dbc.getValidationStatusProviders()) {
            IStatus status = (IStatus)provider.getValidationStatus().getValue();
            if (status.isOK()) continue;
            this.setErrorMessage(status.getMessage());
            break;
        }
        this.setControl((Control)composite);
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addProjectSection(Composite composite) {
        Composite top = this.createDefaultComposite(composite);
        Label label = new Label(top, 0);
        label.setText(Messages.SmartRegExNewWizardPage_Translating_project);
        label = new Label(top, 0);
        label.setText(Messages.SmartRegExNewWizardPage_Language);
        ListViewer projectViewer = new ListViewer(top, 2820);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(projectViewer.getControl());
        projectViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        projectViewer.setInput(this.getProjectInput());
        UpdateValueStrategy updateStrategy = new UpdateValueStrategy();
        updateStrategy.setAfterGetValidator(project -> {
            if (project == null) {
                return ValidationStatus.error((String)Messages.SmartRegExNewWizardPage_Select_translating_project);
            }
            return ValidationStatus.ok();
        });
        Binding binding = this.dbc.bindValue((IObservableValue)ViewerProperties.singlePostSelection(ITranslatingProject.class).observe((Viewer)projectViewer), this.translatingProject, updateStrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        ListViewer languageViewer = new ListViewer(top, 2820);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(languageViewer.getControl());
        IObservableList languageInput = PojoProperties.list(ITranslatingProject.class, (String)"interfaceLanguages", TranslateLanguage.class).observeDetail(this.translatingProject);
        ViewerSupport.bind((StructuredViewer)languageViewer, (IObservableList)languageInput, (IValueProperty)PojoProperties.value(TranslateLanguage.class, (String)"name"));
        UpdateValueStrategy updateStrategy2 = new UpdateValueStrategy();
        updateStrategy2.setAfterGetValidator(lang -> {
            if (lang == null) {
                return ValidationStatus.error((String)Messages.SmartRegExNewWizardPage_Select_translate_language);
            }
            return ValidationStatus.ok();
        });
        binding = this.dbc.bindValue((IObservableValue)ViewerProperties.singlePostSelection(TranslateLanguage.class).observe((Viewer)languageViewer), this.language, updateStrategy2, null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        languageInput.addChangeListener(e -> {
            if (this.translatingProject.getValue() != null && languageInput.size() == 1) {
                languageViewer.setSelection((ISelection)new StructuredSelection(languageInput.get(0)), true);
                this.language.setValue((Object)((TranslateLanguage)languageInput.get(0)));
            }
        });
    }

    private List<ITranslatingProject> getProjectInput() {
        ArrayList<ITranslatingProject> result = new ArrayList<ITranslatingProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            ITranslatingProject translating = this.translatingProjectManager.getProject(project);
            if (translating.isTranslating()) {
                result.add(translating);
            }
            ++i;
        }
        return result;
    }

    private void addSettingsSection(Composite composite) {
        Composite top = this.createDefaultComposite(composite);
        Group createNewSettingsGroup = new Group(top, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        createNewSettingsGroup.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)createNewSettingsGroup);
        createNewSettingsGroup.setText(Messages.SmartRegExNewWizardPage_Storage_segment);
        SelectObservableValue selectRadioButtons = new SelectObservableValue();
        Button button1 = new Button((Composite)createNewSettingsGroup, 16);
        button1.setText(Messages.SmartRegExNewWizardPage_select_existing);
        selectRadioButtons.addOption((Object)false, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)button1));
        Button button2 = new Button((Composite)createNewSettingsGroup, 16);
        button2.setText(Messages.SmartRegExNewWizardPage_create_new_segment);
        selectRadioButtons.addOption((Object)true, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)button2));
        this.dbc.bindValue((IObservableValue)selectRadioButtons, this.createNewSettings);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)button2), this.createNewSettings);
        Label label = new Label(top, 0);
        label.setText(Messages.SmartRegExNewWizardPage_Dictionary_segments);
        ListViewer settingsViewer = new ListViewer(top, 2820);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(settingsViewer.getControl());
        ComputedList<DictionaryStorageSettings> computableList = new ComputedList<DictionaryStorageSettings>(){

            protected List<DictionaryStorageSettings> calculate() {
                ITranslatingProject project = (ITranslatingProject)SmartRegExNewWizardPage.this.translatingProject.getValue();
                if (project == null) {
                    return new ArrayList<DictionaryStorageSettings>();
                }
                return SmartRegExNewWizardPage.this.storageSettingsManager.getSettingsOrDefault(project.getProject()).getDictionarySettings().stream().filter(s -> "dict-regex".equals(s.getFormat())).collect(Collectors.toList());
            }
        };
        ViewerSupport.bind((StructuredViewer)settingsViewer, (IObservableList)computableList, (IValueProperty)PojoProperties.value(ResourceStorageSettings.class, (String)"presentation", String.class));
        IValidator settingValidator = settings -> {
            if (!((Boolean)this.createNewSettings.getValue()).booleanValue() && settings == null) {
                return ValidationStatus.error((String)Messages.SmartRegExNewWizardPage_Select_storage_settings);
            }
            return ValidationStatus.ok();
        };
        UpdateValueStrategy updateStorageStrategy = new UpdateValueStrategy();
        updateStorageStrategy.setAfterGetValidator(settingValidator);
        Binding binding = this.dbc.bindValue((IObservableValue)ViewerProperties.singlePostSelection(DictionaryStorageSettings.class).observe((Viewer)settingsViewer), this.dictionarySettings, updateStorageStrategy, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        computableList.addChangeListener(arg_0 -> this.lambda$4((IObservableList)computableList, settingsViewer, arg_0));
        this.createNewSettings.addValueChangeListener(arg_0 -> this.lambda$5((IObservableList)computableList, settingsViewer, arg_0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)settingsViewer.getControl()), (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)button1), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        Label segmentIdLabel = new Label(top, 0);
        segmentIdLabel.setText(Messages.SmartRegExNewWizardPage_Segment_ID);
        Text segmentIdText = new Text(top, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)segmentIdText);
        UpdateValueStrategy updateStrategy = new UpdateValueStrategy();
        updateStrategy.setAfterGetValidator(id -> {
            if (!((Boolean)this.createNewSettings.getValue()).booleanValue() || this.translatingProject.getValue() == null) {
                return ValidationStatus.ok();
            }
            if (StringUtils.isNullOrEmpty((String)id)) {
                return ValidationStatus.error((String)Messages.SmartRegExNewWizardPage_Segment_ID_cannot_be_empty);
            }
            if (this.storageSettingsManager.getSettingsOrDefault(((ITranslatingProject)this.translatingProject.getValue()).getProject()).getDictionary().containsKey(id)) {
                return ValidationStatus.error((String)Messages.SmartRegExNewWizardPage_Segment_ID_already_exists_in_project_settings);
            }
            return ValidationStatus.ok();
        });
        Binding bindValue = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)segmentIdText), PojoProperties.value(ResourceStorageSettings.class, (String)"id", String.class).observeDetail(this.dictionarySettings), updateStrategy, updateStrategy);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
        Label segmentPresentationLabel = new Label(top, 0);
        segmentPresentationLabel.setText(Messages.SmartRegExNewWizardPage_Segment_presentation);
        Text segmentPresentationText = new Text(top, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)segmentPresentationText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)segmentPresentationText), PojoProperties.value(ResourceStorageSettings.class, (String)"presentation", String.class).observeDetail(this.dictionarySettings));
        Label segmentFilePathLabel = new Label(top, 0);
        segmentFilePathLabel.setText(Messages.SmartRegExNewWizardPage_file_path);
        Text segmentFilePathText = new Text(top, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)segmentFilePathText);
        UpdateValueStrategy updateStrategy2 = new UpdateValueStrategy();
        updateStrategy2.setAfterGetValidator(o -> {
            if (!((Boolean)this.createNewSettings.getValue()).booleanValue()) {
                return ValidationStatus.ok();
            }
            if (StringUtils.isNotEmpty((String)((String)this.file.getValue())) && this.translatingProject.getValue() != null && StringUtils.isNotEmpty((String)((DictionaryStorageSettings)this.dictionarySettings.getValue()).getFilePath())) {
                TranslateLanguage lang = this.getLanguage();
                String oldPath = ((DictionaryStorageSettings)this.dictionarySettings.getValue()).getFilePath();
                try {
                    ((DictionaryStorageSettings)this.dictionarySettings.getValue()).setFilePath(o);
                    IPath newPath = TranslationStorageUtils.getDictionaryFilePath((DictionaryStorageSettings)((DictionaryStorageSettings)this.dictionarySettings.getValue()), (TranslateLanguage)lang);
                    for (DictionaryStorageSettings settings : this.storageSettingsManager.getSettingsOrDefault(((ITranslatingProject)this.translatingProject.getValue()).getProject()).getDictionarySettings()) {
                        IPath path = TranslationStorageUtils.getDictionaryFilePath((DictionaryStorageSettings)settings, (TranslateLanguage)lang);
                        if (!newPath.equals((Object)path)) continue;
                        IStatus iStatus = ValidationStatus.error((String)Messages.SmartRegExNewWizardPage_File_path_is_not_unique);
                        return iStatus;
                    }
                }
                finally {
                    ((DictionaryStorageSettings)this.dictionarySettings.getValue()).setFilePath(oldPath);
                }
            }
            return ValidationStatus.ok();
        });
        bindValue = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)segmentFilePathText), this.filePathValue, updateStrategy2, null);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
        Label segmentExtensionLabel = new Label(top, 0);
        segmentExtensionLabel.setText(Messages.SmartRegExNewWizardPage_file_extension);
        Text segmentExtensionText = new Text(top, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)segmentExtensionText);
        bindValue = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)segmentExtensionText), this.fileExtensionValue, updateStrategy2, null);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)segmentIdText), this.createNewSettings, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)segmentPresentationText), this.createNewSettings, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)segmentFilePathText), this.createNewSettings, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)segmentExtensionText), this.createNewSettings, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
    }

    private void addFileSection(Composite composite) {
        Composite top = this.createDefaultComposite(composite);
        ((GridLayout)top.getLayout()).numColumns = 3;
        Label fileLabel = new Label(top, 0);
        fileLabel.setText(Messages.SmartRegExNewWizardPage_Create_file);
        Text fileText = new Text(top, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fileText);
        IObservableValue fileExists = ComputedValue.create(() -> {
            String fullPath = (String)this.file.getValue();
            if (StringUtils.isNullOrEmpty((String)fullPath)) {
                return false;
            }
            IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
            return resourceFile.exists();
        });
        ISWTObservableValue fileTextValue = WidgetProperties.text().observe((Widget)fileText);
        this.dbc.bindValue((IObservableValue)fileTextValue, this.file, UpdateValueStrategy.never(), null);
        Button button = new Button(top, 8);
        button.setText(Messages.SmartRegExNewWizardPage_Open);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path((String)SmartRegExNewWizardPage.this.file.getValue()));
                SmartRegExNewWizardPage.this.getShell().getDisplay().asyncExec(() -> {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)resourceFile, (String)"com.e1c.langtool.ui.editor.RegEx", (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                });
                IWizardContainer container = SmartRegExNewWizardPage.this.getWizard().getContainer();
                if (container instanceof Window) {
                    ((Window)container).close();
                }
            }
        });
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)button), fileExists, UpdateValueStrategy.never(), null);
        UpdateValueStrategy updateStrategy2 = new UpdateValueStrategy();
        updateStrategy2.setAfterGetValidator(fullPath -> {
            if (StringUtils.isNotEmpty((String)fullPath) && Boolean.TRUE.equals(fileExists.getValue())) {
                return ValidationStatus.error((String)Messages.SmartRegExNewWizardPage_File_already_exist_Open_the_file);
            }
            return ValidationStatus.ok();
        });
        Binding binding = this.dbc.bindValue((IObservableValue)fileTextValue, (IObservableValue)new WritableValue(), updateStrategy2, UpdateValueStrategy.never());
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private /* synthetic */ void lambda$4(IObservableList iObservableList, ListViewer listViewer, ChangeEvent e) {
        if (this.translatingProject.getValue() != null && !((Boolean)this.createNewSettings.getValue()).booleanValue() && iObservableList.size() == 1) {
            listViewer.setSelection((ISelection)new StructuredSelection(iObservableList.get(0)), true);
            this.dictionarySettings.setValue((Object)((DictionaryStorageSettings)iObservableList.get(0)));
        }
    }

    private /* synthetic */ void lambda$5(IObservableList iObservableList, ListViewer listViewer, ValueChangeEvent e) {
        if (((Boolean)this.createNewSettings.getValue()).booleanValue()) {
            DictionaryStorageSettings oldSettings = (DictionaryStorageSettings)this.dictionarySettings.getValue();
            this.dictionarySettings.setValue(null);
            this.filePathValue.setValue(null);
            this.fileExtensionValue.setValue(null);
            DictionaryStorageSettings newSettings = new DictionaryStorageSettings();
            if (oldSettings != null) {
                newSettings.setId(oldSettings.getId() + (iObservableList.size() + 1));
                newSettings.setPresentation(oldSettings.getPresentation());
                newSettings.setFormat(oldSettings.getFormat());
                newSettings.setFileExtension(oldSettings.getFileExtension());
                newSettings.setFilePath(oldSettings.getFilePath());
            }
            newSettings.setFormat("dict-regex");
            this.dictionarySettings.setValue((Object)newSettings);
            this.filePathValue.setValue((Object)newSettings.getFilePath());
            this.fileExtensionValue.setValue((Object)newSettings.getFileExtension());
        } else if (iObservableList.size() == 1) {
            this.dictionarySettings.setValue((Object)((DictionaryStorageSettings)iObservableList.get(0)));
        } else if (!listViewer.getStructuredSelection().isEmpty()) {
            this.dictionarySettings.setValue((Object)((DictionaryStorageSettings)listViewer.getStructuredSelection().getFirstElement()));
        } else {
            this.dictionarySettings.setValue(null);
        }
    }

    private class FilePathComputer
    extends ComputedValue<String> {
        private FilePathComputer() {
        }

        protected String calculate() {
            ITranslatingProject translating = SmartRegExNewWizardPage.this.getTranslatingProject();
            TranslateLanguage language = SmartRegExNewWizardPage.this.getLanguage();
            ResourceStorageSettings settings = SmartRegExNewWizardPage.this.getResourceSettings();
            if (translating != null && language != null && settings != null) {
                IProject external = SmartRegExNewWizardPage.this.translatingProjectManager.getLanguageProject(translating, language);
                if (settings instanceof DictionaryStorageSettings) {
                    if (StringUtils.isNullOrEmpty((String)((String)SmartRegExNewWizardPage.this.filePathValue.getValue())) || StringUtils.isNullOrEmpty((String)((String)SmartRegExNewWizardPage.this.fileExtensionValue.getValue()))) {
                        return "";
                    }
                    IPath path = TranslationStorageUtils.getDictionaryFilePath((DictionaryStorageSettings)((DictionaryStorageSettings)settings), (TranslateLanguage)language);
                    return external.getFile(path).getFullPath().toString();
                }
                boolean cfr_ignored_0 = settings instanceof ContextStorageSettings;
            }
            return "";
        }

        protected void doSetValue(String value) {
            this.makeDirty();
        }
    }

    private static class ProjectLabelProvider
    extends LabelProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ITranslatingProject) {
                ITranslatingProject project = (ITranslatingProject)element;
                return project.getProject().getName();
            }
            return super.getText(element);
        }
    }
}

