/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql;

import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaNestedQuery;
import com._1c.g5.v8.dt.ql.model.StringLiteralExpression;
import com._1c.g5.v8.dt.ql.scoping.IQlCachedScopeProvider;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.ql.settings.QlFeatureSettings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public final class QlUtil {
    public static final String QUERY_PACKAGE_SEPARATOR = ";";
    public static final String QUOTE = "\"";
    public static final String STRING_LINE_SEPARATOR = "\n";
    public static final String COMMENT_START_TAG = "//";
    public static final String QL_DCS_FILE_EXT = "qldcs";
    public static final String QL_FILE_EXT = "ql";
    private static final String QUERY_START_STRING = "SELECT";
    private static final String QUERY_START_STRING_RU = "\u0412\u042b\u0411\u0420\u0410\u0422\u042c";
    public static final String QUERY_UNION = "UNION";
    public static final String QUERY_UNION_RU = "\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c";
    public static final String QUERY_UNION_ALL = "UNION ALL";
    public static final String QUERY_UNION_ALL_RU = "\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c \u0412\u0421\u0415";
    private static final String COMMENT = "comment";

    private QlUtil() {
    }

    public static boolean isQueryText(@Nullable String content) {
        if (StringUtils.isBlank((String)content)) {
            return false;
        }
        if (content == null) {
            return false;
        }
        if (content.startsWith(QUERY_START_STRING) || content.startsWith(QUERY_START_STRING_RU)) {
            return true;
        }
        String[] lines = content.split("\\n");
        if (lines.length < 2) {
            return false;
        }
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (!(line.startsWith(COMMENT_START_TAG) || StringUtils.isBlank((String)line) || line.equals(QUERY_PACKAGE_SEPARATOR) || line.startsWith(QUERY_UNION) || line.startsWith(QUERY_UNION_RU))) {
                return line.startsWith(QUERY_START_STRING) || line.startsWith(QUERY_START_STRING_RU);
            }
            ++i;
        }
        return false;
    }

    public static @NonNull String getActualQueryText(@NonNull String content) {
        String[] lines = content.split("\\n", -1);
        if (lines.length < 2) {
            return content;
        }
        CharSequence[] newLines = QlUtil.getActualQueryText(lines);
        return String.join((CharSequence)STRING_LINE_SEPARATOR, newLines);
    }

    public static @NonNull String[] getActualQueryText(@NonNull String[] lines) {
        boolean changeContent = false;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].stripLeading();
            if (!StringUtils.isBlank((String)line) && !line.startsWith(COMMENT_START_TAG)) {
                if (line.equals(QUERY_PACKAGE_SEPARATOR) || line.startsWith(QUERY_UNION) || line.startsWith(QUERY_UNION_RU)) {
                    changeContent = true;
                } else {
                    if (changeContent && (line.startsWith(QUERY_START_STRING) || line.startsWith(QUERY_START_STRING_RU))) {
                        String[] newLines = new String[lines.length - i];
                        System.arraycopy(lines, i, newLines, 0, lines.length - i);
                        return newLines;
                    }
                    return lines;
                }
            }
            ++i;
        }
        return lines;
    }

    public static void cleanUpQueryCache(QuerySchema object) {
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.ql"));
        IQlCachedScopeProvider qlCachedScopeProvider = (IQlCachedScopeProvider)resourceServiceProvider.get(IQlCachedScopeProvider.class);
        ICompositeNode tree = NodeModelUtils.findActualNodeFor((EObject)object);
        String queryText = tree.getText();
        qlCachedScopeProvider.clearScopes(queryText);
        List subQueries = EcoreUtil2.getAllContentsOfType((EObject)object, QuerySchemaNestedQuery.class);
        for (QuerySchemaNestedQuery query : subQueries) {
            tree = NodeModelUtils.findActualNodeFor((EObject)query);
            queryText = tree.getText();
            qlCachedScopeProvider.clearScopes(queryText);
        }
    }

    public static String getStringLiteralContent(StringLiteralExpression literal, boolean trimContent) {
        String content = literal.getContent();
        if (content == null) {
            content = "";
        }
        if (trimContent) {
            content = content.trim();
        }
        if (content.startsWith(QUOTE)) {
            content = content.substring(1);
        }
        if (content.endsWith(QUOTE)) {
            content = content.substring(0, content.length() - 1);
        }
        if (trimContent) {
            content = content.trim();
        }
        content = content.replaceAll("\"\"", QUOTE);
        return content;
    }

    public static String formatForStringLiteralContent(String content) {
        return QUOTE + content.replaceAll(QUOTE, "\"\"") + QUOTE;
    }

    public static boolean isCommentNode(ILeafNode leafNode) {
        return leafNode.getGrammarElement() instanceof TerminalRule && "SL_COMMENT".equalsIgnoreCase(((TerminalRule)leafNode.getGrammarElement()).getName());
    }

    public static String getCommentText(List<ILeafNode> comments) {
        StringBuilder sb = new StringBuilder();
        for (INode iNode : comments) {
            String text;
            if (sb.length() > 0) {
                sb.append(STRING_LINE_SEPARATOR);
            }
            if ((text = iNode.getText().trim()).startsWith(COMMENT_START_TAG)) {
                int start;
                int i = start = COMMENT_START_TAG.length();
                while (i < text.length()) {
                    if (text.charAt(i) == '/') {
                        ++start;
                    } else {
                        if (start != i || text.charAt(i) != ' ') break;
                        ++start;
                    }
                    ++i;
                }
                text = text.substring(start).trim();
            }
            sb.append(text);
        }
        return sb.toString().trim();
    }

    public static List<String> getCommentLines(List<INode> nodes) {
        return nodes.stream().map(n -> n.getText().trim()).collect(Collectors.toList());
    }

    public static List<ILeafNode> getCommentBlock(ILeafNode node) {
        LinkedList<ILeafNode> result = new LinkedList<ILeafNode>();
        if (!node.isHidden()) {
            return result;
        }
        result.add(node);
        ILeafNode prev = node;
        while (prev.hasPreviousSibling()) {
            if (!((prev = prev.getPreviousSibling()) instanceof ILeafNode) || !prev.isHidden()) break;
            if (QlUtil.isCommentNode(prev)) {
                if (!prev.getText().startsWith(COMMENT_START_TAG)) continue;
                result.addFirst(prev);
                continue;
            }
            if (prev.getText().indexOf(10) == -1) continue;
        }
        ILeafNode next = node;
        while (next.hasNextSibling()) {
            if (!((next = next.getNextSibling()) instanceof ILeafNode) || !next.isHidden()) break;
            if (QlUtil.isCommentNode(next)) {
                if (!next.getText().startsWith(COMMENT_START_TAG)) continue;
                result.addLast(next);
                continue;
            }
            if (next.getText().indexOf(10) == -1) continue;
        }
        return result;
    }

    public static FeatureKey getCommentFeatureKey(ITranslationFeatureKeyProvider provider, EObject owner, String text) {
        return provider.getKey(owner).append(COMMENT).append(text).append(QlFeatureSettings.Literals.COMMENT__DESCRIPTION.getName());
    }

    public static void collectComments(EObject object, CollectingContext context, IProgressMonitor monitor) {
        HashSet<Integer> processedNode = new HashSet<Integer>();
        QlUtil.collectComments(object, context, processedNode, monitor);
    }

    public static void collectComments(EObject object, CollectingContext context, Set<Integer> processedNode, IProgressMonitor monitor) {
        ArrayList allComments = new ArrayList();
        ArrayList<ILeafNode> found = new ArrayList<ILeafNode>();
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        Iterator it = node.getLeafNodes().iterator();
        while (it.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            ILeafNode iLeafNode = (ILeafNode)it.next();
            if (iLeafNode.isHidden() && QlUtil.isCommentNode(iLeafNode)) {
                found.add(iLeafNode);
                continue;
            }
            if (found.isEmpty() || iLeafNode.isHidden() && iLeafNode.getText().indexOf(10) == -1) continue;
            allComments.add(found);
            found = new ArrayList();
        }
        if (!found.isEmpty()) {
            allComments.add(found);
        }
        for (List list : allComments) {
            String comment;
            if (list.isEmpty() || processedNode.containsAll(list.stream().map(INode::getStartLine).collect(Collectors.toList())) || StringUtils.isBlank((String)(comment = QlUtil.getCommentText(list))) && !context.getParameters().isCollectEmptyValue() || comment.startsWith("%")) continue;
            FeatureKey featureKey = QlUtil.getCommentFeatureKey(context.getFeatureKeyProvider(), object, comment);
            FeatureValue fv = QlUtil.createCommentFeatureValue(featureKey, context.getResourceFile(), comment);
            context.getAddAction().accept(object, fv);
            list.forEach(n -> {
                boolean bl = processedNode.add(n.getStartLine());
            });
        }
    }

    private static FeatureValue createCommentFeatureValue(FeatureKey featureKey, IFile file, String content) {
        return new PersistableFeatureValue(QlUtil.createCommentContextTranslationKey(file, featureKey, content), false);
    }

    private static ContextTranslationKey createCommentContextTranslationKey(IFile file, FeatureKey featureKey, String content) {
        return new ContextTranslationKeyImpl(file, featureKey, QlFeatureSettings.Literals.COMMENT__DESCRIPTION, content);
    }
}

