/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql;

import com._1c.g5.v8.dt.metadata.dbview.DbViewDef;
import com._1c.g5.v8.dt.metadata.dbview.DbViewElement;
import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldFieldDef;
import com._1c.g5.v8.dt.ql.model.AbstractExpression;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaQuery;
import com._1c.g5.v8.dt.ql.model.CommonExpression;
import com._1c.g5.v8.dt.ql.model.NestedTableAllFieldsExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaDropTableQuery;
import com._1c.g5.v8.dt.ql.model.QuerySchemaExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchemaOperator;
import com._1c.g5.v8.dt.ql.model.QuerySchemaSelectQuery;
import com._1c.g5.v8.dt.ql.model.StarExpression;
import com._1c.g5.v8.dt.ql.typesystem.IDynamicDbViewFieldComputer;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class QuerySelectedFieldComputer {
    @Inject
    private IDynamicDbViewFieldComputer dynamicDbViewFieldComputer;

    public List<List<EObject>> getSelectedFields(QuerySchema querySchema) {
        ArrayList<List<EObject>> result = new ArrayList<List<EObject>>();
        EList queries = querySchema.getQueries();
        for (AbstractQuerySchemaQuery query : queries) {
            if (query instanceof QuerySchemaDropTableQuery) {
                result.add(List.of());
                continue;
            }
            if (!(query instanceof QuerySchemaSelectQuery)) continue;
            List<EObject> fields = this.getFields((QuerySchemaSelectQuery)query);
            result.add(fields);
        }
        return result;
    }

    private List<EObject> getFields(QuerySchemaSelectQuery query) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EList operators = query.getOperators();
        if (!operators.isEmpty()) {
            EList selectFields = ((QuerySchemaOperator)operators.get(0)).getSelectFields();
            for (QuerySchemaExpression fieldExpression : selectFields) {
                List fields;
                EObject sourceMd;
                AbstractExpression expression = fieldExpression.getExpression();
                if (expression instanceof StarExpression) {
                    for (DbViewDef dbView : ((QuerySchemaOperator)operators.get(0)).getDbViewByFrom()) {
                        sourceMd = dbView.getMdObject();
                        fields = this.dynamicDbViewFieldComputer.computeFieldsBySemanticObject(sourceMd);
                        for (DbViewElement field : fields) {
                            if (!(field instanceof DbViewFieldFieldDef)) continue;
                            result.add((EObject)field);
                        }
                    }
                    continue;
                }
                if (expression instanceof NestedTableAllFieldsExpression) {
                    CommonExpression table = ((NestedTableAllFieldsExpression)expression).getTable();
                    if (table == null) continue;
                    DbViewElement dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)table);
                    sourceMd = dbView.getMdObject();
                    fields = this.dynamicDbViewFieldComputer.computeFieldsBySemanticObject(sourceMd);
                    for (DbViewElement field : fields) {
                        if (!(field instanceof DbViewFieldFieldDef)) continue;
                        result.add((EObject)field);
                    }
                    continue;
                }
                result.add((EObject)fieldExpression);
            }
        }
        return result;
    }
}

