/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql.naming;

import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaSource;
import com._1c.g5.v8.dt.ql.model.MultiPartCommonExpression;
import com._1c.g5.v8.dt.ql.model.MultiPartQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.ParameterExpression;
import com._1c.g5.v8.dt.ql.model.QlPackage;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchemaTotalControlPoint;
import com._1c.g5.v8.dt.ql.model.SinglePartCommonExpression;
import com._1c.g5.v8.dt.ql.model.SinglePartQuerySchemaTable;
import com._1c.g5.v8.dt.ql.model.StringLiteralExpression;
import com._1c.g5.v8.dt.ql.naming.QlQualifiedNameProvider;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.v8.dt.internal.ql.QlPlugin;
import com.e1c.langtool.v8.dt.naming.AbstractFeatureKeyComputer;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class QlFeatureKeyComputer
extends AbstractFeatureKeyComputer {
    private static final String QUERY_STRING = "Query";
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final IQualifiedNameConverter qualifiedNameConverter;
    private final IDependentQuerySchemaProvider dependentModelProvider;
    private final QlQualifiedNameProvider qlFqnProvider;

    public static QlFeatureKeyComputer create() {
        return (QlFeatureKeyComputer)((Object)QlPlugin.getDefault().getInjector().getInstance(QlFeatureKeyComputer.class));
    }

    @Inject
    public QlFeatureKeyComputer(ITranslationFeatureKeyProvider featureKeyProvider, IQualifiedNameConverter qualifiedNameConverter, IDependentQuerySchemaProvider dependentModelProvider) {
        this.featureKeyProvider = featureKeyProvider;
        this.qualifiedNameConverter = qualifiedNameConverter;
        this.dependentModelProvider = dependentModelProvider;
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.ql"));
        this.qlFqnProvider = (QlQualifiedNameProvider)resourceServiceProvider.get(QlQualifiedNameProvider.class);
    }

    public boolean isSupported(EObject object) {
        if (object == null) {
            return false;
        }
        EPackage objectPackage = object.eClass().getEPackage();
        if (objectPackage.equals(QlPackage.eINSTANCE) && object.eResource() != null && !object.eResource().getContents().isEmpty()) {
            objectPackage = ((EObject)object.eResource().getContents().get(0)).eClass().getEPackage();
        }
        return objectPackage.equals(QlPackage.eINSTANCE);
    }

    public FeatureKey computeFqn(EObject obj) {
        if (obj instanceof QuerySchema) {
            return this._computeFqn((QuerySchema)obj);
        }
        if (obj instanceof QuerySchemaExpression) {
            return this._computeFqn((QuerySchemaExpression)obj);
        }
        if (obj instanceof AbstractQuerySchemaSource) {
            return this._computeFqn((AbstractQuerySchemaSource)obj);
        }
        if (obj instanceof ParameterExpression) {
            return this._computeFqn((ParameterExpression)obj);
        }
        if (obj instanceof QuerySchemaTotalControlPoint) {
            return this._computeFqn((QuerySchemaTotalControlPoint)obj);
        }
        if (obj instanceof StringLiteralExpression) {
            return this._computeFqn((StringLiteralExpression)obj);
        }
        if (obj instanceof MultiPartCommonExpression || obj instanceof SinglePartCommonExpression || obj instanceof MultiPartQuerySchemaTable || obj instanceof SinglePartQuerySchemaTable) {
            return this._computeFqn(obj);
        }
        QlPlugin.log(QlPlugin.createWarningStatus(MessageFormat.format("QL: Unhandled Feature Key parameter type: {0}", obj)));
        return this.computeListOrParent(obj);
    }

    protected FeatureKey _computeFqn(QuerySchema obj) {
        EObject parent = this.dependentModelProvider.getParent(obj);
        if (parent == null) {
            return SegmentFeatureKey.EMPTY;
        }
        FeatureKey _xifexpression = this.featureKeyProvider.getKey(parent);
        if (_xifexpression == null) {
            return SegmentFeatureKey.EMPTY;
        }
        EStructuralFeature feature = this.dependentModelProvider.getParentFeature(obj);
        if (feature != null) {
            return _xifexpression.append(this.toFeatureKey(StringUtils.capitalize((String)feature.getName())));
        }
        return _xifexpression.append(QUERY_STRING);
    }

    protected FeatureKey _computeFqn(EObject obj) {
        EObject top = this.getTopObject(obj);
        FeatureKey _xifexpression = this.computeFqn(top);
        QualifiedName fqn = this.qlFqnProvider.getFullyQualifiedName(obj);
        if (fqn != null) {
            return _xifexpression.append((FeatureKey)SegmentFeatureKey.create((List)fqn.getSegments()));
        }
        if (obj instanceof MultiPartCommonExpression) {
            String content = ((MultiPartCommonExpression)obj).getFullContent();
            QualifiedName contentFqn = this.qualifiedNameConverter.toQualifiedName(content);
            return _xifexpression.append((FeatureKey)SegmentFeatureKey.create((List)contentFqn.getSegments()));
        }
        if (QlPlugin.getDefault().isDebugging()) {
            System.err.println("Cannot compute FeatureKey fo QL type: " + obj.toString());
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(QuerySchemaExpression obj) {
        FeatureKey _xifexpression = null;
        String _alias = obj.getAlias();
        if (!StringUtils.isNullOrEmpty((String)_alias)) {
            EObject top = this.getTopObject((EObject)obj);
            _xifexpression = this.computeFqn(top);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Expr"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_alias));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(AbstractQuerySchemaSource obj) {
        FeatureKey _xifexpression = null;
        String _alias = obj.getAlias();
        if (!StringUtils.isNullOrEmpty((String)_alias)) {
            EObject top = this.getTopObject((EObject)obj);
            _xifexpression = this.computeFqn(top);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Source"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_alias));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(ParameterExpression obj) {
        FeatureKey _xifexpression = null;
        String _name = obj.getName();
        if (!StringUtils.isNullOrEmpty((String)_name)) {
            EObject top = this.getTopObject((EObject)obj);
            _xifexpression = this.computeFqn(top);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Param"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_name));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(QuerySchemaTotalControlPoint obj) {
        FeatureKey _xifexpression = null;
        String _name = obj.getColumnName();
        if (!StringUtils.isNullOrEmpty((String)_name)) {
            EObject top = this.getTopObject((EObject)obj);
            _xifexpression = this.computeFqn(top);
            _xifexpression = _xifexpression.append(this.toFeatureKey("Total"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_name));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(StringLiteralExpression obj) {
        FeatureKey _xifexpression = null;
        String _content = QlUtil.getStringLiteralContent(obj, true);
        if (!StringUtils.isNullOrEmpty((String)_content)) {
            EObject top = this.getTopObject((EObject)obj);
            _xifexpression = this.computeFqn(top);
            _xifexpression = _xifexpression.append(this.toFeatureKey("String"));
            _xifexpression = _xifexpression.append(this.toFeatureKey(_content));
        }
        return _xifexpression;
    }

    protected EObject getTopObject(EObject obj) {
        return EcoreUtil2.getContainerOfType((EObject)obj, QuerySchema.class);
    }
}

