/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ql.translator;

import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.ql.QlPlugin;
import com.e1c.langtool.v8.dt.ql.translator.QlTextProcessor;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.xtext.AbstractXtextObjectTextEditor;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class QlTextEditor
extends AbstractXtextObjectTextEditor {
    private final IDependentQuerySchemaProvider dependentModelProvider;
    private final List<Map<String, String>> fieldMaps = Lists.newArrayList();
    private final boolean isDcs;
    private final EObject root;
    private QlTextProcessor processor;
    protected final IProjectTranslationProvider translationProvider;

    public static QlTextEditor create(IProjectTranslationProvider translationProvider, QuerySchema object, boolean isDcs) {
        if (object == null) {
            throw new IllegalArgumentException("Query schema cannot be empty");
        }
        IDependentQuerySchemaProvider dependentModelProvider = (IDependentQuerySchemaProvider)QlPlugin.getDefault().getInjector().getInstance(IDependentQuerySchemaProvider.class);
        EObject parent = dependentModelProvider.getParent(object);
        if (parent == null) {
            throw new IllegalArgumentException("Query schema created without parent object");
        }
        QlTextEditor editor = new QlTextEditor((EObject)object, translationProvider, isDcs, dependentModelProvider);
        QlPlugin.getDefault().getInjector().injectMembers((Object)editor);
        return editor;
    }

    protected QlTextEditor(EObject root, IProjectTranslationProvider translationProvider, boolean isDcs, IDependentQuerySchemaProvider dependentModelProvider) {
        super(root);
        this.dependentModelProvider = dependentModelProvider;
        this.root = root;
        this.translationProvider = translationProvider;
        this.isDcs = isDcs;
    }

    public List<Map<String, String>> getFieldMaps() {
        return this.fieldMaps;
    }

    public IStatus process(IProgressMonitor monitor) {
        try {
            EcoreUtil2.resolveLazyCrossReferences((Resource)this.root.eResource(), (CancelIndicator)new MonitorBasedCancelIndicator(monitor));
        }
        catch (Exception e) {
            IStatus status = this.createErrorStatus(this.root, e);
            QlPlugin.log(status);
            return status;
        }
        return super.process(monitor);
    }

    private IStatus createErrorStatus(EObject source, Exception e) {
        Object message = e.getMessage();
        if (StringUtils.isNullOrEmpty((String)message)) {
            message = "";
        }
        URI uri = EcoreUtil.getURI((EObject)source);
        message = "Cannot translate module: " + String.valueOf(uri) + "\n\n" + (String)message;
        IStatus status = QlPlugin.createErrorStatus((String)message, e);
        return status;
    }

    protected MultiTextEditParseTreeVisitor createTreeVisitor(MultiTextEdit edit, EObject root, IProgressMonitor monitor) {
        ICompositeNode tree = NodeModelUtils.getNode((EObject)root);
        Resource resource = root.eResource();
        IResourceServiceProvider rsp = resource instanceof XtextResource ? ((XtextResource)resource).getResourceServiceProvider() : (this.isDcs ? IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.qldcs")) : IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.ql")));
        this.processor = new QlTextProcessor(edit, tree.getText(), root, this.isDcs, this.translationProvider, (CancelIndicator)new MonitorBasedCancelIndicator(monitor), rsp, this.dependentModelProvider);
        QlPlugin.getDefault().getInjector().injectMembers((Object)this.processor);
        return this.processor;
    }

    protected void dispose() {
        this.fieldMaps.clear();
        if (this.processor != null) {
            this.fieldMaps.addAll(this.processor.getFieldMaps());
        }
        this.processor = null;
    }
}

