/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.form;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.form.model.ChartExtInfo;
import com._1c.g5.v8.dt.form.model.Decoration;
import com._1c.g5.v8.dt.form.model.DendrogramExtInfo;
import com._1c.g5.v8.dt.form.model.DynamicListExtInfo;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com._1c.g5.v8.dt.form.model.GanttChartExtInfo;
import com._1c.g5.v8.dt.form.model.PlannerExtInfo;
import com._1c.g5.v8.dt.form.model.SpreadsheetDocumentExtInfo;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.collector.V8FeatureValue;
import com.e1c.langtool.v8.dt.form.FormProcessor;
import com.e1c.langtool.v8.dt.form.FormUtil;
import com.e1c.langtool.v8.dt.form.settings.FormFeatureSettings;
import com.e1c.langtool.v8.dt.internal.form.FormPlugin;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.inject.Inject;
import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.util.CancelIndicator;

public class FormFeaturesCollector
extends FormProcessor
implements FeatureValueCollector {
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IDependentQuerySchemaProvider dependentModelProvider;
    private ICollectingParameters parameters;
    private CollectingContext context;
    private BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;
    private IFile resourceFile;

    public static FormFeaturesCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        FormFeaturesCollector collector = new FormFeaturesCollector((IBmObject)object, parameters, addAction);
        FormPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    public FormFeaturesCollector(IBmObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        super(object);
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        super.setProcessChildObjects(parameters.isCollectChildObjects());
        this.setWaitDerivedDataComputation(parameters.isCollectModelStrings());
        this.addAction = addAction;
    }

    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (object instanceof IBmObject && ((IBmObject)object).bmIsTop()) {
            subMonitor.subTask(((IBmObject)object).bmGetFqn());
        }
        FeaturesCollectorUtil.collectFeatures(object, (CollectingContext)this.getContext(), (IProgressMonitor)subMonitor.newChild(1));
        if (object instanceof DynamicListExtInfo) {
            this.collect((IProgressMonitor)subMonitor.newChild(1), (DynamicListExtInfo)object);
        } else if (object instanceof ChartExtInfo) {
            this.collectFeatureObject((IProgressMonitor)subMonitor.newChild(1), object, (EStructuralFeature)FormPackage.Literals.CHART_EXT_INFO__CHART);
        } else if (object instanceof DendrogramExtInfo) {
            this.collectFeatureObject((IProgressMonitor)subMonitor.newChild(1), object, (EStructuralFeature)FormPackage.Literals.DENDROGRAM_EXT_INFO__DENDROGRAM);
        } else if (object instanceof GanttChartExtInfo) {
            this.collectFeatureObject((IProgressMonitor)subMonitor.newChild(1), object, (EStructuralFeature)FormPackage.Literals.GANTT_CHART_EXT_INFO__GANTT_CHART);
        } else if (object instanceof PlannerExtInfo) {
            this.collectFeatureObject((IProgressMonitor)subMonitor.newChild(1), object, (EStructuralFeature)FormPackage.Literals.PLANNER_EXT_INFO__PLANNER_SETTINGS);
        } else if (object instanceof SpreadsheetDocumentExtInfo) {
            this.collectFeatureObject((IProgressMonitor)subMonitor.newChild(1), object, (EStructuralFeature)FormPackage.Literals.SPREADSHEET_DOCUMENT_EXT_INFO__SPREADSHEET_DATA);
        } else if (object instanceof Decoration) {
            this.collectDecoration((IProgressMonitor)subMonitor.newChild(1), (Decoration)object);
        }
        if (clazz.equals(Form.class)) {
            this.collectFeatureObject((IProgressMonitor)subMonitor.newChild(1), object, (EStructuralFeature)FormPackage.Literals.FORM__CONDITIONAL_APPEARANCE);
        }
        monitor.done();
    }

    private void collectDecoration(IProgressMonitor monitor, Decoration object) {
        if (monitor.isCanceled() || !object.isFormatted() || !this.getContext().getParameters().isCollectModelStrings() || object.getTitle().isEmpty()) {
            return;
        }
        String content = (String)object.getTitle().get((Object)this.getContext().getDefaultLanguageCode());
        if (StringUtils.isBlank((String)content)) {
            return;
        }
        List<Pair<String, Integer>> links = FormUtil.parseLinkFromDecorationText(content);
        if (links.isEmpty()) {
            return;
        }
        FeatureKey preffix = this.featureKeyProvider.getKey((EObject)object);
        for (Pair<String, Integer> link : links) {
            if (monitor.isCanceled()) {
                return;
            }
            String linkContent = ((String)link.getKey()).trim();
            if (StringUtils.isNotWord((String)linkContent) || FormUtil.isWebLink(linkContent) || FormUtil.isEnterpriseLink(linkContent)) continue;
            FeatureKey featureKey = preffix.append(linkContent).append(FormFeatureSettings.Literals.DECORATION__LINK.getName());
            PersistableFeatureValue featureValue = new PersistableFeatureValue(this.getResourceFile(), featureKey, FormFeatureSettings.Literals.DECORATION__LINK, linkContent, false);
            this.getContext().getAddAction().accept(object, featureValue);
        }
    }

    private void collect(IProgressMonitor monitor, DynamicListExtInfo obj) {
        QuerySchema query;
        TranslationSource source;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (obj.isCustomQuery() && this.parameters.isCollectModelStrings() && (source = TranslationUtils.getTranslationSource((Object)(query = this.dependentModelProvider.getQuerySchema((EObject)obj, (EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__QUERY_TEXT, (CancelIndicator)new MonitorBasedCancelIndicator(monitor))))) != null) {
            this.collectingService.forEachCollected(source, this.parameters, (IProgressMonitor)subMonitor.newChild(1), (sourceObject, feature) -> {
                V8FeatureValue.Builder b = V8FeatureValue.Builder.fromFeatureValue((FeatureValue)feature).setFile(this.getResourceFile());
                this.addAction.accept(sourceObject, b.build());
            });
        }
        this.collectFeatureObject((IProgressMonitor)subMonitor.newChild(1), (EObject)obj, (EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__LIST_SETTINGS);
        if (this.parameters.isCollectInterfaceStrings()) {
            if (obj.isCustomQuery()) {
                this.collectFeaturesObject((IProgressMonitor)subMonitor, (EObject)obj, (EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__AUTO_FILL_AVAILABLE_FIELDS);
                this.collectFeaturesObject((IProgressMonitor)subMonitor, (EObject)obj, (EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__FIELDS);
            }
            this.collectFeaturesObject((IProgressMonitor)subMonitor, (EObject)obj, (EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__CALCULATED_FIELDS);
            this.collectFeaturesObject((IProgressMonitor)subMonitor, (EObject)obj, (EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__PARAMETERS);
        }
        subMonitor.done();
    }

    private void collectFeatureObject(IProgressMonitor monitor, EObject obj, EStructuralFeature feature) {
        TranslationSource source = TranslationUtils.getTranslationSource((Object)obj.eGet(feature));
        if (source != null) {
            this.collectingService.forEachCollected(source, this.parameters, monitor, this.addAction);
        }
        monitor.done();
    }

    private void collectFeaturesObject(IProgressMonitor monitor, EObject obj, EStructuralFeature feature) {
        Object list = obj.eGet(feature);
        if (list instanceof EList) {
            for (Object item : (EList)list) {
                TranslationSource source = TranslationUtils.getTranslationSource(item);
                if (source == null) continue;
                this.collectingService.forEachCollected(source, this.parameters, monitor, this.addAction);
            }
        }
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, this.getDefaultLanguageCode((EObject)this.object), this.addAction, this.getResourceFile());
        }
        return this.context;
    }

    private String getDefaultLanguageCode(EObject context) {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)context, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            this.resourceFile = this.resourceLookup.getPlatformResource((EObject)this.object);
        }
        return this.resourceFile;
    }
}

