/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.form;

import com.e1c.langtool.common.Pair;
import java.util.ArrayList;
import java.util.List;

public final class FormUtil {
    public static final String E1CIB_DATA = "e1cib/data/";
    public static final String LINK_PREFIX = "<link ";

    public static List<Pair<String, Integer>> parseLinkFromDecorationText(String decoration) {
        ArrayList<Pair<String, Integer>> result = new ArrayList<Pair<String, Integer>>();
        int position = -1;
        while ((position = decoration.indexOf(LINK_PREFIX, position)) > -1) {
            int end = decoration.indexOf(">", position);
            if (end > -1) {
                int begin = position + LINK_PREFIX.length();
                String content = decoration.substring(begin, end);
                result.add((Pair<String, Integer>)new Pair((Object)content, (Object)begin));
            } else {
                end = position + LINK_PREFIX.length();
            }
            position = end + 1;
        }
        return result;
    }

    public static boolean isWebLink(String linkContent) {
        return linkContent != null && (linkContent.startsWith("http://") || linkContent.startsWith("https://") || linkContent.startsWith("ftp://"));
    }

    public static boolean isEnterpriseLink(String linkContent) {
        return linkContent != null && linkContent.startsWith(E1CIB_DATA);
    }

    private FormUtil() {
        new IllegalAccessError("Utility class");
    }
}

