/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.form.check;

import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaParameter;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.form.model.DynamicListExtInfo;
import com._1c.g5.v8.dt.form.model.FormAttribute;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.form.check.Messages;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProviderCache;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;

public class DynamicListParametersTranslationsCheck
extends BasicCheck<Void> {
    private static final String CHECK_ID = "form-dynamic-list-parameters-translations";
    private final ProjectTranslationProviderCache projectTranslationProviderCache;
    private final IV8ProjectManager projectManager;
    private final ITranslatingProjectManager translatingProjectManager;
    private final IFeatureSettingsService settingsService;

    @Inject
    public DynamicListParametersTranslationsCheck(ProjectTranslationProviderCache projectTranslationProviderCache, IV8ProjectManager projectManager, ITranslatingProjectManager translatingProjectManager, IFeatureSettingsService settingsService) {
        this.projectTranslationProviderCache = projectTranslationProviderCache;
        this.projectManager = projectManager;
        this.translatingProjectManager = translatingProjectManager;
        this.settingsService = settingsService;
    }

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.DynamicListParametersTranslationsCheck_Title).description(Messages.DynamicListParametersTranslationsCheck_Description).disable().complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).issueType(IssueType.ERROR).topObject(FormPackage.Literals.FORM).containment(FormPackage.Literals.DYNAMIC_LIST_EXT_INFO).features(new EStructuralFeature[]{DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_PARAMETER__NAME});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (!(object instanceof DynamicListExtInfo)) {
            return;
        }
        DynamicListExtInfo extInfo = (DynamicListExtInfo)object;
        EList extInfoParameters = extInfo.getParameters();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(this.getProject((EObject)extInfo));
        List languages = translatingProject.getModelLanguages();
        List translatedProjects = this.translatingProjectManager.getProject(this.getProject((EObject)extInfo)).getTranslatedProjects();
        HashSet<String> translations = new HashSet<String>();
        HashMap<String, String> sameTranslations = new HashMap<String, String>();
        for (DataCompositionSchemaParameter parameter : extInfoParameters) {
            for (ITranslatedProject translatedProject : translatedProjects) {
                IProjectTranslationProvider translationProvider = this.projectTranslationProviderCache.get((ITranslatedV8Project)translatedProject);
                EFeatureSettings featureSettings = this.settingsService.getSettings((EStructuralFeature)DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_PARAMETER__NAME, (EObject)parameter);
                for (TranslateLanguage language : languages) {
                    String translation = translationProvider.getTranslation((EObject)parameter, featureSettings, language);
                    if (translations.contains(translation)) {
                        sameTranslations.put(parameter.getName(), translation);
                    }
                    translations.add(translation);
                }
            }
        }
        if (!sameTranslations.isEmpty()) {
            FormAttribute parent = (FormAttribute)EcoreUtil2.getContainerOfType((EObject)extInfo, FormAttribute.class);
            String message = MessageFormat.format(Messages.DynamicListParametersTranslationsCheck_Dynamic_list__0__has_same_translations_parameters__1, parent.getName(), String.join((CharSequence)", ", sameTranslations.keySet()));
            resultAceptor.addIssue(message, (Object)parent);
        }
    }

    private IProject getProject(EObject eObject) {
        return this.projectManager.getProject(eObject).getProject();
    }
}

