/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.form.naming;

import com._1c.g5.v8.dt.form.model.ChartExtInfo;
import com._1c.g5.v8.dt.form.model.DendrogramExtInfo;
import com._1c.g5.v8.dt.form.model.DynamicListExtInfo;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.form.model.FormAttribute;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com._1c.g5.v8.dt.form.model.GanttChartExtInfo;
import com._1c.g5.v8.dt.form.model.GraphicalSchemeExtInfo;
import com._1c.g5.v8.dt.form.model.PlannerExtInfo;
import com._1c.g5.v8.dt.form.model.SpreadsheetDocumentExtInfo;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.sync.naming.BaseTranslatedTopObjectFqnGeneratorDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Optional;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public final class FormTranslatedTopObjectFqnGeneratorDelegate
extends BaseTranslatedTopObjectFqnGeneratorDelegate {
    public FormTranslatedTopObjectFqnGeneratorDelegate() {
        super(new EPackage[]{FormPackage.eINSTANCE});
    }

    public String generateFqn(EObject source, IProjectTranslationProvider translationProvider) {
        if (source instanceof Form) {
            Form form = (Form)source;
            if (form.getExtensionForm() != null) {
                return this.generateExternalPropertyFqn((EObject)form.getExtensionForm(), FormPackage.Literals.FORM__BASE_FORM, translationProvider);
            }
            return this.generateExternalPropertyFqn((EObject)((Form)source).getMdForm(), MdClassPackage.Literals.BASIC_FORM__FORM, translationProvider);
        }
        if (source instanceof DynamicListExtInfo) {
            return this.generateExtenalPropertyFqnForFormAttribute((FormAttribute)source.eContainer(), translationProvider);
        }
        if (source instanceof ChartExtInfo) {
            return this.generateExtenalPropertyFqnForFormAttribute((FormAttribute)source.eContainer(), translationProvider);
        }
        if (source instanceof DendrogramExtInfo) {
            return this.generateExtenalPropertyFqnForFormAttribute((FormAttribute)source.eContainer(), translationProvider);
        }
        if (source instanceof GanttChartExtInfo) {
            return this.generateExtenalPropertyFqnForFormAttribute((FormAttribute)source.eContainer(), translationProvider);
        }
        if (source instanceof PlannerExtInfo) {
            return this.generateExtenalPropertyFqnForFormAttribute((FormAttribute)source.eContainer(), translationProvider);
        }
        if (source instanceof SpreadsheetDocumentExtInfo || source instanceof GraphicalSchemeExtInfo) {
            return this.generateExtenalPropertyFqnForFormAttribute((FormAttribute)source.eContainer(), translationProvider);
        }
        throw new AssertionFailedException("Unsupported source type: " + source.eClass().getName());
    }

    private String generateExtenalPropertyFqnForFormAttribute(FormAttribute attribute, IProjectTranslationProvider translationProvider) {
        Provider provider = () -> {
            TranslateLanguage language = translationProvider.getProject().getDefaultLanguage();
            String newName = translationProvider.getTranslation((EObject)attribute, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, language);
            Optional<String> name = Optional.ofNullable(newName);
            return name.orElse(attribute.getName());
        };
        ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
        String name = cache.getTranslation(EcoreUtil.getURI((EObject)attribute), provider);
        String ownerFqn = this.fqnGenerator.generateFqn(attribute.eContainer(), translationProvider);
        QualifiedName fqn = this.qualifiedNameConverter.toQualifiedName(ownerFqn);
        return this.qualifiedNameConverter.toString(fqn.append("Attributes").append(StringUtils.capitalize((String)name)).append("ExtInfo"));
    }
}

