/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.htmldocument.sync;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.sync.DependentContentComputer;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExternalHtmlPageDependentContentComputer
implements DependentContentComputer {
    @Inject
    private ITranslatingProjectManager translatingProjectManager;

    public Collection<IFile> computeDependentContentToSynchronize(IFile source, boolean sourceRemoved, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && !sourceRemoved) {
            return this.getExternalHtmlPage(source, true, monitor);
        }
        return Collections.emptyList();
    }

    public Collection<IFile> computeDependentContentToRemove(IFile source, boolean sourceRemoved, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && sourceRemoved) {
            return this.getExternalHtmlPage(source, false, monitor);
        }
        return Collections.emptyList();
    }

    private Collection<IFile> getExternalHtmlPage(IFile source, boolean checkExist, IProgressMonitor monitor) {
        ArrayList result = Lists.newArrayList();
        IProject project = source.getProject();
        Optional translating = this.translatingProjectManager.getTranslatingForExternalProject(project);
        if (translating.isPresent() && ((ITranslatingProject)translating.get()).isTranslating()) {
            for (TranslateLanguage language : ((ITranslatingProject)translating.get()).getInterfaceLanguages()) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                IProject languageProject = this.translatingProjectManager.getLanguageProject((ITranslatingProject)translating.get(), language);
                if (project.equals((Object)languageProject)) continue;
                IPath path = source.getProjectRelativePath().removeLastSegments(1).append(language.getLanguageCode()).addFileExtension("html");
                IFile pageFile = languageProject.getFile(path);
                if (checkExist && !pageFile.exists()) continue;
                result.add(pageFile);
            }
        }
        return result;
    }
}

