/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.htmldocument.sync;

import com._1c.g5.v8.dt.htmldocument.model.HtmlDocument;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocumentPage;
import com._1c.g5.v8.dt.metadata.mdclass.BasicTemplate;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.htmldocument.sync.AbstractHtmlPageSynchronizer;
import com.e1c.langtool.v8.dt.internal.htmldocument.HtmlPlugin;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;

public class HtmlPageSynchronizer
extends AbstractHtmlPageSynchronizer {
    private static final String ID = "com.e1c.langtool.v8.dt.htmldocument.HtmlPage";
    private static final String TEMPLATE_NAME = "Template.htmldoc";
    @Inject
    protected EmfObjectProvider emfObjectProvider;
    @Inject
    private TranslationPreferences preferences;

    public String getId() {
        return ID;
    }

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        IPath sourcePath = sourceFile.getProjectRelativePath();
        IPath path = sourcePath.removeLastSegments(1).append(TEMPLATE_NAME);
        IFile emfResource = sourceProject.getProject().getFile(path);
        if (!emfResource.exists()) {
            return result;
        }
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(path);
        if (fqn == null || fqn.isEmpty()) {
            if (HtmlPlugin.getDefault().isDebugging()) {
                System.out.println("FQN is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        if (!sourceFile.isAccessible() || !(session instanceof BmSyncSession)) {
            if (HtmlPlugin.getDefault().isDebugging()) {
                System.out.println("Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        BmSyncSession bmSession = (BmSyncSession)session;
        IProjectTranslationProvider translationProvider = bmSession.getTranslationProvider();
        TranslationProperties properties = this.preferences.getTranslationProperties(sourceProject.getProject());
        String languageCode = sourceFile.getProjectRelativePath().removeFileExtension().lastSegment();
        List<String> languageCodes = this.getLanguageCodes(bmSession.getTranslationProvider());
        if (!languageCodes.contains(languageCode) && !properties.fillEmptyHtmlTranslationFromSource()) {
            return result;
        }
        EObject owner = this.emfObjectProvider.getOwnerByFile(emfResource);
        if (owner == null) {
            if (HtmlPlugin.getDefault().isDebugging()) {
                System.out.println("Owner not found. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        String translatedFqn = this.topObjectFqnGenerator.generateFqn(owner, translationProvider);
        String filePath = null;
        if (translatedFqn != null) {
            filePath = this.qualifiedNameFilePathConverter.getFilePath(translatedFqn);
        }
        if (filePath == null) {
            if (HtmlPlugin.getDefault().isDebugging()) {
                System.out.println("Target file path is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        Path targetPath = new Path(filePath);
        targetPath = targetPath.removeLastSegments(1).append(sourcePath.lastSegment());
        IFile targetFile = target.getProject().getFile((IPath)targetPath);
        if (languageCodes.contains(languageCode)) {
            try {
                this.synchronize(sourceFile, targetFile, bmSession);
                result.add(targetFile);
            }
            catch (IOException | CoreException e) {
                IStatus status = HtmlPlugin.createErrorStatus(MessageFormat.format("Failed synchronizing file: \"{0}\" to: \"{1}\"", sourceFile, targetFile), e);
                HtmlPlugin.log(status);
                return result;
            }
        }
        if (properties.fillEmptyHtmlTranslationFromSource()) {
            this.synchronizeDependentEmptyLanguages(owner, sourceFile, sourceProject, targetFile, target, properties, bmSession, result);
        }
        return result;
    }

    private void synchronizeDependentEmptyLanguages(EObject eObject, IFile sourceFile, ITranslatingProject sourceProject, IFile targetFile, ITranslatedProject target, TranslationProperties properties, BmSyncSession bmSession, Collection<IResource> result) {
        HtmlDocument doc = (HtmlDocument)((BasicTemplate)eObject).getTemplate();
        List<String> langs = this.getPages(doc);
        block2: for (TranslateLanguage language : sourceProject.getInterfaceLanguages()) {
            if (langs.contains(language.getLanguageCode())) continue;
            TranslateLanguage newLang = properties.getLanguageToFillEmptyInterfaceTranslation(language);
            if (newLang == null) {
                return;
            }
            HashSet checked = Sets.newHashSet((Object[])new String[]{language.getLanguageCode()});
            while (newLang != null && !checked.contains(newLang.getLanguageCode())) {
                if (!langs.contains(newLang.getLanguageCode())) {
                    checked.add(newLang.getLanguageCode());
                    newLang = properties.getLanguageToFillEmptyInterfaceTranslation(newLang);
                    continue;
                }
                String sourceLangCode = sourceFile.getFullPath().removeFileExtension().lastSegment();
                if (!sourceLangCode.equals(newLang.getLanguageCode())) continue block2;
                IPath targetPath = targetFile.getProjectRelativePath().removeLastSegments(1).append(language.getLanguageCode()).addFileExtension("html");
                IFile tFile = target.getProject().getFile(targetPath);
                try {
                    this.synchronize(sourceFile, tFile, bmSession);
                    result.add((IResource)tFile);
                    checked.add(newLang.getLanguageCode());
                }
                catch (IOException | CoreException e) {
                    IStatus status = HtmlPlugin.createErrorStatus(MessageFormat.format("Failed synchronizing file: \"{0}\" to: \"{1}\"", sourceFile, tFile), e);
                    HtmlPlugin.log(status);
                }
            }
        }
    }

    private List<String> getPages(HtmlDocument doc) {
        return doc.getPages().stream().map(HtmlDocumentPage::getLang).collect(Collectors.toList());
    }
}

