/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.htmldocument.sync;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.htmldocument.HtmlPlugin;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public class HtmlUtils {
    public static final String HTML_PAGE_FILE_EXT = "html";
    private static final Pattern HTML_LINK_PATTERN = Pattern.compile("<a\\s+.*?href=\\\"?(?<fqn>[\\w\\.]+)\\/Help\\\"?", 256);
    private static final Pattern HTML_COMMON_PICT_PATTERN = Pattern.compile("<img\\s+.*?src=\\\"?(?<fqn>CommonPicture\\.[\\w\\.]+)\\\"?", 256);
    private static final String LINK_FQN_PATTERN_GROUP = "fqn";

    public static String getPageText(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }

    public static boolean hasMdLinks(String pageText) {
        Matcher matcher = HTML_LINK_PATTERN.matcher(pageText);
        return matcher.find() || HTML_COMMON_PICT_PATTERN.matcher(pageText).find();
    }

    public static String replaceMdLinks(String pageText, IBmModel model, IProjectTranslationProvider translationProvider, TranslatedTopObjectFqnGenerator topObjectFqnGenerator, IQualifiedNameConverter qualifiedNameConverter) {
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        boolean isNewTransaction = false;
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(true);
            isNewTransaction = true;
        }
        MultiTextEdit edit = new MultiTextEdit();
        try {
            int offset;
            String fqnString;
            Matcher matcher = HTML_LINK_PATTERN.matcher(pageText);
            while (matcher.find()) {
                fqnString = matcher.group(LINK_FQN_PATTERN_GROUP);
                if (StringUtils.isBlank((String)fqnString)) continue;
                offset = matcher.start(LINK_FQN_PATTERN_GROUP);
                HtmlUtils.addChange(edit, fqnString, offset, transaction, translationProvider, topObjectFqnGenerator, qualifiedNameConverter);
            }
            matcher = HTML_COMMON_PICT_PATTERN.matcher(pageText);
            while (matcher.find()) {
                fqnString = matcher.group(LINK_FQN_PATTERN_GROUP);
                if (StringUtils.isBlank((String)fqnString)) continue;
                offset = matcher.start(LINK_FQN_PATTERN_GROUP);
                HtmlUtils.addChange(edit, fqnString, offset, transaction, translationProvider, topObjectFqnGenerator, qualifiedNameConverter);
            }
        }
        finally {
            if (isNewTransaction) {
                transaction.rollback();
            }
        }
        Document doc = new Document(pageText);
        try {
            edit.apply((IDocument)doc);
        }
        catch (BadLocationException | MalformedTreeException e) {
            HtmlPlugin.logError(e);
        }
        return doc.get();
    }

    public static EObject resolveObject(IBmTransaction transaction, QualifiedName name, IQualifiedNameConverter qualifiedNameConverter) {
        if (name.getSegmentCount() == 4 && name.getSegment(2).equals("Form") && !name.getFirstSegment().equals("CommonForm")) {
            URI uri = BmUriUtil.createContainedBmObjectUri((String)transaction.getNamespace().getName(), (String)qualifiedNameConverter.toString(name.skipLast(2)), (String)("/forms:" + name.getLastSegment()));
            return transaction.getObjectByUri(uri);
        }
        return transaction.getTopObjectByFqn(qualifiedNameConverter.toString(name));
    }

    private static void addChange(MultiTextEdit edit, String fqnString, int offset, IBmTransaction transaction, IProjectTranslationProvider translationProvider, TranslatedTopObjectFqnGenerator topObjectFqnGenerator, IQualifiedNameConverter qualifiedNameConverter) {
        QualifiedName fqn = QualifiedName.create((String[])fqnString.split("\\."));
        EObject owner = HtmlUtils.resolveObject(transaction, fqn, qualifiedNameConverter);
        if (owner == null) {
            return;
        }
        String translatedFqn = topObjectFqnGenerator.generateFqn(owner, translationProvider);
        if (translatedFqn != null) {
            edit.addChild((TextEdit)new ReplaceEdit(offset, fqnString.length(), translatedFqn));
        }
    }

    private HtmlUtils() {
        throw new IllegalAccessError("Utility class");
    }
}

