/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.htmldocument.sync;

import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.internal.htmldocument.HtmlPlugin;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.ReplacebleExternalPropertySynchronizer;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;

public class TemplatePicturesSynchronizer
extends ReplacebleExternalPropertySynchronizer {
    private static final String ID = "com.e1c.langtool.v8.dt.htmldocument.TemplatePictures";
    private static final String SEGMENT_FILES = "_files";
    private static final String TEMPLATE_NAME = "Template.htmldoc";

    public String getId() {
        return ID;
    }

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        IProject project = sourceFile.getProject();
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (!this.checkFile(sourceFile)) {
            if (HtmlPlugin.getDefault().isDebugging()) {
                System.out.println("File is not pic of HTML-template. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        if (!sourceFile.isAccessible() || !(session instanceof BmSyncSession) || monitor.isCanceled()) {
            return result;
        }
        BmSyncSession bmSession = (BmSyncSession)session;
        IPath sourcePath = sourceFile.getProjectRelativePath();
        String last = null;
        do {
            last = sourcePath.lastSegment();
        } while ((sourcePath = sourcePath.removeLastSegments(1)).segmentCount() > 0 && !SEGMENT_FILES.equals(last));
        EObject owner = this.emfObjectProvider.getOwnerByFile(project.getFile(sourcePath.append(TEMPLATE_NAME)));
        if (owner == null) {
            if (HtmlPlugin.getDefault().isDebugging()) {
                System.out.println("Owner not found. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        IProjectTranslationProvider translationProvider = bmSession.getTranslationProvider();
        String translatedFqn = this.topObjectFqnGenerator.generateFqn(owner, translationProvider);
        String filePath = null;
        if (translatedFqn != null) {
            filePath = this.qualifiedNameFilePathConverter.getFilePath(translatedFqn);
        }
        if (filePath == null) {
            if (HtmlPlugin.getDefault().isDebugging()) {
                System.out.println("Target file path is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        Path targetPath = new Path(filePath);
        if ((targetPath = targetPath.removeLastSegments(1).append(sourceFile.getProjectRelativePath().removeFirstSegments(sourcePath.segmentCount()))).segmentCount() != sourceFile.getProjectRelativePath().segmentCount()) {
            String message = MessageFormat.format("HTML-tamplate picture synchronization failed.\nSource file: {0}\npath in target project: {1}", sourceFile.getFullPath(), targetPath);
            HtmlPlugin.log(HtmlPlugin.createErrorStatus(message, null));
            return result;
        }
        IFile targetFile = target.getProject().getFile((IPath)targetPath);
        IStatus status = this.synchronize(sourceFile, owner, target.getProject(), targetFile, bmSession, translationProvider, monitor);
        if (status.isOK()) {
            result.add(targetFile);
        }
        return result;
    }

    private boolean checkFile(IFile sourceFile) {
        IPath path = sourceFile.getProjectRelativePath();
        if (path.segmentCount() > 4 && "CommonTemplates".equals(path.segment(1)) && SEGMENT_FILES.equals(path.segment(3))) {
            return true;
        }
        return path.segmentCount() > 6 && "Templates".equals(path.segment(3)) && SEGMENT_FILES.equals(path.segment(5));
    }
}

