/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslCommentUtils;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TagPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TextPart;
import com._1c.g5.v8.dt.bsl.model.Block;
import com._1c.g5.v8.dt.bsl.model.DeclareStatement;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.ForEachStatement;
import com._1c.g5.v8.dt.bsl.model.ForToStatement;
import com._1c.g5.v8.dt.bsl.model.IfStatement;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.Pragma;
import com._1c.g5.v8.dt.bsl.model.Preprocessor;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItemMethodStatement;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItemModule;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessor;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.ContentTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.ContextTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.KeysTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.TypeComputer;
import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com._1c.g5.v8.dt.mcore.ContainingSourceDerivedProperty;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public final class BslUtils {
    public static final String KEY_SPLIT_REGEX = "\\,";
    public static final String STRING_LINE_SEPARATOR = "\n";
    public static final String SYSTEM_LINE_SEPARATOR = System.lineSeparator();
    public static final String QUOTE = "\"";
    public static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\"\"");
    private static final String SINGLE_ENTRY_NSTR_TEMPLATE = "{0} = ''{1}''";
    public static final String COMMENT_START_TAG_BSL = "//";

    private BslUtils() {
    }

    @Deprecated
    public static String[] splitStringKeys(String lines) {
        if (StringUtils.isNullOrEmpty((String)lines)) {
            return new String[0];
        }
        String[] keys = lines.split(KEY_SPLIT_REGEX);
        int i = 0;
        while (i < keys.length) {
            String key = keys[i].replace("\\n", " ").replace("\\r", " ").trim();
            if (!KeysTypeComputer.isKey((String)key.trim())) {
                return new String[0];
            }
            keys[i] = key;
            ++i;
        }
        return keys;
    }

    @Deprecated
    public static String[] splitStringKeys(StringLiteral literal) {
        String lines = BslUtils.getString(literal);
        return BslUtils.splitStringKeys(lines);
    }

    public static Map<String, String> getNlsLocalStrings(StringLiteral object) {
        String fullString = BslUtils.getString(object);
        V8ParametersStringParser parser = new V8ParametersStringParser(fullString);
        return parser.getStatus().isOK() ? parser.getParameters() : Maps.newHashMap();
    }

    public static String getString(StringLiteral literal) {
        return String.join((CharSequence)STRING_LINE_SEPARATOR, (Iterable<? extends CharSequence>)literal.lines(false));
    }

    public static String getQueryText(StringLiteral literal) {
        EList lines = literal.lines(false);
        CharSequence[] newLines = QlUtil.getActualQueryText((String[])lines.toArray(new String[0]));
        return String.join((CharSequence)STRING_LINE_SEPARATOR, newLines);
    }

    public static String formatForStringLiteral(String content, String prefixLine) {
        String toSplit = content.replace(System.lineSeparator(), STRING_LINE_SEPARATOR);
        ArrayList lines = Lists.newArrayList();
        char newLineChar = STRING_LINE_SEPARATOR.charAt(0);
        int start = 0;
        int i = 0;
        while (i < toSplit.length()) {
            char c = toSplit.charAt(i);
            if (c == newLineChar) {
                lines.add(toSplit.substring(start, i));
                start = i + 1;
                if (start == toSplit.length()) {
                    lines.add("");
                }
            }
            ++i;
        }
        if (start < toSplit.length()) {
            lines.add(toSplit.substring(start, toSplit.length()));
        }
        ArrayList newLines = Lists.newArrayListWithCapacity((int)lines.size());
        boolean isFirstLine = true;
        for (String line : lines) {
            if (!line.trim().startsWith("|") && !isFirstLine) {
                newLines.add(prefixLine + "|" + line);
            } else {
                newLines.add(line);
            }
            isFirstLine = false;
        }
        String newContent = newLines.stream().collect(Collectors.joining(System.lineSeparator()));
        return newContent.replaceAll(QUOTE, "\"\"");
    }

    public static String formatAndQuoteForStringLiteral(String content, String prefixLine) {
        return QUOTE + BslUtils.formatForStringLiteral(content, prefixLine) + QUOTE;
    }

    public static List<String> formatAndQuoteForStringLiteral(List<String> lines, String prefixLine) {
        ArrayList newLines = Lists.newArrayListWithCapacity((int)lines.size());
        int i = 0;
        while (i < lines.size()) {
            Object line = lines.get(i);
            line = ((String)line).replaceAll(QUOTE, "\"\"");
            if (i == 0) {
                line = QUOTE + (String)line;
            }
            if (i > 0 && !((String)line).trim().startsWith("|")) {
                line = prefixLine + "|" + (String)line;
            }
            if (i == lines.size() - 1) {
                line = (String)line + QUOTE;
            }
            newLines.add(line);
            ++i;
        }
        return newLines;
    }

    public static String formatNStrStringLiteral(Map<String, String> map, String[] indentation) {
        StringBuilder result = new StringBuilder();
        int indentationIndex = 0;
        int maximalIndentationIndex = indentation.length - 1;
        String currentIndentation = "";
        String restLinesIndentation = "\t\t";
        result.append('\"');
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        boolean isSecondLine = false;
        while (iterator.hasNext()) {
            String[] messageLines;
            Map.Entry<String, String> entry = iterator.next();
            String message = BslUtils.formatNStrEntry(entry.getKey(), entry.getValue()).replace(QUOTE, "\"\"");
            String[] stringArray = messageLines = message.split(STRING_LINE_SEPARATOR, -1);
            int n = messageLines.length;
            int n2 = 0;
            while (n2 < n) {
                String messageLine = stringArray[n2];
                if (indentationIndex <= maximalIndentationIndex) {
                    currentIndentation = indentation[indentationIndex];
                    if (indentationIndex == maximalIndentationIndex) {
                        int lastSeparatorIndex;
                        restLinesIndentation = indentationIndex == 0 && "".equals(currentIndentation) ? "\t\t" : ((lastSeparatorIndex = currentIndentation.lastIndexOf(SYSTEM_LINE_SEPARATOR)) < 0 ? currentIndentation : currentIndentation.substring(lastSeparatorIndex + SYSTEM_LINE_SEPARATOR.length()));
                    }
                    ++indentationIndex;
                } else {
                    currentIndentation = restLinesIndentation;
                }
                if (isSecondLine) {
                    result.append(SYSTEM_LINE_SEPARATOR);
                    result.append(currentIndentation);
                    result.append("|");
                }
                result.append(messageLine);
                isSecondLine = true;
                ++n2;
            }
            if (!iterator.hasNext()) continue;
            result.append(";");
        }
        result.append('\"');
        return result.toString();
    }

    public static String formatNStrEntry(String languageCode, String value) {
        return MessageFormat.format(SINGLE_ENTRY_NSTR_TEMPLATE, languageCode, value.replace("\r", "").replace("'", "''"));
    }

    public static String getLastLineIdentation(StringLiteral literal, int lengthDiff) {
        Object node = literal.getLines().size() > 1 ? NodeModelUtils.getNode((EObject)literal).getLastChild() : NodeModelUtils.getNode((EObject)literal);
        String identation = BslUtils.getNodeIdentation((INode)node, lengthDiff);
        return StringUtils.isNullOrEmpty((String)identation) ? "\t\t" : identation;
    }

    public static String getNodeIdentation(INode node, int lengthDiff) {
        String text;
        if (node.getStartLine() == 1 && node.getEndLine() == 1) {
            text = node.getRootNode().getText().substring(0, node.getOffset());
        } else {
            int startLine = node.getStartLine();
            Pattern p = Pattern.compile("(\\n|\\r)");
            int offset = node.getOffset();
            Object current = node.hasPreviousSibling() ? node : node.getParent();
            while (current != null && current.getEndLine() >= startLine && (current.hasPreviousSibling() || current.getParent() != null)) {
                Matcher m;
                if ((current = current.hasPreviousSibling() ? current.getPreviousSibling() : current.getParent()).getStartLine() > startLine || current.getEndLine() > startLine || !(m = p.matcher(current.getText())).find()) continue;
                int end = m.end(1);
                while (m.find()) {
                    end = m.end(1);
                }
                offset = current.getTotalOffset() + end;
                break;
            }
            text = offset >= 0 && node.getOffset() > offset && node.getRootNode().getText().length() > node.getOffset() ? node.getRootNode().getText().substring(offset, node.getOffset()) : "";
        }
        int length = Math.round((float)(lengthDiff + text.replace("\t", "----").length()) / 4.0f);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }

    public static boolean isEmptySource(List<FeatureEntry> features) {
        if (features.isEmpty()) {
            return true;
        }
        return features.stream().allMatch(e -> {
            if (e.getFeature() instanceof ContainingSourceDerivedProperty) {
                return e.getFeature().eGet((EStructuralFeature)McorePackage.Literals.CONTAINING_SOURCE_DERIVED_PROPERTY__CONTAINING_SOURCE, false) == null;
            }
            if (e.getFeature() instanceof DerivedProperty) {
                return e.getFeature().eGet((EStructuralFeature)McorePackage.Literals.DERIVED_PROPERTY__SOURCE, false) == null;
            }
            return false;
        });
    }

    public static boolean isInlineDocCommentNode(ILeafNode node) {
        return node.isHidden() && BslCommentUtils.isCommentNode((ILeafNode)node);
    }

    public static Variable getCommentNodeVariable(ILeafNode node) {
        if (!node.isHidden() || !BslCommentUtils.isCommentNode((ILeafNode)node)) {
            return null;
        }
        int currentLine = node.getStartLine();
        EObject semantic = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        Block block = (Block)EcoreUtil2.getContainerOfType((EObject)semantic, Block.class);
        ICompositeNode parent = NodeModelUtils.findActualNodeFor((EObject)block);
        if (parent != null) {
            for (ILeafNode child : parent.getLeafNodes()) {
                ForEachStatement statement;
                if (child.getEndLine() != currentLine) continue;
                if (child.getEndLine() > currentLine) break;
                EObject obj = child.getSemanticElement();
                if (obj instanceof Variable) {
                    if (NodeModelUtils.findActualNodeFor((EObject)obj).getStartLine() == currentLine) {
                        return (Variable)obj;
                    }
                    return null;
                }
                if (obj instanceof DeclareStatement) {
                    ICompositeNode vr;
                    DeclareStatement declare = (DeclareStatement)obj;
                    if (declare.getVariables().size() == 1 && (vr = NodeModelUtils.findActualNodeFor((EObject)((EObject)declare.getVariables().get(0)))).getStartLine() == node.getStartLine()) {
                        return (Variable)declare.getVariables().get(0);
                    }
                    return null;
                }
                if (obj instanceof ForEachStatement) {
                    statement = (ForEachStatement)obj;
                    if (statement.getVariableAccess() != null) {
                        return statement.getVariableAccess().getImplicitVariable();
                    }
                    return null;
                }
                if (obj instanceof ForToStatement) {
                    statement = (ForToStatement)obj;
                    if (statement.getVariableAccess() != null) {
                        return statement.getVariableAccess().getImplicitVariable();
                    }
                    return null;
                }
                if (obj instanceof IfStatement) {
                    return null;
                }
                if (obj instanceof SimpleStatement) {
                    statement = (SimpleStatement)obj;
                    if (!(statement.getLeft() instanceof StaticFeatureAccess)) continue;
                    StaticFeatureAccess left = (StaticFeatureAccess)statement.getLeft();
                    for (FeatureEntry entry : left.getFeatureEntries()) {
                        EObject variable = entry.getFeature();
                        if (!(variable instanceof Variable)) continue;
                        return (Variable)variable;
                    }
                    return null;
                }
                if (!(obj instanceof StaticFeatureAccess)) continue;
                StaticFeatureAccess sfa = (StaticFeatureAccess)obj;
                if (sfa.getImplicitVariable() != null) {
                    ICompositeNode vr = NodeModelUtils.findActualNodeFor((EObject)sfa);
                    if (vr.getStartLine() == node.getStartLine()) {
                        return sfa.getImplicitVariable();
                    }
                    return null;
                }
                for (FeatureEntry entry : sfa.getFeatureEntries()) {
                    EObject variable = entry.getFeature();
                    if (!(variable instanceof Variable)) continue;
                    if (NodeModelUtils.findActualNodeFor((EObject)obj).getStartLine() == currentLine) {
                        return (Variable)variable;
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getFeatrueKeyPreffix(BslDocumentationComment model) {
        List parts = model.getDescription().getParts();
        StringBuilder sb = new StringBuilder();
        for (IDescriptionPart part : parts) {
            void tagPart;
            IDescriptionPart iDescriptionPart = part;
            if (iDescriptionPart instanceof TextPart) {
                void textPart;
                TextPart cfr_ignored_0 = (TextPart)iDescriptionPart;
                TextPart cfr_ignored_1 = (TextPart)iDescriptionPart;
                Object text = textPart.getText();
                BslUtils.addPartToFeatureKeyPreffix(sb, (String)text);
                continue;
            }
            IDescriptionPart iDescriptionPart2 = part;
            if (!(iDescriptionPart2 instanceof TagPart)) continue;
            TagPart cfr_ignored_2 = (TagPart)iDescriptionPart2;
            TagPart cfr_ignored_3 = (TagPart)iDescriptionPart2;
            String text = tagPart.getContent();
            BslUtils.addPartToFeatureKeyPreffix(sb, text);
        }
        return sb.toString();
    }

    public static List<INode> getUpAndDownCommentNodes(INode node) {
        LinkedList<INode> result = new LinkedList<INode>();
        if (!(node instanceof ILeafNode) || !((ILeafNode)node).isHidden()) {
            return result;
        }
        result.add(node);
        INode prev = node;
        BslUtils.collectPrecedingCommentNodes(result, prev);
        INode next = node;
        BslUtils.collectFollowingCommentNodes(result, next);
        return result;
    }

    public static List<String> getCommentLines(List<INode> nodes) {
        return nodes.stream().map(n -> n.getText().trim()).collect(Collectors.toList());
    }

    public static EObject getOwnerNode(List<INode> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        INode node = lines.get(lines.size() - 1);
        EObject object = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        ICompositeNode compositeNode = NodeModelUtils.findActualNodeFor((EObject)object);
        if (node.getOffset() > compositeNode.getOffset()) {
            Method method = (Method)EcoreUtil2.getContainerOfType((EObject)object, Method.class);
            return method != null ? method : object;
        }
        if (BslUtils.isContainerPreprocessor(object)) {
            RegionPreprocessor preprocessor = BslUtils.getPreprocessor(object);
            ICompositeNode nodeItem = NodeModelUtils.findActualNodeFor((EObject)((Preprocessor)preprocessor).getItemAfter());
            int until = 0;
            until = nodeItem != null ? nodeItem.getTotalOffset() : node.getTotalEndOffset();
            while (node.getOffset() > until) {
                RegionPreprocessor region = (RegionPreprocessor)EcoreUtil2.getContainerOfType((EObject)preprocessor, RegionPreprocessor.class);
                if (region == null) {
                    return EcoreUtil2.getContainerOfType((EObject)preprocessor, Module.class);
                }
                nodeItem = NodeModelUtils.findActualNodeFor((EObject)region.getItemAfter());
                if (nodeItem == null) break;
                until = nodeItem.getTotalOffset();
                if (node.getOffset() <= until) {
                    return preprocessor.eContainer();
                }
                preprocessor = preprocessor.eContainer();
            }
            return preprocessor;
        }
        Method method = (Method)EcoreUtil2.getContainerOfType((EObject)object.eContainer(), Method.class);
        if (method != null) {
            return method;
        }
        RegionPreprocessor region = (RegionPreprocessor)EcoreUtil2.getContainerOfType((EObject)object.eContainer(), RegionPreprocessor.class);
        if (region != null) {
            return region;
        }
        return EcoreUtil2.getContainerOfType((EObject)object.eContainer(), Module.class);
    }

    public static EObject getOwnerDocNode(List<INode> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        INode node = lines.get(lines.size() - 1);
        return BslUtils.getOwnerNext(node, node.getNextSibling());
    }

    public static List<String> getInlineCommentAfterObject(EObject expressionBeforeComment, INode blockNode, boolean oldFormatComment) {
        String endLineText;
        int commentIndex;
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)expressionBeforeComment);
        int offset = node.getTotalEndOffset() - blockNode.getTotalOffset();
        String blockNodeText = blockNode.getText();
        int newLineIndex = blockNodeText.indexOf(10, offset);
        if (newLineIndex == -1 && blockNode instanceof RootNode) {
            newLineIndex = blockNode.getTotalEndOffset() - 1;
        }
        if (newLineIndex != -1 && (commentIndex = (endLineText = blockNodeText.substring(offset, newLineIndex + 1)).indexOf(COMMENT_START_TAG_BSL)) != -1) {
            endLineText = endLineText.substring(commentIndex).trim();
            return Lists.newArrayList((Object[])new String[]{"//Returns:", endLineText});
        }
        return Collections.emptyList();
    }

    public static List<String> collectMultilineCommentAfterObject(EObject expressionBeforeComment, INode blockNode) {
        String remainingText;
        int commentIndex;
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)expressionBeforeComment);
        int offset = node.getTotalEndOffset() - blockNode.getTotalOffset();
        String blockNodeText = blockNode.getText();
        int newLineIndex = blockNodeText.indexOf(10, offset);
        if (newLineIndex == -1 && blockNode instanceof RootNode) {
            newLineIndex = blockNode.getTotalEndOffset() - 1;
        }
        if (newLineIndex != -1 && blockNodeText.length() >= newLineIndex + 1 && (commentIndex = (remainingText = blockNodeText.substring(offset, newLineIndex + 1)).indexOf(COMMENT_START_TAG_BSL)) != -1) {
            ArrayList lines = Lists.newArrayList((Object[])remainingText.substring(commentIndex).trim().split(STRING_LINE_SEPARATOR));
            LinkedList<INode> comments = new LinkedList<INode>();
            INode commentNode = BslUtils.findCommentNodeAfterObject((INode)node);
            if (commentNode != null) {
                BslUtils.collectFollowingCommentNodes(comments, commentNode);
            }
            if (!comments.isEmpty()) {
                lines.addAll(comments.stream().map(INode::getText).collect(Collectors.toList()));
            }
            List commentContent = lines.stream().map(String::trim).collect(Collectors.toList());
            ArrayList<String> result = new ArrayList<String>();
            result.add("//Returns:");
            result.addAll(commentContent);
            return result;
        }
        return Collections.emptyList();
    }

    public static String getTextWithoutSplashes(String text) {
        int start;
        if (!text.startsWith(COMMENT_START_TAG_BSL)) {
            return text;
        }
        int i = start = COMMENT_START_TAG_BSL.length();
        while (i < text.length()) {
            if (text.charAt(i) == '/') {
                ++start;
            } else {
                if (start != i || text.charAt(i) != ' ') break;
                ++start;
            }
            ++i;
        }
        text = text.substring(start);
        return text;
    }

    public static boolean isNStr(StringLiteral stringLiteral, IStringLiteralTypeComputer typeComputer) {
        Collection types = typeComputer.getAnnotatedTypes(stringLiteral);
        if (typeComputer.containsAnyType(types, new String[]{"NStr"})) {
            return true;
        }
        LiteralType nstrType = typeComputer.getType("NStr");
        if (nstrType == null) {
            return false;
        }
        List<TypeComputer> computers = (List<TypeComputer>)typeComputer.getComputers().get(nstrType);
        if (computers == null) {
            return false;
        }
        if (!types.isEmpty()) {
            computers = computers.stream().filter(c -> c.computeWithAnnotations(types)).toList();
        }
        EList content = stringLiteral.lines(false);
        Environments envs = Environments.ALL;
        for (TypeComputer computer : computers) {
            if (!computer.isSupport(stringLiteral, (List)content) || (!(computer instanceof ContextTypeComputer) || !((ContextTypeComputer)computer).computeIsValidForSupportedType(stringLiteral, (List)content, envs)) && (!(computer instanceof ContentTypeComputer) || !((ContentTypeComputer)computer).computeIsValidForSupportedType(stringLiteral, (List)content, Collections.emptyList()))) continue;
            return true;
        }
        return false;
    }

    private static void collectFollowingCommentNodes(LinkedList<INode> result, INode next) {
        while (next.hasNextSibling()) {
            if (!((next = next.getNextSibling()) instanceof ILeafNode) || !((ILeafNode)next).isHidden()) break;
            if (BslCommentUtils.isCommentNode((ILeafNode)((ILeafNode)next))) {
                if (!next.getText().startsWith(COMMENT_START_TAG_BSL)) continue;
                result.addLast(next);
                continue;
            }
            if (next.getText().indexOf(10) != -1) break;
        }
    }

    private static void collectPrecedingCommentNodes(LinkedList<INode> result, INode prev) {
        while (prev.hasPreviousSibling()) {
            if (!((prev = prev.getPreviousSibling()) instanceof ILeafNode) || !((ILeafNode)prev).isHidden()) break;
            if (BslCommentUtils.isCommentNode((ILeafNode)((ILeafNode)prev))) {
                if (!prev.getText().startsWith(COMMENT_START_TAG_BSL)) continue;
                result.addFirst(prev);
                continue;
            }
            if (prev.getText().indexOf(10) != -1) break;
        }
    }

    private static INode findCommentNodeAfterObject(INode node) {
        ICompositeNode root = node.getRootNode();
        for (ILeafNode next : root.getLeafNodes()) {
            if (node.getEndOffset() > next.getOffset() || !(next instanceof ILeafNode) || !next.isHidden()) continue;
            if (BslCommentUtils.isCommentNode((ILeafNode)next)) {
                if (!next.getText().startsWith(COMMENT_START_TAG_BSL)) continue;
                return next;
            }
            if (next.getText().indexOf(10) != -1) break;
        }
        return null;
    }

    private static EObject getOwnerNext(INode node, INode next) {
        if (node == null || next == null) {
            return null;
        }
        if (next.getStartLine() - node.getStartLine() > 1) {
            return null;
        }
        if (next instanceof ILeafNode && !((ILeafNode)next).isHidden() || next instanceof CompositeNodeWithSemanticElement) {
            EObject object = NodeModelUtils.findActualSemanticObjectFor((INode)next);
            Method method = (Method)EcoreUtil2.getContainerOfType((EObject)object, Method.class);
            if (method != null) {
                return null;
            }
            ICompositeNode compositeNode = NodeModelUtils.findActualNodeFor((EObject)object);
            if (node.getOffset() <= compositeNode.getOffset() && (object instanceof Variable || object instanceof RegionPreprocessor || object instanceof StaticFeatureAccess)) {
                if (!(!(object instanceof Variable) && !(object instanceof StaticFeatureAccess) || object.eContainer() instanceof DeclareStatement && object.eContainer().eContainer() instanceof Module)) {
                    return null;
                }
                if (object instanceof StaticFeatureAccess) {
                    return ((StaticFeatureAccess)object).getImplicitVariable();
                }
                return object;
            }
        }
        return BslUtils.getOwnerNext(node, next.getNextSibling());
    }

    private static boolean isContainerPreprocessor(EObject object) {
        return !(!(object.eContainer() instanceof PreprocessorItemModule) && !(object.eContainer() instanceof PreprocessorItemMethodStatement) && !(object instanceof Pragma) || !(object.eContainer().eContainer() instanceof RegionPreprocessor) && !(object.eContainer().eContainer().eContainer() instanceof RegionPreprocessor));
    }

    private static RegionPreprocessor getPreprocessor(EObject object) {
        if (object instanceof Pragma) {
            return (RegionPreprocessor)object.eContainer().eContainer().eContainer();
        }
        return (RegionPreprocessor)object.eContainer().eContainer();
    }

    private static void addPartToFeatureKeyPreffix(StringBuilder sb, String text) {
        if (sb.length() > 0) {
            sb.append(STRING_LINE_SEPARATOR);
        }
        if (text.startsWith(COMMENT_START_TAG_BSL)) {
            if (!(text = BslUtils.getTextWithoutSplashes(text)).isEmpty()) {
                sb.append(text);
            }
        } else {
            sb.append(text);
        }
    }
}

