/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.dt.bsl.model.AwaitExpression;
import com._1c.g5.v8.dt.bsl.model.AwaitStatement;
import com._1c.g5.v8.dt.bsl.model.BinaryExpression;
import com._1c.g5.v8.dt.bsl.model.BreakStatement;
import com._1c.g5.v8.dt.bsl.model.Conditional;
import com._1c.g5.v8.dt.bsl.model.ContinueStatement;
import com._1c.g5.v8.dt.bsl.model.DeclareStatement;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.EventHandlerStatement;
import com._1c.g5.v8.dt.bsl.model.ExplicitVariable;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.ForEachStatement;
import com._1c.g5.v8.dt.bsl.model.ForToStatement;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.FunctionStyleCreator;
import com._1c.g5.v8.dt.bsl.model.IfStatement;
import com._1c.g5.v8.dt.bsl.model.ImplicitVariable;
import com._1c.g5.v8.dt.bsl.model.IndexAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.Label;
import com._1c.g5.v8.dt.bsl.model.LabeledStatement;
import com._1c.g5.v8.dt.bsl.model.Literal;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.OperatorStyleCreator;
import com._1c.g5.v8.dt.bsl.model.Pragma;
import com._1c.g5.v8.dt.bsl.model.Preprocessor;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItem;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItemDeclareStatement;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItemExpression;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItemMethodStatement;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItemStatements;
import com._1c.g5.v8.dt.bsl.model.RaiseStatement;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessorDeclareStatement;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessorExpression;
import com._1c.g5.v8.dt.bsl.model.ReturnStatement;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.TryExceptStatement;
import com._1c.g5.v8.dt.bsl.model.UnaryExpression;
import com._1c.g5.v8.dt.bsl.model.WhileStatement;
import com._1c.g5.v8.dt.bsl.model.util.BslUtil;
import com._1c.g5.v8.dt.bsl.resource.BslResolveCrossReferencesJob;
import com._1c.g5.v8.dt.bsl.resource.BslResource;
import com._1c.g5.v8.dt.core.platform.IDerivedDataManagerProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.IBasicProcessor;
import com.e1c.langtool.v8.dt.DerivedDataUtils;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.util.CancelIndicator;

public abstract class ModuleProcessor
implements IBasicProcessor {
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    private CancelIndicator cancelIndicator;
    protected final EObject rootObject;
    private boolean initialized = false;
    @Inject
    private IDerivedDataManagerProvider derivedDataManagerProvider;
    @Inject
    private IResourceLookup resourceLookup;
    protected IProgressMonitor monitor;
    private boolean waitDerivedDataComputation = true;
    private boolean deepAnalysis = true;

    public ModuleProcessor(EObject root) {
        this.rootObject = root;
    }

    public synchronized CancelIndicator getCancelIndicator() {
        if (this.cancelIndicator == null) {
            this.cancelIndicator = this.monitor == null ? CancelIndicator.NullImpl : new MonitorBasedCancelIndicator(this.monitor);
        }
        return this.cancelIndicator;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (this.isWaitDerivedDataComputation()) {
            DerivedDataUtils.DerivedDataAttr attr = new DerivedDataUtils.DerivedDataAttr(this.rootObject, 0x6DDD00L, DerivedDataUtils.MD_FORM_SEGMENTS);
            DerivedDataUtils.waitComputation((IDerivedDataManagerProvider)this.derivedDataManagerProvider, (IResourceLookup)this.resourceLookup, (DerivedDataUtils.IDerivedDataAttr)attr);
        }
        if (this.rootObject instanceof Module) {
            this.initModule();
            this.allObjects.add(this.rootObject);
        } else {
            this.allObjects.add(this.rootObject);
        }
        this.doProcessInternal(this.allObjects);
        subMonitor.done();
    }

    protected boolean isWaitDerivedDataComputation() {
        return this.waitDerivedDataComputation;
    }

    protected void setWaitDerivedDataComputation(boolean waitDerivedDataComputation) {
        this.waitDerivedDataComputation = waitDerivedDataComputation;
    }

    protected boolean isDeepAnalysis() {
        return this.deepAnalysis;
    }

    protected void setDeepAnalysis(boolean deepAnalysis) {
        this.deepAnalysis = deepAnalysis;
    }

    protected void initModule() {
        BslResource resource;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.isDeepAnalysis() && this.rootObject.eResource() instanceof BslResource && (!(resource = (BslResource)this.rootObject.eResource()).isDeepAnalysing() || !resource.isResolveCrossReference())) {
            try {
                BslResource.setSingleThreadMode();
                this.resolveCrossReferences(resource);
            }
            finally {
                BslResource.resetSingleThreadMode();
            }
        }
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    private void doProcessInternal(TryExceptStatement stat) {
        this.doProcess(stat, TryExceptStatement.class);
        this.doProcessInternal((Collection<? extends EObject>)stat.getTryStatements());
        this.doProcessInternal((Collection<? extends EObject>)stat.getExceptStatements());
    }

    private void resolveCrossReferences(BslResource resource) {
        resource.setDeepAnalysis(true);
        boolean saveContextDefMethodType = resource.isSaveContextDefMethodType();
        resource.setSaveContextDefMethodType(false);
        EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)this.getCancelIndicator());
        Collection jobs = BslResolveCrossReferencesJob.findJobsByResource((LazyLinkingResource)resource);
        for (BslResolveCrossReferencesJob job : jobs) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                BslPlugin.logError(e);
            }
        }
        resource.setSaveContextDefMethodType(saveContextDefMethodType);
    }

    private void doProcessInternal(IfStatement stat) {
        this.doProcess(stat, IfStatement.class);
        this.doProcessInternal(stat.getIfPart());
        for (Conditional cond : stat.getElsIfParts()) {
            this.doProcessInternal(cond);
        }
        this.doProcessInternal((Collection<? extends EObject>)stat.getElseStatements());
    }

    private void doProcessInternal(Conditional cond) {
        if (cond == null || this.isCanceled()) {
            return;
        }
        this.doProcessInternal(cond.getPredicate());
        this.doProcessInternal((Collection<? extends EObject>)cond.getStatements());
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    private void doProcessInternal(FunctionStyleCreator expr) {
        this.doProcess(expr, FunctionStyleCreator.class);
        this.doProcessInternal(expr.getTypeNameExpression());
        this.doProcessInternal(expr.getParamsExpression());
    }

    private void doProcessInternal(OperatorStyleCreator expr) {
        this.doProcess(expr, OperatorStyleCreator.class);
        for (Expression param : expr.getParams()) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(param);
        }
    }

    private void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    private void doProcessInternal(EObject stat) {
        if (this.isCanceled()) {
            return;
        }
        if (stat instanceof Method) {
            this.doProcessInternal((Method)stat);
        } else if (stat instanceof FormalParam) {
            this.doProcessInternal((FormalParam)stat);
        } else if (stat instanceof ImplicitVariable) {
            this.doProcessInternal((ImplicitVariable)stat);
        } else if (stat instanceof ExplicitVariable) {
            this.doProcessInternal((ExplicitVariable)stat);
        } else if (stat instanceof SimpleStatement) {
            this.doProcessInternal((SimpleStatement)stat);
        } else if (stat instanceof IfStatement) {
            this.doProcessInternal((IfStatement)stat);
        } else if (stat instanceof ForEachStatement) {
            this.doProcessInternal((ForEachStatement)stat);
        } else if (stat instanceof ReturnStatement) {
            this.doProcessInternal((ReturnStatement)stat);
        } else if (stat instanceof WhileStatement) {
            this.doProcessInternal((WhileStatement)stat);
        } else if (stat instanceof ForToStatement) {
            this.doProcessInternal((ForToStatement)stat);
        } else if (stat instanceof TryExceptStatement) {
            this.doProcessInternal((TryExceptStatement)stat);
        } else if (stat instanceof BreakStatement) {
            this.doProcessInternal((BreakStatement)stat);
        } else if (stat instanceof ContinueStatement) {
            this.doProcessInternal((ContinueStatement)stat);
        } else if (stat instanceof RaiseStatement) {
            this.doProcessInternal((RaiseStatement)stat);
        } else if (stat instanceof AwaitStatement) {
            this.doProcessInternal((AwaitStatement)stat);
        } else if (stat instanceof LabeledStatement) {
            this.doProcessInternal((LabeledStatement)stat);
        } else if (stat instanceof EventHandlerStatement) {
            this.doProcessInternal((EventHandlerStatement)stat);
        } else if (stat instanceof Preprocessor) {
            this.doProcessInternal((Preprocessor)stat);
        } else if (stat instanceof Pragma) {
            this.doProcessInternal((Pragma)stat);
        } else if (stat instanceof DeclareStatement) {
            this.doProcessInternal((DeclareStatement)stat);
        } else if (stat instanceof Literal) {
            this.doProcessInternal((Literal)stat);
        } else if (stat instanceof DynamicFeatureAccess) {
            this.doProcessInternal((DynamicFeatureAccess)stat);
        } else if (stat instanceof Label) {
            this.doProcessInternal((Label)stat);
        } else if (stat instanceof Expression) {
            this.doProcessInternal((Expression)stat);
        } else if (stat instanceof Module) {
            this.doProcessInternal((Module)stat);
        }
    }

    private void doProcessInternal(Module obj) {
        this.doProcess(obj, Module.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getDeclareStatements());
        this.doProcessInternal((Collection<? extends EObject>)obj.getImplicitVariables());
        this.doProcessInternal((Collection<? extends EObject>)obj.getDefaultPragmas());
        this.doProcessInternal((Collection<? extends EObject>)obj.getPreprocessors());
        this.doProcessInternal((Collection<? extends EObject>)obj.getMethods());
        this.doProcessInternal((Collection<? extends EObject>)obj.getStatements());
    }

    private void doProcessInternal(SimpleStatement stat) {
        if (this.isCanceled()) {
            return;
        }
        this.doProcess(stat, SimpleStatement.class);
        Expression left = stat.getLeft();
        if (left instanceof StaticFeatureAccess) {
            this.doProcessInternal((StaticFeatureAccess)left);
        } else {
            this.doProcessInternal(stat.getLeft());
        }
        this.doProcessInternal(stat.getRight());
    }

    private void doProcessInternal(Method stat) {
        this.doProcess(stat, Method.class);
        this.doProcessInternal((Collection<? extends EObject>)stat.getDeclareStatements());
        this.doProcessInternal((Collection<? extends EObject>)stat.getStatements());
        this.doProcessInternal((Collection<? extends EObject>)stat.getImplicitVariables());
        this.doProcessInternal((Collection<? extends EObject>)stat.getPragmas());
        this.doProcessInternal((Collection<? extends EObject>)stat.getFormalParams());
    }

    private void doProcessInternal(FormalParam stat) {
        this.doProcess(stat, FormalParam.class);
    }

    private void doProcessInternal(ImplicitVariable stat) {
        this.doProcess(stat, ImplicitVariable.class);
    }

    private void doProcessInternal(ExplicitVariable stat) {
        this.doProcess(stat, ExplicitVariable.class);
    }

    private void doProcessInternal(WhileStatement stat) {
        this.doProcess(stat, WhileStatement.class);
        this.doProcessInternal(stat.getPredicate());
        this.doProcessInternal((Collection<? extends EObject>)stat.getStatements());
    }

    private void doProcessInternal(ForToStatement stat) {
        this.doProcess(stat, ForToStatement.class);
        this.doProcessInternal(stat.getInitializer());
        this.doProcessInternal(stat.getBound());
        this.doProcessInternal(stat.getVariableAccess());
        this.doProcessInternal((Collection<? extends EObject>)stat.getStatements());
    }

    private void doProcessInternal(ForEachStatement stat) {
        this.doProcess(stat, ForEachStatement.class);
        this.doProcessInternal(stat.getCollection());
        this.doProcessInternal(stat.getVariableAccess());
        this.doProcessInternal((Collection<? extends EObject>)stat.getStatements());
    }

    private void doProcessInternal(ReturnStatement stat) {
        this.doProcess(stat, ReturnStatement.class);
        this.doProcessInternal(stat.getExpression());
    }

    private void doProcessInternal(BreakStatement stat) {
        this.doProcess(stat, BreakStatement.class);
    }

    private void doProcessInternal(ContinueStatement stat) {
        this.doProcess(stat, ContinueStatement.class);
    }

    private void doProcessInternal(RaiseStatement stat) {
        this.doProcess(stat, RaiseStatement.class);
        this.doProcessInternal((Collection<? extends EObject>)stat.getExpressions());
    }

    private void doProcessInternal(AwaitStatement stat) {
        this.doProcess(stat, AwaitStatement.class);
        this.doProcessInternal(stat.getExpression());
    }

    private void doProcessInternal(LabeledStatement stat) {
        this.doProcess(stat, LabeledStatement.class);
        this.doProcessInternal((Collection<? extends EObject>)stat.getLabels());
        this.doProcessInternal((EObject)stat.getStatement());
    }

    private void doProcessInternal(Label label) {
        this.doProcess(label, Label.class);
    }

    private void doProcessInternal(Preprocessor stat) {
        this.doProcess(stat, Preprocessor.class);
        List allItems = BslUtil.getAllPreprocessorItems((EObject)stat);
        for (PreprocessorItem item : allItems) {
            if (this.isCanceled()) {
                return;
            }
            if (item instanceof PreprocessorItemStatements) {
                this.doProcessInternal((Collection<? extends EObject>)((PreprocessorItemStatements)item).getStatements());
            }
            if (item instanceof PreprocessorItemDeclareStatement) {
                this.doProcessInternal((Collection<? extends EObject>)((PreprocessorItemDeclareStatement)item).getDeclareStatements());
            }
            if (item instanceof PreprocessorItemExpression) {
                this.doProcessInternal(((PreprocessorItemExpression)item).getExpression());
            }
            if (item instanceof PreprocessorItemMethodStatement) {
                this.doProcessInternal((Collection<? extends EObject>)((PreprocessorItemMethodStatement)item).getMethods());
                this.doProcessInternal((Collection<? extends EObject>)((PreprocessorItemMethodStatement)item).getPreprocessors());
            }
            if (!(item instanceof RegionPreprocessorDeclareStatement)) continue;
            this.doProcessInternal((Collection<? extends EObject>)((RegionPreprocessorDeclareStatement)item).getPragmas());
            this.doProcessInternal((Collection<? extends EObject>)((RegionPreprocessorDeclareStatement)item).getVariables());
        }
    }

    private void doProcessInternal(EventHandlerStatement stat) {
        this.doProcess(stat, EventHandlerStatement.class);
        this.doProcessInternal(stat.getEventExpression());
        this.doProcessInternal(stat.getHandlerExpression());
    }

    private void doProcessInternal(DeclareStatement stat) {
        this.doProcess(stat, DeclareStatement.class);
        this.doProcessInternal((Collection<? extends EObject>)stat.getPragmas());
        this.doProcessInternal((Collection<? extends EObject>)stat.getVariables());
    }

    private void doProcessInternal(Pragma pragma) {
        this.doProcess(pragma, Pragma.class);
    }

    private void doProcessInternal(Expression expr) {
        if (this.isCanceled()) {
            return;
        }
        if (expr instanceof StaticFeatureAccess) {
            this.doProcessInternal((StaticFeatureAccess)expr);
        } else if (expr instanceof DynamicFeatureAccess) {
            this.doProcessInternal((DynamicFeatureAccess)expr);
        } else if (expr instanceof Invocation) {
            this.doProcessInternal((Invocation)expr);
        } else if (expr instanceof BinaryExpression) {
            this.doProcessInternal((BinaryExpression)expr);
        } else if (expr instanceof UnaryExpression) {
            this.doProcessInternal((UnaryExpression)expr);
        } else if (expr instanceof IndexAccess) {
            this.doProcessInternal((IndexAccess)expr);
        } else if (expr instanceof FunctionStyleCreator) {
            this.doProcessInternal((FunctionStyleCreator)expr);
        } else if (expr instanceof OperatorStyleCreator) {
            this.doProcessInternal((OperatorStyleCreator)expr);
        } else if (expr instanceof AwaitExpression) {
            this.doProcessInternal((AwaitExpression)expr);
        } else if (expr instanceof Literal) {
            this.doProcessInternal((Literal)expr);
        } else if (expr instanceof RegionPreprocessorExpression) {
            PreprocessorItem item = ((RegionPreprocessorExpression)expr).getItem();
            if (item instanceof PreprocessorItemExpression) {
                this.doProcessInternal(((PreprocessorItemExpression)item).getExpression());
            }
            if ((item = ((RegionPreprocessorExpression)expr).getItemAfter()) instanceof PreprocessorItemExpression) {
                this.doProcessInternal(((PreprocessorItemExpression)item).getExpression());
            }
        }
    }

    private void doProcessInternal(BinaryExpression expr) {
        this.doProcess(expr, BinaryExpression.class);
        this.doProcessInternal(expr.getLeft());
        this.doProcessInternal(expr.getRight());
    }

    private void doProcessInternal(UnaryExpression expr) {
        this.doProcess(expr, UnaryExpression.class);
        this.doProcessInternal(expr.getOperand());
    }

    private void doProcessInternal(StaticFeatureAccess expr) {
        if (expr != null) {
            this.doProcess(expr, StaticFeatureAccess.class);
        }
    }

    private void doProcessInternal(DynamicFeatureAccess expr) {
        this.doProcess(expr, DynamicFeatureAccess.class);
        this.doProcessInternal(expr.getSource());
    }

    private void doProcessInternal(Invocation expr) {
        this.doProcess(expr, Invocation.class);
        this.doProcessInternal((Expression)expr.getMethodAccess());
        for (Expression param : expr.getParams()) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(param);
        }
    }

    private void doProcessInternal(IndexAccess expr) {
        this.doProcess(expr, IndexAccess.class);
        this.doProcessInternal(expr.getSource());
        this.doProcessInternal(expr.getIndex());
    }

    private void doProcessInternal(AwaitExpression expr) {
        this.doProcess(expr, AwaitExpression.class);
        this.doProcessInternal(expr.getExpression());
    }

    private void doProcessInternal(Literal expr) {
        this.doProcess(expr, Literal.class);
    }
}

