/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.cleaner;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class BslNStrCleanupVisitor
extends MultiTextEditParseTreeVisitor {
    private final IFile file;
    private final String defaultLanguageCode;
    private Map<String, TranslateLanguage> languageCodes;
    private Map<TranslateLanguage, Map<ContextTranslationKey, String>> translations;
    private final ITranslationFeatureKeyProvider translationKeyProvider;
    private final IStringLiteralTypeComputer typeComputer;
    private StringLiteral lastProcessedLiteral = null;
    private int stringLiteralLineCount = 0;
    private String[] stringLiteralIndentation = null;
    private int stringLiteralIndentationLineIndex = 0;
    private Map<String, String> stringLiteralValueMap = null;
    private boolean stringLiteralValueMapModified = false;
    private boolean keepLanguages;
    private final BslPreferences bslPreferences;

    public BslNStrCleanupVisitor(MultiTextEdit multiTextEdit, IFile file, String defaultLanguageCode, Collection<? extends TranslateLanguage> languages, boolean keepLanguages, Map<TranslateLanguage, Map<ContextTranslationKey, String>> translations, ITranslationFeatureKeyProvider translationKeyProvider, IStringLiteralTypeComputer typeComputer, BslPreferences bslPreferences) {
        super(multiTextEdit);
        this.file = file;
        this.defaultLanguageCode = defaultLanguageCode;
        this.languageCodes = languages.stream().collect(Collectors.toMap(TranslateLanguage::getLanguageCode, Function.identity(), (first, second) -> first));
        this.translations = translations;
        this.translationKeyProvider = translationKeyProvider;
        this.typeComputer = typeComputer;
        this.keepLanguages = keepLanguages;
        this.bslPreferences = bslPreferences;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(ILeafNode node) {
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        EObject eObject = semanticElement;
        if (eObject instanceof StringLiteral) {
            void stringLiteral;
            StringLiteral stringLiteral2 = (StringLiteral)eObject;
            StringLiteral cfr_ignored_0 = (StringLiteral)eObject;
            if (this.typeComputer.containsAnyType((StringLiteral)stringLiteral, new String[]{"NStr"})) {
                if (this.lastProcessedLiteral == null || this.lastProcessedLiteral != stringLiteral) {
                    this.lastProcessedLiteral = stringLiteral;
                    this.stringLiteralLineCount = stringLiteral.getLines().size();
                    this.stringLiteralIndentation = new String[Math.max(1, this.stringLiteralLineCount)];
                    this.stringLiteralIndentation[0] = BslUtils.getNodeIdentation((INode)NodeModelUtils.getNode((EObject)stringLiteral), 0);
                    this.stringLiteralIndentationLineIndex = 1;
                    this.stringLiteralValueMapModified = false;
                    IProject project = this.file.getProject();
                    TranslatorProperties bslTranslatorProperties = this.bslPreferences.getTranslatorProperties(project);
                    boolean alphabeticalLanguageOrderInNStr = bslTranslatorProperties.isAlphabeticalLanguageOrderInNStr();
                    this.stringLiteralValueMap = alphabeticalLanguageOrderInNStr ? new TreeMap<String, String>(BslUtils.getNlsLocalStrings((StringLiteral)stringLiteral)) : BslUtils.getNlsLocalStrings((StringLiteral)stringLiteral);
                    String sourceString = this.stringLiteralValueMap.get(this.defaultLanguageCode);
                    if (StringUtils.isBlank((String)sourceString) && !this.stringLiteralValueMap.containsKey(this.defaultLanguageCode)) {
                        this.lastProcessedLiteral = null;
                        return true;
                    }
                    if (this.translations != null) {
                        this.exportStrings((StringLiteral)stringLiteral, sourceString);
                    }
                } else if (node.isHidden() && this.stringLiteralIndentationLineIndex < this.stringLiteralIndentation.length) {
                    String lineIndentation = node.getText();
                    int index = lineIndentation.indexOf(BslUtils.SYSTEM_LINE_SEPARATOR);
                    if (index > -1) {
                        lineIndentation = lineIndentation.substring(index + BslUtils.SYSTEM_LINE_SEPARATOR.length());
                    }
                    this.stringLiteralIndentation[this.stringLiteralIndentationLineIndex] = lineIndentation;
                    ++this.stringLiteralIndentationLineIndex;
                }
                if ((this.stringLiteralIndentationLineIndex > 1 || !node.isHidden()) && this.stringLiteralValueMapModified) {
                    this.addReplaceInternal(node);
                }
            }
        }
        return true;
    }

    private void addReplaceInternal(ILeafNode node) {
        String replaceTo;
        if (this.stringLiteralIndentationLineIndex == this.stringLiteralLineCount && !node.isHidden()) {
            replaceTo = BslUtils.formatNStrStringLiteral(this.stringLiteralValueMap, this.stringLiteralIndentation);
            this.lastProcessedLiteral = null;
        } else {
            replaceTo = "";
        }
        this.addReplace(node, replaceTo);
    }

    private void exportStrings(StringLiteral stringLiteral, String sourceString) {
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)stringLiteral, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES, sourceString);
        Iterator<Map.Entry<String, String>> iterator = this.stringLiteralValueMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String languageCode = entry.getKey();
            if (languageCode.equalsIgnoreCase(this.defaultLanguageCode)) continue;
            boolean isRemove = false;
            isRemove = this.keepLanguages ? !this.languageCodes.containsKey(languageCode) : this.languageCodes.containsKey(languageCode);
            if (!isRemove) continue;
            TranslateLanguage language = this.languageCodes.get(languageCode);
            Map perLanguageTranslations = this.translations.computeIfAbsent(language, newLanguage -> new HashMap());
            perLanguageTranslations.put(contextKey, entry.getValue());
            iterator.remove();
            this.stringLiteralValueMapModified = true;
        }
    }
}

