/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.comment;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.LinkPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TextPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BslDocCommentSerializer {
    private static final int DEFAULT_SECTION_SPACE = 2;
    private int sectionSpace;
    private boolean ignoreLineNumbers;

    public BslDocCommentSerializer() {
        this.setSectionSpace(2);
        this.setIgnoreLineNumbers(true);
    }

    public int getSectionSpace() {
        return this.sectionSpace;
    }

    public void setSectionSpace(int sectionSpace) {
        this.sectionSpace = sectionSpace;
    }

    public boolean isIgnoreLineNumbers() {
        return this.ignoreLineNumbers;
    }

    public void setIgnoreLineNumbers(boolean ignoreLineNumbers) {
        this.ignoreLineNumbers = ignoreLineNumbers;
    }

    public String serialize(BslDocumentationComment docComment, boolean isRu) {
        return this.serialize(docComment, isRu, "", "    ", false);
    }

    public String serialize(BslDocumentationComment docComment, boolean isRu, boolean oldFormat) {
        return this.serialize(docComment, isRu, "", "    ", oldFormat);
    }

    public String serialize(BslDocumentationComment docComment, boolean isRu, String lineFormatter, String indent, boolean oldFormat) {
        int lineNumber;
        StringBuilder builder = new StringBuilder();
        builder.append(lineFormatter).append("//").append(' ');
        if (docComment.isDeprecated()) {
            builder.append(isRu ? "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430." : "Deprecated.");
            if (!this.isIgnoreLineNumbers() || !docComment.getDescription().getParts().isEmpty()) {
                builder.append(' ');
            }
        }
        int currentLine = this.serializeDescription(0, docComment.getDescription(), isRu, oldFormat, lineFormatter, indent, 0, builder);
        if (!(docComment.getParametersSection() == null || docComment.getParametersSection().getDescription().getParts().isEmpty() && docComment.getParametersSection().getParameterDefinitions().isEmpty())) {
            lineNumber = this.isIgnoreLineNumbers() ? currentLine + this.getSectionSpace() : docComment.getParametersSection().getLineNumber();
            this.addEmptyLines(currentLine, lineNumber, lineFormatter, 0, builder);
            currentLine = lineNumber;
            builder.append(isRu ? "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:" : "Parameters:");
            if (!this.isIgnoreLineNumbers() || !docComment.getParametersSection().getDescription().getParts().isEmpty()) {
                builder.append(' ');
            }
            currentLine = this.serializeDescription(currentLine, docComment.getParametersSection().getDescription(), isRu, oldFormat, lineFormatter, indent, 0, builder);
            ++currentLine;
            currentLine = this.serializeFieldDefinitions(currentLine, docComment.getParametersSection().getParameterDefinitions(), isRu, oldFormat, lineFormatter, indent, -4, 0, builder);
        }
        if (docComment.getCallOptionsSection() != null && !docComment.getCallOptionsSection().getDescription().getParts().isEmpty()) {
            lineNumber = this.isIgnoreLineNumbers() ? currentLine + this.getSectionSpace() : docComment.getCallOptionsSection().getLineNumber();
            this.addEmptyLines(currentLine, lineNumber, lineFormatter, 0, builder);
            currentLine = lineNumber;
            builder.append(isRu ? "\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u0432\u044b\u0437\u043e\u0432\u0430:" : "Call options:");
            if (!this.isIgnoreLineNumbers() || !docComment.getCallOptionsSection().getDescription().getParts().isEmpty()) {
                builder.append(' ');
            }
            currentLine = this.serializeDescription(currentLine, docComment.getCallOptionsSection().getDescription(), isRu, oldFormat, lineFormatter, indent, 0, builder);
        }
        if (!(docComment.getReturnSection() == null || docComment.getReturnSection().getDescription().getParts().isEmpty() && docComment.getReturnSection().getReturnTypes().isEmpty())) {
            lineNumber = this.isIgnoreLineNumbers() ? currentLine + this.getSectionSpace() : docComment.getReturnSection().getLineNumber();
            this.addEmptyLines(currentLine, lineNumber, lineFormatter, 0, builder);
            currentLine = lineNumber;
            builder.append(isRu ? "\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:" : "Returns:");
            if (!oldFormat) {
                if (!this.isIgnoreLineNumbers() || !docComment.getReturnSection().getDescription().getParts().isEmpty()) {
                    builder.append(' ');
                }
                currentLine = this.serializeDescription(currentLine, docComment.getReturnSection().getDescription(), isRu, oldFormat, lineFormatter, indent, 0, builder);
                for (TypeSection typeSection : docComment.getReturnSection().getReturnTypes()) {
                    currentLine = this.serialize(typeSection, currentLine, isRu, oldFormat, lineFormatter, indent, 0, 1, builder);
                }
            } else if (!docComment.getReturnSection().getReturnTypes().isEmpty()) {
                List parts = docComment.getReturnSection().getDescription().getParts();
                ArrayList<IDescriptionPart> partsOnStartLine = new ArrayList<IDescriptionPart>(parts.size());
                ArrayList<IDescriptionPart> partsOnAnotherLine = new ArrayList<IDescriptionPart>(parts.size());
                int i = 0;
                while (i < parts.size()) {
                    IDescriptionPart part = (IDescriptionPart)parts.get(i);
                    if (!this.isIgnoreLineNumbers() && part.getLineNumber() == docComment.getReturnSection().getLineNumber()) {
                        partsOnStartLine.add(part);
                    } else {
                        partsOnAnotherLine.add(part);
                    }
                    ++i;
                }
                if (!this.isIgnoreLineNumbers() || !partsOnStartLine.isEmpty()) {
                    builder.append(' ');
                }
                currentLine = this.serializeDescription(currentLine, partsOnStartLine, isRu, oldFormat, lineFormatter, indent, 0, builder);
                TypeSection typeSection = (TypeSection)docComment.getReturnSection().getReturnTypes().get(0);
                if (this.isIgnoreLineNumbers()) {
                    this.addEmptyLines(currentLine, currentLine + 1, lineFormatter, 1, builder);
                    ++currentLine;
                }
                currentLine = this.serialize(typeSection, currentLine, isRu, oldFormat, lineFormatter, indent, 0, 1, builder);
                if (!partsOnAnotherLine.isEmpty()) {
                    this.addEmptyLines(currentLine, currentLine + 1, lineFormatter, 0, builder);
                    currentLine = this.serializeDescription(currentLine, partsOnAnotherLine, isRu, oldFormat, lineFormatter, indent, 0, builder);
                }
            } else {
                if (!this.isIgnoreLineNumbers() || !docComment.getReturnSection().getDescription().getParts().isEmpty()) {
                    builder.append(' ');
                }
                currentLine = this.serializeDescription(currentLine, docComment.getReturnSection().getDescription(), isRu, oldFormat, lineFormatter, indent, 0, builder);
            }
        }
        if (docComment.getExampleSection() != null && !docComment.getExampleSection().getDescription().getParts().isEmpty()) {
            lineNumber = this.isIgnoreLineNumbers() ? currentLine + this.getSectionSpace() : docComment.getExampleSection().getLineNumber();
            this.addEmptyLines(currentLine, lineNumber, lineFormatter, 0, builder);
            currentLine = lineNumber;
            builder.append(isRu ? "\u041f\u0440\u0438\u043c\u0435\u0440:" : "Example:");
            if (!this.isIgnoreLineNumbers() || !docComment.getExampleSection().getDescription().getParts().isEmpty()) {
                builder.append(' ');
            }
            currentLine = this.serializeDescription(currentLine, docComment.getExampleSection().getDescription(), isRu, oldFormat, lineFormatter, indent, 0, builder);
        }
        return builder.toString();
    }

    void addEmptyLines(int currentLine, int nextPartLine, String lineFormatter, int alignmentSpaces, StringBuilder builder) {
        if (nextPartLine > currentLine) {
            int count = nextPartLine - currentLine - 1;
            int i = 0;
            while (i < count) {
                builder.append(System.lineSeparator()).append(lineFormatter).append("//").append(' ');
                ++i;
            }
            builder.append(System.lineSeparator()).append(lineFormatter).append("//").append(' ');
            builder.append(Strings.repeat((String)" ", (int)alignmentSpaces));
        }
    }

    int serializeDescription(int currentLine, BslDocumentationComment.Description description, boolean isRu, boolean oldFormat, String lineFormatter, String indent, int alignmentSpaces, StringBuilder builder) {
        return this.serializeDescription(currentLine, description.getParts(), isRu, oldFormat, lineFormatter, indent, alignmentSpaces, builder);
    }

    private int serializeDescription(int currentLine, List<IDescriptionPart> parts, boolean isRu, boolean oldFormat, String lineFormatter, String indent, int alignmentSpaces, StringBuilder builder) {
        boolean isPrevTextPart = false;
        for (IDescriptionPart part : parts) {
            int lineNumber;
            int n = lineNumber = this.isIgnoreLineNumbers() ? currentLine : part.getLineNumber();
            if (isPrevTextPart && this.isIgnoreLineNumbers()) {
                lineNumber = currentLine + 1;
            }
            this.addEmptyLines(currentLine, lineNumber, lineFormatter, alignmentSpaces, builder);
            currentLine = lineNumber;
            isPrevTextPart = false;
            if (part instanceof TextPart) {
                builder.append(((TextPart)part).getText());
                isPrevTextPart = true;
                continue;
            }
            if (part instanceof LinkPart) {
                builder.append(this.serialize((LinkPart)part, isRu));
                continue;
            }
            if (!(part instanceof TypeSection)) continue;
            this.serialize((TypeSection)part, currentLine, isRu, oldFormat, lineFormatter, indent, alignmentSpaces, 0, builder);
        }
        return currentLine;
    }

    int serializeFieldDefinitions(int currentLine, List<TypeSection.FieldDefinition> fieldExtension, boolean isRu, boolean oldFormat, String lineFormatter, String indent, int alignmentSpaces, int starNumber, StringBuilder builder) {
        int i = 0;
        while (i < fieldExtension.size()) {
            TypeSection.FieldDefinition field = fieldExtension.get(i);
            if (field.getName() != null && !field.getName().isEmpty()) {
                builder.append(System.lineSeparator()).append(lineFormatter).append("//").append(' ');
                ++currentLine;
                if (!oldFormat) {
                    builder.append(Strings.repeat((String)" ", (int)Math.max(0, alignmentSpaces)));
                    if (alignmentSpaces >= 0) {
                        builder.append(indent);
                    }
                    builder.append("*").append(' ');
                } else {
                    builder.append(Strings.repeat((String)" ", (int)Math.max(0, alignmentSpaces)));
                    builder.append(Strings.repeat((String)"*", (int)starNumber)).append(' ');
                }
                builder.append(field.getName()).append(' ');
                if (!oldFormat) {
                    currentLine = this.serializeDescription(currentLine, field.getDescription(), isRu, oldFormat, lineFormatter, indent, 2 * indent.length() + alignmentSpaces, builder);
                    for (TypeSection typeSection : field.getTypeSections()) {
                        currentLine = this.serialize(typeSection, currentLine, isRu, oldFormat, lineFormatter, indent, 2 * indent.length() + alignmentSpaces, starNumber + 1, builder);
                    }
                } else if (!field.getTypeSections().isEmpty()) {
                    TypeSection typeSection;
                    typeSection = (TypeSection)field.getTypeSections().get(0);
                    builder.append("-").append(' ');
                    currentLine = this.serialize(typeSection, currentLine, isRu, oldFormat, lineFormatter, indent, indent.length() + alignmentSpaces, starNumber + 1, builder);
                    if (!field.getDescription().getParts().isEmpty()) {
                        builder.append(System.lineSeparator()).append(lineFormatter).append("//").append(' ');
                        ++currentLine;
                        builder.append(Strings.repeat((String)" ", (int)(indent.length() + alignmentSpaces)));
                        for (IDescriptionPart part : field.getDescription().getParts()) {
                            if (part instanceof TextPart) {
                                builder.append(((TextPart)part).getText());
                                continue;
                            }
                            if (!(part instanceof LinkPart)) continue;
                            builder.append(this.serialize((LinkPart)part, isRu));
                        }
                    }
                } else {
                    currentLine = this.serializeDescription(currentLine, field.getDescription(), isRu, oldFormat, lineFormatter, indent, indent.length() + alignmentSpaces, builder);
                }
            }
            ++i;
        }
        return currentLine;
    }

    private int serialize(TypeSection typeSection, int currentLine, boolean isRu, boolean oldFormat, String lineFormatter, String indent, int alignmentSpaces, int starNumber, StringBuilder builder) {
        int lineNumber = this.isIgnoreLineNumbers() ? currentLine : typeSection.getLineNumber();
        this.addEmptyLines(currentLine, lineNumber, lineFormatter, alignmentSpaces, builder);
        currentLine = lineNumber;
        if (!typeSection.getTypeDefinitions().isEmpty()) {
            int numberCharsForPreviousLine = 0;
            int i = builder.length() - 1;
            while (i >= 0) {
                if (builder.charAt(i) == '\n') {
                    numberCharsForPreviousLine = builder.length() - i - 1;
                    numberCharsForPreviousLine -= "//".length() + 1;
                    break;
                }
                --i;
            }
            List fieldExtension = null;
            if (!oldFormat) {
                builder.append("[");
            }
            HashSet addTypeNames = Sets.newHashSet();
            int i2 = 0;
            while (i2 < typeSection.getTypeDefinitions().size()) {
                TypeSection.TypeDefinition definition = (TypeSection.TypeDefinition)typeSection.getTypeDefinitions().get(i2);
                String typeName = definition.getTypeName();
                if (typeName != null && !typeName.isEmpty() && addTypeNames.add(typeName)) {
                    if (i2 != 0) {
                        builder.append(",").append(' ');
                    }
                    builder.append(typeName);
                }
                if (i2 == typeSection.getTypeDefinitions().size() - 1) {
                    if (!definition.getContainTypes().isEmpty()) {
                        builder.append(' ').append(isRu ? "\u0438\u0437" : "of").append(' ');
                        HashSet addContainsTypeNames = Sets.newHashSet();
                        int j = 0;
                        while (j < definition.getContainTypes().size()) {
                            TypeSection.TypeDefinition containsDefinition = (TypeSection.TypeDefinition)definition.getContainTypes().get(j);
                            typeName = containsDefinition.getTypeName();
                            if (typeName != null && !typeName.isEmpty() && addContainsTypeNames.add(typeName)) {
                                if (j != 0) {
                                    builder.append(",").append(' ');
                                }
                                builder.append(typeName);
                            }
                            if (j == definition.getContainTypes().size() - 1) {
                                fieldExtension = containsDefinition.getFieldDefinitionExtension();
                            }
                            ++j;
                        }
                    } else if (fieldExtension == null || fieldExtension.isEmpty()) {
                        fieldExtension = definition.getFieldDefinitionExtension();
                    }
                }
                ++i2;
            }
            if (fieldExtension != null && !fieldExtension.isEmpty()) {
                if (oldFormat) {
                    builder.append(' ').append('-');
                    for (IDescriptionPart part : typeSection.getDescription().getParts()) {
                        if (part instanceof TextPart) {
                            builder.append(((TextPart)part).getText());
                            continue;
                        }
                        if (!(part instanceof LinkPart)) continue;
                        builder.append(this.serialize((LinkPart)part, isRu));
                    }
                }
                builder.append(":");
                currentLine = this.serializeFieldDefinitions(currentLine, fieldExtension, isRu, oldFormat, lineFormatter, indent, numberCharsForPreviousLine, starNumber, builder);
                if (!oldFormat) {
                    builder.append(System.lineSeparator()).append(lineFormatter).append("//").append(' ');
                    ++currentLine;
                    builder.append(Strings.repeat((String)" ", (int)numberCharsForPreviousLine));
                    builder.append("]");
                }
            } else if (!oldFormat) {
                builder.append("]");
            } else {
                builder.append(' ').append('-');
                currentLine = this.serializeDescription(currentLine, typeSection.getDescription(), isRu, oldFormat, lineFormatter, indent, alignmentSpaces, builder);
            }
        }
        if (!oldFormat) {
            currentLine = this.serializeDescription(currentLine, typeSection.getDescription(), isRu, oldFormat, lineFormatter, indent, alignmentSpaces, builder);
        }
        return currentLine;
    }

    public String serialize(LinkPart linkPart, boolean isRu) {
        return "(" + (isRu ? "\u0421\u043c." : "See") + " " + linkPart.getLinkText() + ")";
    }
}

