/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.comment;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.LinkPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TagPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TextPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.Function;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.ReturnStatement;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.Type;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.comment.BslCommentFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentKeyComputer;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.BslDocCommentParser;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class DocCommentCollector
extends DocCommentProcessor
implements FeatureValueCollector {
    @Inject
    protected ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private DocCommentKeyComputer keyComputer;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private TypesComputer typesComputer;
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private BslDocCommentParser bslDocCommentParser;
    @Inject
    private BslPreferences preferences;
    protected final BmOperationContext typeComputationContext;
    private final IFile file;
    private final FeatureKey featureKeyPreffix;
    private final ICollectingParameters parameters;
    private BiConsumer<Object, FeatureValue> addAction;
    private final EObject context;
    private String defaultLanguageCode;
    private List<TypeItem> functionReturnTypes;
    private final IScopeProvider scopeProvider;

    public static DocCommentCollector create(IFile file, FeatureKey featureKeyPreffix, BslDocumentationComment object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction, EObject context, BmOperationContext typeComputationContext) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        Assert.isNotNull((Object)file, (String)"file cannot be null");
        Assert.isNotNull((Object)featureKeyPreffix, (String)"featureKeyPreffix cannot be null");
        DocCommentCollector collector = new DocCommentCollector(file, featureKeyPreffix, object, parameters, addAction, context, typeComputationContext);
        BslPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    protected DocCommentCollector(IFile file, FeatureKey featureKeyPreffix, Object rootObject, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction, EObject context, BmOperationContext typeComputationContext) {
        super(rootObject);
        this.file = file;
        this.featureKeyPreffix = featureKeyPreffix;
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        this.addAction = addAction;
        this.context = context;
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        this.scopeProvider = (IScopeProvider)rsp.get(IScopeProvider.class);
        this.typeComputationContext = typeComputationContext;
    }

    protected void setAddAction(BiConsumer<Object, FeatureValue> addAction) {
        this.addAction = addAction;
    }

    @Override
    protected <T> void doProcess(DocCommentProcessor.Parent parent, T object, Class<T> clazz) {
        if (object == null) {
            return;
        }
        if (!this.isSupported(object)) {
            return;
        }
        if (object instanceof BslDocumentationComment.Description) {
            this.doProcess(parent, (BslDocumentationComment.Description)object);
        } else if (object instanceof TypeSection.FieldDefinition && !(parent.getCurrent() instanceof BslDocumentationComment.ParametersSection)) {
            this.doProcess(parent, (TypeSection.FieldDefinition)object);
        }
    }

    private boolean isSupported(Object object) {
        return object instanceof BslDocumentationComment.Description || object instanceof TypeSection.FieldDefinition;
    }

    protected void doProcess(DocCommentProcessor.Parent parent, BslDocumentationComment.Description object) {
        if (object.getParts().isEmpty() || !this.keyComputer.isSupported(object)) {
            return;
        }
        FeatureKey key = this.keyComputer.getFeatureKey(parent, object);
        if (key != null) {
            key = key.append(BslCommentFeatureSettings.Literals.DOC_COMMENT__DESCRIPTION.getName());
        }
        if (key == null || key.isEmpty()) {
            return;
        }
        IV8Project project = this.v8ProjectManager.getProject(this.context);
        if (!this.preferences.getTranslatorProperties(project.getProject()).isEnableTagPartInDocComment()) {
            this.replaceTagParts(object);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TagPart> tagParts = new ArrayList<TagPart>();
        int currentLine = 0;
        boolean realLinkBefore = false;
        for (IDescriptionPart part : object.getParts()) {
            if (part instanceof TextPart) {
                if (this.isSkipTextPart(object, (TextPart)part)) {
                    realLinkBefore = false;
                    continue;
                }
                if (sb.length() > 0 && (realLinkBefore || part.getLineNumber() > currentLine)) {
                    sb.append("\n");
                } else if (!realLinkBefore && sb.length() > 0) {
                    sb.append(" ");
                }
                String text = ((TextPart)part).getText();
                text = BslUtils.getTextWithoutSplashes(text);
                text = this.removeLeadingDash(object, part, text);
                text = this.removeDeprecated(text);
                if (!text.isEmpty()) {
                    sb.append(text);
                }
                realLinkBefore = false;
            } else if (part instanceof LinkPart) {
                LinkPart link = (LinkPart)part;
                realLinkBefore = this.isRealLink(link);
                if (!realLinkBefore && sb.length() > 0 && currentLine < part.getLineNumber()) {
                    sb.append("\n");
                }
                if (!realLinkBefore) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(link.getInitialContent());
                }
            } else if (part instanceof TagPart) {
                tagParts.add((TagPart)part);
            }
            currentLine = part.getLineNumber();
        }
        String featureValue = sb.toString();
        boolean computedValue = StringUtils.isNotWord((String)featureValue);
        if (!tagParts.isEmpty()) {
            this.collectTags(this.keyComputer.getFeatureKey(parent, object), tagParts, computedValue);
        }
        if (sb.length() == 0 && !this.parameters.isCollectEmptyValue()) {
            return;
        }
        if (!TranslationUtils.isValidValueForCollectModelType((boolean)computedValue, (boolean)false, (boolean)false, (ICollectingParameters.CollectModelType)this.parameters.getCollectModelType())) {
            return;
        }
        FeatureKey featureKey = this.featureKeyPreffix.append(key);
        PersistableFeatureValue fv = new PersistableFeatureValue(this.file, featureKey, BslCommentFeatureSettings.Literals.DOC_COMMENT__DESCRIPTION, featureValue, computedValue);
        fv.getLocalStrings().put(this.getDefaultLanguageCode(), featureValue);
        this.addAction.accept(object, (FeatureValue)fv);
    }

    protected boolean isSkipTextPart(BslDocumentationComment.Description object, TextPart part) {
        String text = part.getText();
        return StringUtils.isBlank((String)text) || text.startsWith("- ") && object.getParts().indexOf(part) == 0 && StringUtils.isBlank((String)text.replace("- ", ""));
    }

    protected void doProcess(DocCommentProcessor.Parent parent, TypeSection.FieldDefinition object) {
        if (StringUtils.isNullOrEmpty((String)object.getName()) || !this.keyComputer.isSupported(object)) {
            return;
        }
        FeatureKey key = this.keyComputer.getFeatureKey(parent, object);
        if (key != null) {
            key = key.append(BslCommentFeatureSettings.Literals.FIELD_DEFINITION__NAME.getName());
        }
        if (key == null || key.isEmpty()) {
            return;
        }
        String featureValue = object.getName();
        if (featureValue.startsWith("\"") && featureValue.endsWith("\"")) {
            featureValue = featureValue.substring(1, featureValue.length() - 1);
        }
        FeatureKey featureKey = this.featureKeyPreffix.append(key);
        boolean computedValue = this.isComputedValue(parent, object);
        if (TranslationUtils.isValidValueForCollectModelType((boolean)computedValue, (boolean)false, (boolean)false, (ICollectingParameters.CollectModelType)this.parameters.getCollectModelType())) {
            PersistableFeatureValue fv = new PersistableFeatureValue(this.file, featureKey, BslCommentFeatureSettings.Literals.FIELD_DEFINITION__NAME, featureValue, computedValue);
            fv.getLocalStrings().put(this.getDefaultLanguageCode(), featureValue);
            this.addAction.accept(object, (FeatureValue)fv);
        }
    }

    protected boolean isRealLink(LinkPart link) {
        if (link.getLinkText().startsWith("http")) {
            return true;
        }
        int i = link.getPartsWithOffset().size() - 1;
        while (i > -1) {
            EObject obj = link.getActualObjectForPart(i, this.scopeProvider, this.context, this.v8ProjectManager, this.typeComputationContext);
            if (obj != null) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected boolean isComputedValue(DocCommentProcessor.Parent parent, TypeSection.FieldDefinition object) {
        return !this.getFieldProperty(parent, object).isEmpty();
    }

    protected Collection<Property> getFieldProperty(DocCommentProcessor.Parent parent, TypeSection.FieldDefinition object) {
        if (this.context instanceof Function && parent != null) {
            List<Pair<String, String>> typeFieldOrder = this.getFunctionReturnTypeFieldOrder(parent, object);
            if (typeFieldOrder.isEmpty()) {
                return Collections.emptyList();
            }
            Function func = (Function)this.context;
            List<TypeItem> funcTypes = this.getFunctionReturnTypes();
            return this.getFieldPropertyByOrder(typeFieldOrder, funcTypes, func.eResource());
        }
        return Collections.emptyList();
    }

    protected Collection<Property> getFieldPropertyByOrder(List<Pair<String, String>> typeFieldOrder, List<TypeItem> types, Resource res) {
        List<Object> currentTypes = types;
        List properties = null;
        for (Pair<String, String> typeFiled : typeFieldOrder) {
            if (currentTypes.isEmpty() || typeFiled.getFirst() == null) {
                return Collections.emptyList();
            }
            String typeName = (String)typeFiled.getFirst();
            if (typeFiled.getSecond() == null) {
                currentTypes = currentTypes.stream().filter(t -> t instanceof Type && (typeName.equalsIgnoreCase(McoreUtil.getTypeNameRu((TypeItem)t)) || typeName.equalsIgnoreCase(McoreUtil.getTypeName((TypeItem)t))) && ((Type)t).getCollectionElementTypes() != null && ((Type)t).getCollectionElementTypes().allTypes() != null).map(Type.class::cast).flatMap(t -> t.getCollectionElementTypes().allTypes().stream()).collect(Collectors.toList());
                continue;
            }
            properties = this.dynamicFeatureAccessComputer.getAllProperties(currentTypes, res).stream().filter(pair -> typeName.equalsIgnoreCase(McoreUtil.getTypeNameRu((TypeItem)((TypeItem)pair.getSecond()))) || typeName.equalsIgnoreCase(McoreUtil.getTypeName((TypeItem)((TypeItem)pair.getSecond())))).flatMap(p -> ((Collection)p.getFirst()).stream()).filter(p -> ((String)typeFiled.getSecond()).equalsIgnoreCase(p.getNameRu()) || ((String)typeFiled.getSecond()).equalsIgnoreCase(p.getName())).collect(Collectors.toList());
            currentTypes = properties.stream().flatMap(p -> p.getTypes().stream()).collect(Collectors.toList());
        }
        if (properties != null) {
            return properties;
        }
        return Collections.emptyList();
    }

    protected List<Pair<String, String>> getFunctionReturnTypeFieldOrder(DocCommentProcessor.Parent currentParent, TypeSection.FieldDefinition object) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        DocCommentProcessor.Parent parent = currentParent;
        TypeSection.FieldDefinition field = object;
        while (parent != null) {
            if (parent.getCurrent() instanceof TypeSection.TypeDefinition) {
                TypeSection.TypeDefinition typeDefinition = (TypeSection.TypeDefinition)parent.getCurrent();
                if (field != null && !typeDefinition.getFieldDefinitionExtension().contains(field)) {
                    field = null;
                }
                String typeName = typeDefinition.getTypeName();
                if (field != null) {
                    pair = Tuples.create((Object)typeName, (Object)field.getName());
                    result.add((Pair<String, String>)pair);
                    field = null;
                } else {
                    pair = Tuples.create((Object)typeName, null);
                    result.add((Pair<String, String>)pair);
                }
            } else if (parent.getCurrent() instanceof TypeSection.FieldDefinition) {
                field = (TypeSection.FieldDefinition)parent.getCurrent();
            } else if (!(parent.getCurrent() instanceof TypeSection) && parent.getCurrent() instanceof BslDocumentationComment.ReturnSection) {
                Collections.reverse(result);
                return result;
            }
            parent = parent.getParent();
        }
        return Collections.emptyList();
    }

    protected BmOperationContext getTypeComputationContext() {
        return this.typeComputationContext;
    }

    /*
     * WARNING - void declaration
     */
    private List<TypeItem> getFunctionReturnTypes() {
        EObject eObject;
        if (this.functionReturnTypes == null && (eObject = this.context) instanceof Function) {
            OnChangeEvictingCache.CacheAdapter cacheAdapter;
            void func;
            Function function = (Function)eObject;
            Function cfr_ignored_0 = (Function)eObject;
            Module localModule = (Module)EcoreUtil2.getContainerOfType((EObject)func, Module.class);
            if (localModule != null && (cacheAdapter = (OnChangeEvictingCache.CacheAdapter)EcoreUtil.getAdapter((List)localModule.eAdapters(), OnChangeEvictingCache.CacheAdapter.class)) != null) {
                cacheAdapter.ignoreNotifications();
            }
            this.functionReturnTypes = func.allStatements().stream().filter(ReturnStatement.class::isInstance).map(ReturnStatement.class::cast).flatMap(arg_0 -> this.lambda$9((Function)func, arg_0)).collect(Collectors.toList());
        } else if (this.functionReturnTypes == null) {
            this.functionReturnTypes = Collections.emptyList();
        }
        return this.functionReturnTypes;
    }

    private void collectTags(FeatureKey key, List<TagPart> tagParts, boolean computedValue) {
        for (TagPart tagPart : tagParts) {
            this.collectTagDescription(key, tagPart, computedValue);
            this.collectTagName(key, tagPart, computedValue);
            this.collectTagParams(key, tagPart, computedValue);
        }
    }

    private void collectTagDescription(FeatureKey key, TagPart tagPart, boolean computedValue) {
        if (!TranslationUtils.isValidValueForCollectModelType((boolean)computedValue, (boolean)false, (boolean)false, (ICollectingParameters.CollectModelType)this.parameters.getCollectModelType())) {
            return;
        }
        if (tagPart.getDescription().isBlank()) {
            return;
        }
        if (key.isEmpty()) {
            key = key.append(BslCommentFeatureSettings.Literals.DOC_COMMENT__DESCRIPTION.getName());
        }
        String description = tagPart.getDescription();
        FeatureKey commonFeatureKeyPreffix = this.featureKeyProvider.getKey(this.context).append(description);
        FeatureKey featureKey = commonFeatureKeyPreffix.append(key);
        PersistableFeatureValue featureValue = new PersistableFeatureValue(this.file, featureKey, BslCommentFeatureSettings.Literals.DOC_COMMENT__DESCRIPTION, description, computedValue, false, false);
        featureValue.getLocalStrings().put(this.getDefaultLanguageCode(), description);
        this.addAction.accept(tagPart, (FeatureValue)featureValue);
    }

    private void collectTagName(FeatureKey key, TagPart tagPart, boolean computedValue) {
        if (!TranslationUtils.isValidValueForCollectModelType((boolean)computedValue, (boolean)false, (boolean)true, (ICollectingParameters.CollectModelType)this.parameters.getCollectModelType())) {
            return;
        }
        if (tagPart.getTagName().isBlank()) {
            return;
        }
        if (key.isEmpty()) {
            key = key.append(BslCommentFeatureSettings.Literals.COMMENT__TAG_NAME.getName());
        }
        String name = tagPart.getTagName();
        FeatureKey commonFeatureKeyPreffix = this.featureKeyProvider.getKey(this.context).append(BslCommentFeatureSettings.Literals.COMMENT__TAG_NAME.getName()).append(name);
        FeatureKey featureKey = commonFeatureKeyPreffix.append(key);
        PersistableFeatureValue featureValue = new PersistableFeatureValue(this.file, featureKey, BslCommentFeatureSettings.Literals.COMMENT__TAG_NAME, name, computedValue, false, true);
        featureValue.getLocalStrings().put(this.getDefaultLanguageCode(), name);
        this.addAction.accept(tagPart, (FeatureValue)featureValue);
    }

    private void collectTagParams(FeatureKey key, TagPart tagPart, boolean computedValue) {
        if (!TranslationUtils.isValidValueForCollectModelType((boolean)computedValue, (boolean)false, (boolean)true, (ICollectingParameters.CollectModelType)this.parameters.getCollectModelType())) {
            return;
        }
        if (key.isEmpty()) {
            key = key.append(BslCommentFeatureSettings.Literals.COMMENT__TAG_NAME.getName());
        }
        List params = tagPart.getParameters();
        for (String param : params) {
            if (StringUtils.isBlank((String)param)) continue;
            FeatureKey commonFeatureKeyPreffix = this.featureKeyProvider.getKey(this.context).append(BslCommentFeatureSettings.Literals.COMMENT__TAG_PARAM.getName()).append(param);
            FeatureKey featureKey = commonFeatureKeyPreffix.append(key);
            PersistableFeatureValue featureValue = new PersistableFeatureValue(this.file, featureKey, BslCommentFeatureSettings.Literals.COMMENT__TAG_NAME, param, computedValue, false, true);
            featureValue.getLocalStrings().put(this.getDefaultLanguageCode(), param);
            this.addAction.accept(tagPart, (FeatureValue)featureValue);
        }
    }

    private boolean isMethodDescription() {
        return this.rootObject instanceof BslDocumentationComment && ((BslDocumentationComment)this.rootObject).getMethod() != null;
    }

    private String removeLeadingDash(BslDocumentationComment.Description object, IDescriptionPart part, String text) {
        boolean hasIncorrectTypes = false;
        boolean isTypesEmpty = false;
        if (object.getParent() instanceof BslDocumentationComment) {
            BslDocumentationComment docComment = (BslDocumentationComment)object.getParent();
            hasIncorrectTypes = this.bslDocCommentParser.isCommentHasIncorrectReturnTypes(docComment, this.context);
            boolean bl = isTypesEmpty = docComment.getReturnSection() == null || docComment.getReturnSection() != null && docComment.getReturnSection().getReturnTypes().isEmpty();
        }
        if (object.getParts().indexOf(part) == 0 && !text.stripLeading().startsWith("--") && text.stripLeading().startsWith("-") && !isTypesEmpty && !hasIncorrectTypes) {
            text = text.stripLeading().substring(1).stripLeading();
        }
        return text;
    }

    private String removeDeprecated(String text) {
        if (text.startsWith("Deprecated.") && this.isMethodDescription()) {
            text = text.replace("Deprecated.", "");
        }
        if (text.startsWith("\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.") && this.isMethodDescription()) {
            text = text.replace("\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.", "");
        }
        return text;
    }

    private String getDefaultLanguageCode() {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)this.context, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }

    /*
     * WARNING - void declaration
     */
    private void replaceTagParts(BslDocumentationComment.Description object) {
        HashMap<Integer, TextPart> newParts = new HashMap<Integer, TextPart>();
        int i = 0;
        while (i < object.getParts().size()) {
            IDescriptionPart part = (IDescriptionPart)object.getParts().get(i);
            IDescriptionPart iDescriptionPart = part;
            if (iDescriptionPart instanceof TagPart) {
                void tagPart;
                TagPart cfr_ignored_0 = (TagPart)iDescriptionPart;
                TagPart cfr_ignored_1 = (TagPart)iDescriptionPart;
                newParts.put(i, new TextPart(tagPart.getParent(), tagPart.getLineNumber(), tagPart.getOffset(), tagPart.getContent()));
            }
            ++i;
        }
        newParts.entrySet().stream().forEach(entry -> {
            IDescriptionPart iDescriptionPart = object.getParts().set((Integer)entry.getKey(), (IDescriptionPart)entry.getValue());
        });
    }

    private /* synthetic */ Stream lambda$9(Function function, ReturnStatement s) {
        return this.typesComputer.computeTypes((EObject)s.getExpression(), function.environments()).stream();
    }
}

