/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.internal.naming;

import com._1c.g5.v8.dt.bsl.model.BinaryExpression;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.IfStatement;
import com._1c.g5.v8.dt.bsl.model.ImplicitVariable;
import com._1c.g5.v8.dt.bsl.model.IndexAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.RaiseStatement;
import com._1c.g5.v8.dt.bsl.model.ReturnStatement;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.UnaryExpression;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.model.util.BslUtil;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.NstrTypeComputer;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.mcore.ContainingSourceDerivedProperty;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralRegistry;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefBslCacheProvider;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class BslNstrKeyComputer {
    @Inject
    private IV8ProjectManager projectManager;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    @Inject
    private ContextDefBslCacheProvider contextDefCacheProvider;
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    private IStringLiteralTypeComputer stringLiteralTypeComputer;
    @Inject
    private TypedStringLiteralRegistry typedStringLiteralRegistry;
    @Inject
    private DefaultStringLiteralContentProcessor defaultStringLiteralContentProcessor;
    @Inject
    private TypesComputer typesComputer;

    /*
     * WARNING - void declaration
     */
    public FeatureKey compute(StringLiteral literal, TranslatorProperties translationProperties, AtomicReference<IProjectTranslationProvider> translationProvider, Map<EObject, String> cache) {
        if (!translationProperties.isEnableExtendedNStrFeatureKeys()) {
            return null;
        }
        SimpleStatement simpleStatement = (SimpleStatement)EcoreUtil2.getContainerOfType((EObject)literal, SimpleStatement.class);
        if (simpleStatement != null) {
            Expression expression = simpleStatement.getLeft();
            if (expression instanceof Invocation) {
                void invocation;
                Invocation invocation2 = (Invocation)expression;
                Invocation cfr_ignored_0 = (Invocation)expression;
                return this.computeInvocationFqnInternal((Invocation)invocation, literal, translationProvider, cache);
            }
            return this.computeSimpleStatementFqnInternal(simpleStatement, literal, translationProvider, cache);
        }
        EObject returnStatement = EcoreUtil2.getContainerOfType((EObject)literal, ReturnStatement.class);
        if (returnStatement != null) {
            return this.computeNearestSemanticFqnInternal(literal, "Return", translationProvider, cache);
        }
        EObject raiseStatement = EcoreUtil2.getContainerOfType((EObject)literal, RaiseStatement.class);
        if (raiseStatement != null) {
            return this.computeNearestSemanticFqnInternal(literal, "Raise", translationProvider, cache);
        }
        IfStatement ifStatement = (IfStatement)EcoreUtil2.getContainerOfType((EObject)literal, IfStatement.class);
        if (ifStatement != null) {
            return this.computeIfStatementFqnInternal(ifStatement, literal, translationProvider, cache);
        }
        return null;
    }

    private String getLiteralValue(StringLiteral literal, Map<EObject, String> cache) {
        String literalKey = null;
        if (cache != null) {
            literalKey = cache.get(literal);
        } else {
            String languageCode = this.getLanguageCode(literal);
            Map<String, String> nlsStrings = BslUtils.getNlsLocalStrings(literal);
            if (Strings.isNullOrEmpty((String)languageCode) && nlsStrings.size() == 1) {
                for (Map.Entry<String, String> entry : nlsStrings.entrySet()) {
                    literalKey = entry.getValue();
                }
            } else if (!Strings.isNullOrEmpty((String)languageCode)) {
                literalKey = nlsStrings.get(languageCode);
            }
        }
        return this.replaceNonBreakingSpaces(literalKey);
    }

    /*
     * WARNING - void declaration
     */
    private FeatureKey computeIfStatementFqnInternal(IfStatement ifStatement, StringLiteral literal, AtomicReference<IProjectTranslationProvider> translationProvider, Map<EObject, String> cache) {
        FeatureKey featureKey = null;
        ArrayList<Pair<String, EObject>> eObjects = new ArrayList<Pair<String, EObject>>();
        Expression predicate = ifStatement.getIfPart().getPredicate();
        Expression expression = predicate;
        if (expression instanceof BinaryExpression) {
            void binaryExpression;
            BinaryExpression binaryExpression2 = (BinaryExpression)expression;
            BinaryExpression cfr_ignored_0 = (BinaryExpression)expression;
            this.fillExpressionEObjectsList((EObject)binaryExpression.getLeft(), eObjects, translationProvider);
        } else {
            Expression expression2 = predicate;
            if (expression2 instanceof Invocation) {
                void invocation;
                Invocation invocation2 = (Invocation)expression2;
                Invocation cfr_ignored_1 = (Invocation)expression2;
                return this.computeInvocationFqnInternal((Invocation)invocation, literal, translationProvider, cache);
            }
            Expression expression3 = predicate;
            if (expression3 instanceof UnaryExpression) {
                void unaryExpression;
                UnaryExpression unaryExpression2 = (UnaryExpression)expression3;
                UnaryExpression cfr_ignored_2 = (UnaryExpression)expression3;
                this.fillExpressionEObjectsList((EObject)unaryExpression.getOperand(), eObjects, translationProvider);
            }
        }
        if (eObjects.isEmpty()) {
            return null;
        }
        FeatureKey parentFqn = this.computeParentFqnInternal(literal, translationProvider);
        if (parentFqn != null) {
            int i = eObjects.size() - 1;
            while (i >= 0) {
                Pair pair = (Pair)eObjects.get(i);
                featureKey = featureKey == null ? FeaturesCollectorUtil.toFeatureKey((String)((String)pair.getKey())) : featureKey.append((String)pair.getKey());
                --i;
            }
            featureKey = parentFqn.append(featureKey);
        }
        if (featureKey == null) {
            return featureKey;
        }
        return this.appendLiteralValue(literal, featureKey, cache);
    }

    private FeatureKey computeNearestSemanticFqnInternal(StringLiteral literal, String postfix, AtomicReference<IProjectTranslationProvider> translationProvider, Map<EObject, String> cache) {
        FeatureKey featureKey = null;
        FeatureKey parentFqn = this.computeParentFqnInternal(literal, translationProvider);
        if (parentFqn != null && !postfix.isEmpty()) {
            featureKey = parentFqn.append(postfix);
        }
        if (featureKey == null) {
            return featureKey;
        }
        return this.appendLiteralValue(literal, featureKey, cache);
    }

    private FeatureKey computeInvocationFqnInternal(Invocation invocation, StringLiteral literal, AtomicReference<IProjectTranslationProvider> translationProvider, Map<EObject, String> cache) {
        FeatureKey featureKey = null;
        FeatureKey parentFqn = this.computeParentFqnInternal(literal, translationProvider);
        if (parentFqn != null) {
            String functionName = invocation.getMethodAccess().getName();
            functionName = this.translateInvocation((EObject)literal, translationProvider, invocation, functionName);
            featureKey = NstrTypeComputer.isNls((Invocation)invocation) ? parentFqn.append("Func") : parentFqn.append("Func").append(functionName);
        }
        if (featureKey == null) {
            return featureKey;
        }
        return this.appendLiteralValue(literal, featureKey, cache);
    }

    private FeatureKey computeSimpleStatementFqnInternal(SimpleStatement statement, StringLiteral literal, AtomicReference<IProjectTranslationProvider> translationProvider, Map<EObject, String> cache) {
        FeatureKey featureKey = null;
        ArrayList<Pair<String, EObject>> eObjects = new ArrayList<Pair<String, EObject>>();
        this.fillExpressionEObjectsList((EObject)statement.getLeft(), eObjects, translationProvider);
        if (eObjects.isEmpty()) {
            return null;
        }
        FeatureKey parentFqn = this.computeParentFqnInternal(literal, translationProvider);
        if (parentFqn != null) {
            int i = eObjects.size() - 1;
            while (i >= 0) {
                Pair pair = (Pair)eObjects.get(i);
                featureKey = featureKey == null ? FeaturesCollectorUtil.toFeatureKey((String)((String)pair.getKey())) : featureKey.append((String)pair.getKey());
                --i;
            }
            featureKey = parentFqn.append(featureKey);
        }
        if (featureKey == null) {
            return featureKey;
        }
        return this.appendLiteralValue(literal, featureKey, cache);
    }

    /*
     * WARNING - void declaration
     */
    private void fillExpressionEObjectsList(EObject expression, List<Pair<String, EObject>> fqn, AtomicReference<IProjectTranslationProvider> translationProvider) {
        EObject eObject = expression;
        if (eObject instanceof DynamicFeatureAccess) {
            void dfa;
            DynamicFeatureAccess dynamicFeatureAccess = (DynamicFeatureAccess)eObject;
            DynamicFeatureAccess cfr_ignored_0 = (DynamicFeatureAccess)eObject;
            String name = dfa.getName();
            name = this.translateDymanicFeatureAccess(expression, translationProvider, (DynamicFeatureAccess)dfa, name);
            fqn.add((Pair<String, EObject>)new Pair((Object)name, (Object)dfa));
            this.fillExpressionEObjectsList((EObject)dfa.getSource(), fqn, translationProvider);
        } else {
            EObject eObject2 = expression;
            if (eObject2 instanceof StaticFeatureAccess) {
                void sfa;
                StaticFeatureAccess name = (StaticFeatureAccess)eObject2;
                StaticFeatureAccess cfr_ignored_1 = (StaticFeatureAccess)eObject2;
                String variableName = sfa.getName();
                boolean paramFound = false;
                Method method = (Method)EcoreUtil2.getContainerOfType((EObject)expression, Method.class);
                if (method != null) {
                    paramFound = method.getFormalParams().stream().anyMatch(arg_0 -> BslNstrKeyComputer.lambda$0((StaticFeatureAccess)sfa, arg_0));
                }
                variableName = this.translateStaticFeatureAccess(translationProvider, (StaticFeatureAccess)sfa, method, variableName);
                fqn.add((Pair<String, EObject>)new Pair((Object)variableName, (Object)sfa));
                fqn.add((Pair<String, EObject>)new Pair((Object)(paramFound ? "Param" : "Var"), (Object)sfa));
            } else {
                EObject eObject3 = expression;
                if (eObject3 instanceof IndexAccess) {
                    void indexAccess;
                    Expression indexExpression;
                    IndexAccess variableName = (IndexAccess)eObject3;
                    IndexAccess cfr_ignored_2 = (IndexAccess)eObject3;
                    Expression expression2 = indexExpression = indexAccess.getIndex();
                    if (expression2 instanceof StringLiteral) {
                        void literal;
                        StringLiteral stringLiteral = (StringLiteral)expression2;
                        StringLiteral cfr_ignored_3 = (StringLiteral)expression2;
                        String literalValue = this.translateLiteralValue(expression, translationProvider, (StringLiteral)literal, BslUtils.getString((StringLiteral)literal));
                        fqn.add((Pair<String, EObject>)new Pair((Object)literalValue, (Object)literal));
                    }
                    this.fillExpressionEObjectsList((EObject)indexAccess.getSource(), fqn, translationProvider);
                } else {
                    EObject eObject4 = expression;
                    if (eObject4 instanceof BinaryExpression) {
                        void binaryExpression;
                        BinaryExpression indexExpression = (BinaryExpression)eObject4;
                        BinaryExpression cfr_ignored_4 = (BinaryExpression)eObject4;
                        this.fillExpressionEObjectsList((EObject)binaryExpression.getLeft(), fqn, translationProvider);
                    } else {
                        EObject eObject5 = expression;
                        if (eObject5 instanceof Invocation) {
                            void invocation;
                            Invocation invocation2 = (Invocation)eObject5;
                            Invocation cfr_ignored_5 = (Invocation)eObject5;
                            String invocationName = invocation.getMethodAccess().getName();
                            invocationName = this.translateInvocation(expression, translationProvider, (Invocation)invocation, invocationName);
                            fqn.add((Pair<String, EObject>)new Pair((Object)invocationName, (Object)invocation));
                            fqn.add((Pair<String, EObject>)new Pair((Object)"Func", (Object)invocation));
                        }
                    }
                }
            }
        }
    }

    private String translateLiteralValue(EObject expression, AtomicReference<IProjectTranslationProvider> translationProvider, StringLiteral literal, String literalValue) {
        if (this.isTranslationProviderAvailable(translationProvider)) {
            Collection types = this.stringLiteralTypeComputer.computeTypes(literal);
            List<TypedStringLiteralContentProcessor> literalProcessors = this.typedStringLiteralRegistry.getContentProcessors(literal, types);
            TypedStringLiteralContentProcessor processor = literalProcessors.isEmpty() ? this.defaultStringLiteralContentProcessor : literalProcessors.get(0);
            TranslateLanguage defaultLanguage = translationProvider.get().getProject().getDefaultLanguage();
            List<String> translated = processor.process(literal, types, translationProvider.get(), defaultLanguage, (CancelIndicator)new MonitorBasedCancelIndicator((IProgressMonitor)new NullProgressMonitor()));
            String translatedLiteralValue = translated.stream().collect(Collectors.joining(literalValue));
            if (!StringUtils.isNullOrEmpty((String)translatedLiteralValue) && !literalValue.equals(translatedLiteralValue)) {
                literalValue = translatedLiteralValue;
            }
        }
        return literalValue;
    }

    private String translateInvocation(EObject expression, AtomicReference<IProjectTranslationProvider> translationProvider, Invocation invocation, String invocationName) {
        if (this.isTranslationProviderAvailable(translationProvider)) {
            Method method = (Method)EcoreUtil2.getContainerOfType((EObject)expression, Method.class);
            String translatedInvocationName = this.getReplaceText((EObject)invocation.getMethodAccess(), method, translationProvider);
            if (!StringUtils.isNullOrEmpty((String)translatedInvocationName) && !invocationName.equals(translatedInvocationName)) {
                invocationName = translatedInvocationName;
            }
        }
        return invocationName;
    }

    private String translateStaticFeatureAccess(AtomicReference<IProjectTranslationProvider> translationProvider, StaticFeatureAccess sfa, Method method, String variableName) {
        if (this.isTranslationProviderAvailable(translationProvider)) {
            ImplicitVariable variable = sfa.getImplicitVariable();
            Pair translatedName = null;
            translatedName = this.namedEObjectNameProvider.getTranslatedName((EObject)variable, translationProvider.get());
            variableName = variable == null ? this.getReplaceText((EObject)sfa, method, translationProvider) : variable.getName();
            if (translatedName != null) {
                variableName = (String)translatedName.getValue();
            }
        }
        return variableName;
    }

    private String translateDymanicFeatureAccess(EObject expression, AtomicReference<IProjectTranslationProvider> translationProvider, DynamicFeatureAccess dfa, String name) {
        if (this.isTranslationProviderAvailable(translationProvider)) {
            Method method = (Method)EcoreUtil2.getContainerOfType((EObject)expression, Method.class);
            String translatedPartName = this.getReplaceText((EObject)dfa, method, translationProvider);
            if (StringUtils.isNullOrEmpty((String)translatedPartName) || name.equals(translatedPartName) && !this.isXDTOProperty((FeatureAccess)dfa)) {
                translatedPartName = this.getSuggestionReplaceText(dfa, (Environmental)method, translationProvider);
            }
            if (!StringUtils.isNullOrEmpty((String)translatedPartName) && !name.equals(translatedPartName)) {
                name = translatedPartName;
            }
        }
        return name;
    }

    private boolean isTranslationProviderAvailable(AtomicReference<IProjectTranslationProvider> translationProvider) {
        return translationProvider != null && translationProvider.get() != null;
    }

    private FeatureKey appendLiteralValue(StringLiteral literal, FeatureKey featureKey, Map<EObject, String> cache) {
        String literalValue = this.getLiteralValue(literal, cache);
        if (!Strings.isNullOrEmpty((String)literalValue)) {
            featureKey = featureKey.append("NStr").append(literalValue);
        }
        return featureKey;
    }

    private FeatureKey computeFqnInternal(Method method, AtomicReference<IProjectTranslationProvider> translationProvider) {
        FeatureKey expression = null;
        Pair translatedName = null;
        if (this.isTranslationProviderAvailable(translationProvider)) {
            translatedName = this.namedEObjectNameProvider.getTranslatedName((EObject)method, translationProvider.get());
        }
        String name = method.getName();
        if (translatedName != null) {
            name = (String)translatedName.getValue();
        }
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        expression = FeaturesCollectorUtil.toFeatureKey((String)"Method").append(FeaturesCollectorUtil.toFeatureKey((String)name));
        return expression;
    }

    private String getLanguageCode(StringLiteral literal) {
        return FeaturesCollectorUtil.getDefaultLanguageCode((EObject)literal, (IV8ProjectManager)this.projectManager);
    }

    private String replaceNonBreakingSpaces(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return input;
        }
        if (!input.contains("\u00a0")) {
            return input;
        }
        return input.replace("\u00a0", " ");
    }

    private FeatureKey computeParentFqnInternal(StringLiteral literal, AtomicReference<IProjectTranslationProvider> translationProvider) {
        Method parent = (Method)EcoreUtil2.getContainerOfType((EObject)literal, Method.class);
        FeatureKey fqn = null;
        if (parent != null) {
            fqn = this.computeFqnInternal(parent, translationProvider);
        }
        return fqn;
    }

    /*
     * WARNING - void declaration
     */
    private String getReplaceText(EObject expr, Method method, AtomicReference<IProjectTranslationProvider> translationProvider) {
        ContextTranslationKey value;
        String translation;
        Pair translated;
        FeatureAccess featureAccess = (FeatureAccess)expr;
        if (!this.isTranslationProviderAvailable(translationProvider)) {
            return featureAccess.getName();
        }
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)featureAccess, Environmental.class);
        String replace = null;
        if (StringUtils.isNotEmpty((String)(replace = this.getXDTOPropertyName(featureAccess, replace)))) {
            return replace;
        }
        List features = this.dynamicFeatureAccessComputer.resolveObject(featureAccess, environmental.environments());
        for (FeatureEntry feature : features) {
            EObject groupObject = (EObject)feature.eGet((EStructuralFeature)BslPackage.Literals.FEATURE_ENTRY__FEATURE, false);
            EObject eObject = groupObject;
            if (eObject instanceof DerivedProperty) {
                void property;
                DerivedProperty cfr_ignored_0 = (DerivedProperty)eObject;
                DerivedProperty cfr_ignored_1 = (DerivedProperty)eObject;
                translated = this.getReplaceText((DerivedProperty)property, groupObject, featureAccess, translationProvider.get());
                if (translated != null) {
                    return (String)translated.getValue();
                }
                Form form = (Form)EcoreUtil2.getContainerOfType((EObject)groupObject, Form.class);
                if (form == null || (translated = this.namedEObjectNameProvider.getTranslatedName(groupObject, translationProvider.get())) == null) continue;
                return (String)translated.getValue();
            }
            translated = this.namedEObjectNameProvider.getTranslatedName(groupObject, translationProvider.get());
            if (translated == null) continue;
            return (String)translated.getValue();
        }
        if (method != null) {
            for (Variable variable : method.getImplicitVariables()) {
                if (!variable.getName().equals(featureAccess.getName()) || (translated = this.namedEObjectNameProvider.getTranslatedName((EObject)variable, translationProvider.get())) == null) continue;
                return (String)translated.getValue();
            }
        }
        ITranslatingProject project = translationProvider.get().getProject().getSourceProject();
        IProjectTranslationReader reader = this.getReader(project.getProject());
        Optional<TranslateLanguage> lang = project.getModelLanguages().stream().filter(l -> "en".equals(l.getLanguageCode())).findFirst();
        if (lang.isPresent() && StringUtils.isNotEmpty((String)(translation = reader.getStoredTranslation((TranslationKey)(value = this.createContextTranslationKey((FeatureAccess)expr)), lang.get(), new ITranslationStorageProvider.Storage.Type[0])))) {
            return translation;
        }
        return featureAccess.getName();
    }

    private Pair<String, String> getReplaceText(DerivedProperty property, EObject groupObject, FeatureAccess featureAccess, IProjectTranslationProvider translationProvider) {
        Pair translation;
        EObject source = null;
        source = groupObject instanceof ContainingSourceDerivedProperty ? (EObject)groupObject.eGet((EStructuralFeature)McorePackage.Literals.CONTAINING_SOURCE_DERIVED_PROPERTY__CONTAINING_SOURCE, false) : (EObject)groupObject.eGet((EStructuralFeature)McorePackage.Literals.DERIVED_PROPERTY__SOURCE, false);
        source = property.getSource();
        if (source != null && (translation = this.namedEObjectNameProvider.getTranslatedName(source, translationProvider)) != null && featureAccess.getName().equalsIgnoreCase((String)translation.getKey())) {
            return translation;
        }
        return null;
    }

    private IProjectTranslationReader getReader(IProject project) {
        return this.storageManager.getTranslationReader(project);
    }

    private ContextTranslationKey createContextTranslationKey(FeatureAccess featureAccess) {
        IFile file = this.resourceLookup.getPlatformResource((EObject)featureAccess);
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)featureAccess, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME);
        return new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME, featureAccess.getName());
    }

    private String getSuggestionReplaceText(DynamicFeatureAccess object, Environmental environmental, AtomicReference<IProjectTranslationProvider> translationProvider) {
        String replace = null;
        boolean isChangeScriptVariant = translationProvider.get().getProject().isChangeScriptVariant();
        if (!isChangeScriptVariant) {
            return replace;
        }
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        ContextDefCache contextDef = this.getContextDefCache(translationProvider.get(), module);
        replace = contextDef.getMethodOrPropertyName((FeatureAccess)object, environmental.environments());
        if (StringUtils.isNullOrEmpty((String)replace) && !(object.eContainer() instanceof FeatureAccess)) {
            boolean isRussian = translationProvider.get().getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            replace = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(object.getName(), isRussian);
        }
        return replace;
    }

    private ContextDefCache getContextDefCache(IProjectTranslationProvider translationProvider, Module module) {
        boolean isRussian = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        return this.contextDefCacheProvider.getContextDefCache((EObject)module, isRussian);
    }

    private boolean isXDTOProperty(FeatureAccess featureAccess) {
        boolean isMethod = BslUtil.getInvocation((FeatureAccess)featureAccess) != null;
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)featureAccess, Environmental.class);
        if (!isMethod && featureAccess instanceof DynamicFeatureAccess) {
            FeatureAccess parent = featureAccess;
            List types = new ArrayList();
            while (parent != null && types.isEmpty()) {
                if (parent instanceof DynamicFeatureAccess) {
                    parent = ((DynamicFeatureAccess)parent).getSource();
                } else if (parent instanceof IndexAccess) {
                    parent = ((IndexAccess)parent).getSource();
                } else if (parent instanceof Invocation) {
                    parent = ((Invocation)parent).getMethodAccess();
                } else {
                    types = new ArrayList();
                    parent = null;
                    break;
                }
                types = this.typesComputer.computeTypes((EObject)parent, environmental.environments());
            }
            return !types.isEmpty() && types.stream().anyMatch(t -> t != null && StringUtils.isNotEmpty((String)McoreUtil.getTypeName((TypeItem)t)) && "XDTODataObject".equals(McoreUtil.getTypeName((TypeItem)t)));
        }
        return false;
    }

    private String getXDTOPropertyName(FeatureAccess featureAccess, String replace) {
        if (this.isXDTOProperty(featureAccess)) {
            return featureAccess.getName();
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$0(StaticFeatureAccess staticFeatureAccess, FormalParam param) {
        return param.getName().equalsIgnoreCase(staticFeatureAccess.getName());
    }
}

