/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.naming;

import com._1c.g5.v8.dt.bsl.model.BslContextDef;
import com._1c.g5.v8.dt.bsl.model.BslContextDefPackage;
import com._1c.g5.v8.dt.mcore.Method;
import com._1c.g5.v8.dt.mcore.Parameter;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.emf.naming.FeatureKeyMigrationnExtension;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.naming.AbstractFeatureKeyComputer;
import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

public class BslContextDefKeyComputer
extends AbstractFeatureKeyComputer
implements FeatureKeyMigrationnExtension {
    private static final String BSL_FILE_EXT = "bslcd";

    public boolean isSupported(EObject object) {
        Resource res = object.eResource();
        if (res != null && !res.getContents().isEmpty()) {
            EObject top = (EObject)res.getContents().get(0);
            EPackage objectPackage = top.eClass().getEPackage();
            return objectPackage.equals(BslContextDefPackage.eINSTANCE);
        }
        return false;
    }

    public FeatureKey computeFqn(EObject obj) {
        if (obj instanceof BslContextDef) {
            return SegmentFeatureKey.EMPTY;
        }
        if (obj instanceof Method) {
            return this._computeFqn((Method)obj);
        }
        if (obj instanceof Parameter) {
            return this._computeFqn((Parameter)obj);
        }
        BslPlugin.log(BslPlugin.createWarningStatus(MessageFormat.format("Bsl: Unhandled Feature Key parameter type: {0}", obj)));
        return this.computeListOrParent(obj);
    }

    protected FeatureKey _computeFqn(Method method) {
        FeatureKey _expression = null;
        String name = method.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        _expression = this.toFeatureKey("Method").append(this.toFeatureKey(name));
        return _expression;
    }

    protected FeatureKey _computeFqn(Parameter param) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        String name = param.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        EObject parent = EcoreUtil2.getContainerOfType((EObject)param.eContainer(), Method.class);
        if (parent == null) {
            parent = EcoreUtil2.getContainerOfType((EObject)param, BslContextDef.class);
        }
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            _expression = this.toFeatureKey("Param").append(this.toFeatureKey(name));
            return fqn.append(_expression);
        }
        return null;
    }

    public boolean isSupport(ContextTranslationKey contexTranslationKey) {
        return contexTranslationKey.getResourceId() != null && BSL_FILE_EXT.equalsIgnoreCase(contexTranslationKey.getResourceId().getFileExtension());
    }

    public Collection<FeatureKey> getOldFeatureKeys(FeatureKey key) {
        ArrayList<String> segments = new ArrayList<String>();
        boolean modified = false;
        int i = 0;
        while (i < key.getSegmentCount()) {
            String segment = key.getSegment(i);
            if (i + 2 < key.getSegmentCount() && ("Method".equalsIgnoreCase(segment) || "Param".equalsIgnoreCase(segment))) {
                modified = true;
            } else {
                segments.add(segment);
            }
            ++i;
        }
        if (modified) {
            return Arrays.asList(SegmentFeatureKey.create(segments));
        }
        return Collections.emptyList();
    }
}

