/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.naming;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.ImplicitVariable;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.Environmental;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.IFeatureKeyConverterExtension;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslateProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.internal.naming.BslNstrKeyComputer;
import com.e1c.langtool.v8.dt.bsl.naming.BslKeyComputer;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProvider;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;

public class BslProjectConverterKeyComputer
extends BslKeyComputer
implements IFeatureKeyConverterExtension {
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private BslNstrKeyComputer nstrKeyComputer;
    private final AtomicReference<IProjectTranslationProvider> translationProvider = new AtomicReference();
    private final Map<EObject, String> cache = Collections.synchronizedMap(new WeakHashMap());

    public BslProjectConverterKeyComputer() {
        this.translationProvider.set(null);
    }

    public FeatureKey getConvertedFeatureKey(EObject obj, String translation, ITranslateProject project) {
        IProjectTranslationProvider localProvider = this.translationProvider.get();
        if (localProvider == null) {
            localProvider = ProjectTranslationProvider.create((ITranslatedV8Project)((ITranslatedV8Project)project));
            this.translationProvider.compareAndSet(null, localProvider);
        }
        this.cache.put(obj, translation);
        return this.getFeatureKey(obj);
    }

    public FeatureKey getFeatureKey(EObject obj) {
        return this.computeFqn(obj);
    }

    @Override
    protected FeatureKey _computeFqn(StringLiteral literal) {
        FeatureKey _expression = null;
        if (BslUtils.isNStr(literal, this.typeComputer) && (_expression = this.nstrKeyComputer.compute(literal, this.getTranslationProperties(literal), this.translationProvider, this.cache)) != null) {
            return _expression;
        }
        SimpleStatement statement = (SimpleStatement)EcoreUtil2.getContainerOfType((EObject)literal, SimpleStatement.class);
        if (statement != null) {
            Expression expr = statement.getLeft();
            if (expr instanceof DynamicFeatureAccess) {
                expr = ((DynamicFeatureAccess)expr).getSource();
            }
            if (expr instanceof Variable) {
                _expression = this.computeFqn((EObject)expr);
            } else if (expr instanceof StaticFeatureAccess) {
                ImplicitVariable var = ((StaticFeatureAccess)expr).getImplicitVariable();
                if (var != null) {
                    _expression = this.computeFqn((EObject)var);
                } else {
                    String variableName;
                    _expression = SegmentFeatureKey.EMPTY;
                    Method method = (Method)EcoreUtil2.getContainerOfType((EObject)literal, Method.class);
                    if (method != null) {
                        _expression = this.computeFqn((EObject)method);
                    }
                    if ((variableName = this.getReplaceText((EObject)expr, method)) != null) {
                        boolean paramFound = false;
                        if (method != null) {
                            paramFound = method.getFormalParams().stream().anyMatch(p -> {
                                Pair translatedName;
                                Pair pair = translatedName = this.translationProvider.get() != null ? this.namedEObjectNameProvider.getTranslatedName((EObject)p, this.translationProvider.get()) : null;
                                return translatedName != null && variableName.equalsIgnoreCase((String)translatedName.getValue()) || variableName.equalsIgnoreCase(p.getName());
                            });
                        }
                        _expression = _expression.append(paramFound ? "Param" : "Var").append(variableName);
                    }
                }
            }
        }
        if (_expression == null) {
            EObject parent = EcoreUtil2.getContainerOfType((EObject)literal, Method.class);
            if (parent == null) {
                parent = EcoreUtil2.getContainerOfType((EObject)literal, Module.class);
            }
            if (parent != null) {
                _expression = this.computeFqn(parent);
            }
        }
        if (_expression == null) {
            _expression = SegmentFeatureKey.EMPTY;
        }
        if (this.typeComputer.containsAnyType(literal, new String[]{"NStr"})) {
            literalKey = this.replaceNonBreakingSpaces(this.cache.get(literal));
            if (!Strings.isNullOrEmpty((String)literalKey)) {
                _expression = _expression.append("NStr").append(literalKey);
            }
        } else if (!this.typeComputer.containsAnyType(literal, LangToolDefaults.QUERY)) {
            literalKey = BslUtils.getString(literal);
            _expression = _expression.append("String").append(literalKey);
        }
        return _expression;
    }

    @Override
    protected FeatureKey _computeFqn(Method method) {
        FeatureKey _expression = null;
        Pair translatedName = null;
        if (this.translationProvider.get() != null) {
            translatedName = this.namedEObjectNameProvider.getTranslatedName((EObject)method, this.translationProvider.get());
        }
        String name = method.getName();
        if (translatedName != null) {
            name = (String)translatedName.getValue();
        }
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        _expression = this.toFeatureKey("Method").append(this.toFeatureKey(name));
        return _expression;
    }

    @Override
    protected FeatureKey _computeFqn(Variable var) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        Pair translatedName = null;
        if (this.translationProvider.get() != null) {
            translatedName = this.namedEObjectNameProvider.getTranslatedName((EObject)var, this.translationProvider.get());
        }
        String name = var.getName();
        if (translatedName != null) {
            name = (String)translatedName.getValue();
        }
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        EObject parent = EcoreUtil2.getContainerOfType((EObject)var, Method.class);
        if (parent == null) {
            parent = EcoreUtil2.getContainerOfType((EObject)var, Module.class);
        }
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            _expression = this.toFeatureKey("Var").append(this.toFeatureKey(name));
            return fqn.append(_expression);
        }
        return null;
    }

    private String getReplaceText(EObject expr, Method method) {
        ContextTranslationKey value;
        String translation;
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)((FeatureAccess)expr), Environmental.class);
        List features = this.dynamicFeatureAccessComputer.resolveObject((FeatureAccess)expr, environmental.environments());
        for (FeatureEntry feature : features) {
            EObject groupObject = (EObject)feature.eGet((EStructuralFeature)BslPackage.Literals.FEATURE_ENTRY__FEATURE, false);
            try {
                Pair translated;
                if (this.translationProvider.get() == null || (translated = this.namedEObjectNameProvider.getTranslatedName(groupObject, this.translationProvider.get())) == null) continue;
                return (String)translated.getValue();
            }
            catch (Exception e) {
                BslPlugin.log(BslPlugin.createWarningStatus(MessageFormat.format("Converter: Unprocessed translated name for: {0}", groupObject)));
            }
        }
        if (method != null) {
            for (Variable variable : method.getImplicitVariables()) {
                Pair translated;
                if (!variable.getName().equals(((StaticFeatureAccess)expr).getName()) || (translated = this.namedEObjectNameProvider.getTranslatedName((EObject)variable, this.translationProvider.get())) == null) continue;
                return (String)translated.getValue();
            }
        }
        ITranslatingProject project = this.translationProvider.get().getProject().getSourceProject();
        IProjectTranslationReader reader = this.getReader(project.getProject());
        Optional<TranslateLanguage> lang = project.getModelLanguages().stream().filter(l -> "en".equals(l.getLanguageCode())).findFirst();
        if (lang.isPresent() && StringUtils.isNotEmpty((String)(translation = reader.getStoredTranslation((TranslationKey)(value = this.createContextTranslationKey((StaticFeatureAccess)expr)), lang.get(), new ITranslationStorageProvider.Storage.Type[0])))) {
            return translation;
        }
        return ((StaticFeatureAccess)expr).getName();
    }

    private ContextTranslationKey createContextTranslationKey(StaticFeatureAccess featureAccess) {
        IFile file = this.resourceLookup.getPlatformResource((EObject)featureAccess);
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)featureAccess, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME);
        return new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME, featureAccess.getName());
    }

    private IProjectTranslationReader getReader(IProject project) {
        return this.storageManager.getTranslationReader(project);
    }
}

