/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.settings.impl;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.settings.impl.Messages;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StringLiteralLinesValidator
implements FeatureValueValidator {
    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        FeatureSettings settings = context.getTranslationKey().getFeatureSettings();
        if (settings.equals(BslFeatureSettings.Literals.STRING_LITERAL__LINES) && StringUtils.isNotEmpty((String)value)) {
            long valueCount = value.lines().count();
            long sourceCount = context.getTranslationKey().getValue().lines().count();
            if (sourceCount != valueCount) {
                String message = MessageFormat.format(Messages.StringLiteralLinesValidator_String_literal_has__N__lines_instead_of__M__in_source, sourceCount, valueCount);
                BslPlugin.createErrorStatus(message, null);
            }
        }
        return Status.OK_STATUS;
    }
}

