/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.settings.impl;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.settings.impl.Messages;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StringLiteralParamValidator
implements FeatureValueValidator {
    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        if (StringUtils.isNotEmpty((String)value)) {
            String source = context.getTranslationKey().getValue();
            HashSet<String> params = new HashSet<String>();
            params.addAll(Utils.getParamsMapFromNls((String)source).values());
            params.addAll(Utils.getStrTemplateParams((String)source).values());
            if (!params.isEmpty()) {
                HashSet valueParams = new HashSet();
                valueParams.addAll(Utils.getParamsMapFromNls((String)value).values());
                valueParams.addAll(Utils.getStrTemplateParams((String)value).values());
                params.removeAll(valueParams);
                if (!params.isEmpty()) {
                    String message = this.createErrorMessage(params);
                    return BslPlugin.createErrorStatus(message, null);
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected String createErrorMessage(Set<String> missing) {
        ArrayList<String> sorted = new ArrayList<String>(missing);
        Collections.sort(sorted);
        return MessageFormat.format(Messages.StringLiteralParamValidator_NStr_has_no_replace_params___P, String.join((CharSequence)", ", sorted));
    }
}

