/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.CancelIndicator;

public abstract class AbstractStringLiteralLinesProcessor
implements TypedStringLiteralContentProcessor {
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private BslPreferences bslPreferences;

    protected List<String> getLineTranslation(StringLiteral literal, List<String> content, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        String sourceString;
        ContextTranslationKey key;
        String translation;
        if (content == null) {
            content = literal.lines(false);
        }
        if ((this.isChangeDefaultLanguage(translationProvider) || this.isChangeScriptVariant(translationProvider)) && StringUtils.isNotEmpty((String)(translation = translationProvider.getTranslation((EObject)literal, key = this.createLinesTranslationKey(literal, sourceString = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)content)), language)))) {
            return this.formatTranslation(literal, sourceString, translation);
        }
        return Collections.emptyList();
    }

    protected ContextTranslationKey createLinesTranslationKey(StringLiteral literal, String sourceString) {
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES);
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        return new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES, sourceString.trim());
    }

    private List<String> formatTranslation(StringLiteral literal, String sourceString, String translation) {
        String sourceTrimed = sourceString.trim();
        if (translation.split("\n", -1).length < literal.getLines().size() && sourceTrimed.split("\n", -1).length < literal.getLines().size() || sourceString.length() != sourceTrimed.length() && translation.trim().length() == translation.length()) {
            translation = sourceString.replace(sourceTrimed, translation);
        }
        Object[] lines = translation.replace("\r", "").split("\n", -1);
        return Lists.newArrayList((Object[])lines);
    }

    protected List<String> getContextLineTranslation(StringLiteral literal, List<String> content, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        String sourceString;
        ContextTranslationKey key;
        String translation;
        if (content == null) {
            content = literal.lines(false);
        }
        if ((this.isChangeDefaultLanguage(translationProvider) || this.isChangeScriptVariant(translationProvider)) && StringUtils.isNotEmpty((String)(translation = translationProvider.getStoredTranslation(key = this.createLinesTranslationKey(literal, sourceString = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)content)), language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT})))) {
            return this.formatTranslation(literal, sourceString, translation);
        }
        return Collections.emptyList();
    }

    protected boolean isChangeDefaultLanguage(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeDefaultLanguage();
    }

    protected boolean isChangeScriptVariant(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeScriptVariant();
    }

    protected String fixKeyTranslationCase(String key, String translation) {
        boolean mayUpdate;
        boolean bl = mayUpdate = key.length() > 1 || translation.length() == 1;
        if (mayUpdate && StringUtils.isUpperCase((String)key)) {
            return translation.toUpperCase();
        }
        if (mayUpdate && StringUtils.isLowerCase((String)key)) {
            return translation.toLowerCase();
        }
        return translation;
    }

    protected boolean isStringLiteralLinesFullTranslationStoredPriority(StringLiteral literal) {
        IProject project = this.resourceLookup.getProject((EObject)literal);
        if (project == null) {
            return false;
        }
        TranslatorProperties props = this.bslPreferences.getTranslatorProperties(project);
        return props.isStringLiteralLinesFullTranslationStoredPriority();
    }
}

