/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.rights.model.util.RightName;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.util.CancelIndicator;

public class AccessRightContentProcessor
implements TypedStringLiteralContentProcessor {
    @Inject
    private IStringLiteralTypeComputer typeComputer;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Access-right"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        EList lines = literal.lines(false);
        if (lines.isEmpty()) {
            return lines;
        }
        String literalString = (String)lines.get(0);
        boolean isRussian = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        return Arrays.asList(this.getRightName(literalString, isRussian));
    }

    protected String getRightName(String literalString, boolean isRussian) {
        RightName[] arrrightName = RightName.values();
        int i = 0;
        while (i < arrrightName.length) {
            RightName right = arrrightName[i];
            if (literalString.equalsIgnoreCase(right.getNameRu()) || literalString.equalsIgnoreCase(right.getName())) {
                return isRussian ? right.getNameRu() : right.getName();
            }
            ++i;
        }
        return literalString;
    }
}

