/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractStringLiteralLinesProcessor;
import com.e1c.langtool.v8.dt.dcs.DcsParameterValueProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;

public class DcsParameterContentProcessor
extends AbstractStringLiteralLinesProcessor {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    @Inject
    private DcsParameterValueProvider dcsParameterValueProvider;
    @Inject
    private TypesComputer typesComputer;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Dcs-parameter"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        List<String> newLines;
        EList lines = literal.lines(false);
        if (lines.size() == 1 && this.isChangeScriptVariant(translationProvider)) {
            String newParameter;
            boolean isRussian = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            Version vesion = this.runtimeVersionSupport.getRuntimeVersion((EObject)literal);
            String parameter = (String)lines.get(0);
            EObject parent = literal.eContainer();
            if (parent instanceof Invocation && (parent = ((Invocation)parent).getMethodAccess()) instanceof DynamicFeatureAccess) {
                Environmental envs = (Environmental)EcoreUtil2.getContainerOfType((EObject)parent, Environmental.class);
                List sourceTypes = this.typesComputer.computeTypes((EObject)((DynamicFeatureAccess)parent).getSource(), envs.environments());
                List sourceTypeNames = sourceTypes.stream().map(McoreUtil::getTypeName).filter(Objects::nonNull).collect(Collectors.toList());
                for (String typeName : sourceTypeNames) {
                    String newParameter2 = this.dcsParameterValueProvider.getParameterName(parameter, typeName, vesion, isRussian);
                    if (newParameter2 == null) continue;
                    return Arrays.asList(newParameter2);
                }
            }
            if ((newParameter = this.dcsParameterValueProvider.getParameterName(parameter, vesion, isRussian)) != null) {
                return Arrays.asList(newParameter);
            }
        }
        if ((newLines = this.getLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor)).isEmpty()) {
            return lines;
        }
        return newLines;
    }
}

