/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.Type;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.platform.IEObjectProvider;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class EventNameProvider {
    private static final Collection<String> FORM_TYPE_NAMES = ImmutableList.builder().add((Object)"ManagedForm").add((Object)"ManagedFormExtensionForObjects").add((Object)"ManagedFormExtensionForConstants").add((Object)"ManagedFormExtensionForCatalogs").add((Object)"ManagedFormExtensionForDocuments").add((Object)"ManagedFormExtensionForChartOfCharacteristicsTypes").add((Object)"ManagedFormExtensionForReports").add((Object)"ManagedFormExtensionForBusinessProcesses").add((Object)"ManagedFormExtensionForTasks").add((Object)"ManagedFormExtensionForRecordSet").add((Object)"ManagedFormExtensionForInformationRegisterRecords").add((Object)"ManagedFormExtensionForDynamicLists").add((Object)"ManagedFormExtensionForSettingsComposer)").add((Object)"ClientApplicationForm").add((Object)"ClientApplicationFormExtensionForObjects").add((Object)"ClientApplicationFormExtensionForConstants").add((Object)"ClientApplicationFormExtensionForCatalogs").add((Object)"ClientApplicationFormExtensionForDocuments").add((Object)"ClientApplicationFormExtensionForChartOfCharacteristicsTypes").add((Object)"ClientApplicationFormExtensionForReports").add((Object)"ClientApplicationFormExtensionForBusinessProcesses").add((Object)"ClientApplicationFormExtensionForTasks").add((Object)"ClientApplicationFormExtensionForRecordSet").add((Object)"ClientApplicationFormExtensionForInformationRegisterRecords").add((Object)"ClientApplicationFormExtensionForDynamicLists").add((Object)"ClientApplicationFormExtensionForSettingsComposer)").add((Object)"FormField").add((Object)"FormFieldExtensionForACalendarField").add((Object)"FormFieldExtensionForAChartField").add((Object)"FormFieldExtensionForACheckBoxField").add((Object)"FormFieldExtensionForADendrogramField").add((Object)"FormFieldExtensionForAFormattedDocument").add((Object)"FormFieldExtensionForAGanttChartField").add((Object)"FormFieldExtensionForAGeographicalSchemaField").add((Object)"FormFieldExtensionForAGraphicalSchemaField").add((Object)"FormFieldExtensionForALabelField").add((Object)"FormFieldExtensionForAPeriodField").add((Object)"FormFieldExtensionForAPeriodField").add((Object)"FormFieldExtensionForAPictureField").add((Object)"FormFieldExtensionForAPlanner").add((Object)"FormFieldExtensionForAProgressBarField").add((Object)"FormFieldExtensionForARadioButtonField").add((Object)"FormFieldExtensionForASpreadsheetDocumentField").add((Object)"FormFieldExtensionForATextBox").add((Object)"FormFieldExtensionForATextDocument").add((Object)"FormFieldExtensionForATrackBarField").add((Object)"FormGroup").add((Object)"FormGroupExtensionForAButtonGroup").add((Object)"FormGroupExtensionForACommandBar").add((Object)"FormGroupExtensionForAGroupOfColumns").add((Object)"FormGroupExtensionForAPage").add((Object)"FormGroupExtensionForAPopup").add((Object)"FormGroupExtensionForAUsualGroup").add((Object)"FormGroupExtensionForPages").add((Object)"FormTable").add((Object)"FormTableExtensionForDataCompositionAppearanceFields").add((Object)"FormTableExtensionForDataCompositionAvailableFields").add((Object)"FormTableExtensionForDataCompositionConditionalAppearance").add((Object)"FormTableExtensionForDataCompositionFilter").add((Object)"FormTableExtensionForDataCompositionGroupingFields").add((Object)"FormTableExtensionForDataCompositionOptionsOfUserChoiceField").add((Object)"FormTableExtensionForDataCompositionOrder").add((Object)"FormTableExtensionForDataCompositionParameterValues").add((Object)"FormTableExtensionForDataCompositionSelectedFields").add((Object)"FormTableExtensionForDataCompositionSettingsStructure").add((Object)"FormTableExtensionForDataCompositionSettingsStructureObject").add((Object)"FormTableExtensionForDataCompositionUserFields").add((Object)"FormTableExtensionForDataCompositionUserSettings").add((Object)"FormTableExtensionForDynamicList").add((Object)"FormTableExtensionForFilter").add((Object)"FormTableExtensionForTabularSections").add((Object)"FormTableExtensionForValueList").add((Object)"FormTableExtensionForValueTable").add((Object)"FormTableExtensionForValueTree").add((Object)"FormDecoration").add((Object)"FormDecorationExtensionForALabel").add((Object)"FormDecorationExtensionForAPicture").build();
    @Inject
    private IRuntimeVersionSupport versionSupport;
    private final Map<Version, Pair<Map<String, String>, Map<String, String>>> cache = Maps.newConcurrentMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public String getEventName(String eventName, boolean isRussina, EObject context) {
        Version version = this.versionSupport.getRuntimeVersion(context);
        Pair<Map<String, String>, Map<String, String>> content = this.cache.get(version);
        if (content == null) {
            Lock write = this.lock.writeLock();
            write.lock();
            try {
                content = this.getOrLoadEventCache(context, version);
            }
            finally {
                write.unlock();
            }
        }
        return isRussina ? (String)((Map)content.getFirst()).get(eventName) : (String)((Map)content.getSecond()).get(eventName);
    }

    private Pair<Map<String, String>, Map<String, String>> getOrLoadEventCache(EObject context, Version version) {
        if (this.cache.containsKey(version)) {
            return this.cache.get(version);
        }
        Collection<Event> events = this.getAllFormEvents(context, version);
        HashMap<String, Set> builder = new HashMap<String, Set>();
        HashMap<String, Set> builderRu = new HashMap<String, Set>();
        for (Event event : events) {
            Set value = builder.computeIfAbsent(event.getName(), n -> new HashSet());
            value.add(event.getNameRu());
            Set valueRu = builderRu.computeIfAbsent(event.getNameRu(), n -> new HashSet());
            valueRu.add(event.getName());
        }
        builder.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).forEach(e -> System.err.println(MessageFormat.format("Event {0} has multiple translation: {1}", e.getKey(), e.getValue())));
        builderRu.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).forEach(e -> System.err.println(MessageFormat.format("Event {0} has multiple translation: {1}", e.getKey(), e.getValue())));
        Map<String, String> result = builder.entrySet().stream().filter(e -> ((Set)e.getValue()).size() == 1).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)((Set)e.getValue()).iterator().next()));
        Map<String, String> resultRu = builderRu.entrySet().stream().filter(e -> ((Set)e.getValue()).size() == 1).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)((Set)e.getValue()).iterator().next()));
        this.cache.put(version, (Pair<Map<String, String>, Map<String, String>>)Tuples.create((Object)ImmutableMap.copyOf(result), (Object)ImmutableMap.copyOf(resultRu)));
        return this.cache.get(version);
    }

    private Collection<Event> getAllFormEvents(EObject context, Version version) {
        ArrayList events = Lists.newArrayList();
        for (TypeItem type : this.getFormTypes(context, version)) {
            if (!((type = (TypeItem)EcoreUtil.resolve((EObject)type, (EObject)context)) instanceof Type)) continue;
            events.addAll(((Type)type).getEvents());
        }
        return events;
    }

    private Collection<TypeItem> getFormTypes(EObject context, Version version) {
        IEObjectProvider provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.TYPE_ITEM, version);
        ArrayList extensionTypes = Lists.newArrayList();
        for (String typeName : FORM_TYPE_NAMES) {
            EObject proxy = provider.getProxy(typeName);
            if (proxy == null) continue;
            extensionTypes.add((TypeItem)EcoreUtil.resolve((EObject)proxy, (EObject)context));
        }
        return extensionTypes;
    }
}

