/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.KeyTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.metadata.mdclass.Subsystem;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractStringLiteralLinesCollector;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefBslCacheProvider;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class KeysCollector
extends AbstractStringLiteralLinesCollector {
    public static final String[] SUPPORTED_TYPES = new String[]{"Key", "Keys", "FQN", "Area"};
    public static final String[] SKIP_TYPES = new String[]{"Standard", "Event", "Type", "Types", "Query", "Query-DCS", "Sort-Columns", "Full-name", "Method", "Query-param", "Replace-param", "Query-part", "Package-Query", "Union-Query", "QL-Union", "QL-Union-all"};
    public static final String KEYS_DELIM = " \t\n\r\f,|[].'\"(){}<>?!@=-;%/\\#&:\u2116$^*";
    private static final String SUBSYSTEM_PREFIX = "Subsystem.";
    private static final String COMMON_MODULE_PREFIX = "CommonModule.";
    private static final List<String> SSL_INVOCATIONTS_COMMON_MODULE_NAME = List.of("\u041e\u0431\u0449\u0438\u0439\u041c\u043e\u0434\u0443\u043b\u044c", "CommonModule");
    private static final List<String> SSL_INVOCATIONTS_SUBSYSTEM_EXISTS_NAME = List.of("\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0430\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", "SubsystemExists");
    @Inject
    protected IStringLiteralTypeComputer typeComputer;
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private BslPreferences bslPreferences;
    @Inject
    private ContextDefBslCacheProvider contextDefCacheProvider;
    @Inject
    private IBmModelManager modelManager;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, SUPPORTED_TYPES) && !this.typeComputer.containsAnyType(types, SKIP_TYPES);
    }

    @Override
    protected void collectContent(StringLiteral literal, CollectingContext context, IProgressMonitor monitor) {
        if (!context.getParameters().isCollectModelStrings()) {
            return;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return;
        }
        IV8Project project = this.v8ProjectManager.getProject((EObject)literal);
        if (project == null) {
            return;
        }
        List<String> keysList = this.getKeys(literal, true);
        if (keysList.isEmpty()) {
            return;
        }
        FeatureKey featureKey = context.getFeatureKeyProvider().getKey((EObject)literal);
        boolean isRussian = project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH);
        ContextDefCache contextDefCache = this.getContextDefCache(project, (EObject)literal);
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)literal, Environmental.class);
        Environments actualEnvs = this.bslPreferences.getLoadEnvs(project.getProject()).intersect(environmental.environments());
        boolean sslInvocationCommonModule = this.isSSLInvocationParentCommonModule(literal);
        boolean sslInvocationSubsystemExists = this.isSSLInvocationParentSubsystemExists(literal);
        IBmObject prev = null;
        for (String key : keysList) {
            boolean isKeyComputed = this.isKeyComputed(literal, key, keysList, contextDefCache, actualEnvs, isRussian);
            if (sslInvocationCommonModule) {
                prev = this.resolveKeyCommonModule(key, prev, project);
            }
            if (sslInvocationSubsystemExists) {
                prev = this.resolveKeySubsystemExists(key, prev, project);
            }
            boolean isKeyUnknown = (sslInvocationCommonModule || sslInvocationSubsystemExists) && prev == null;
            FeatureValue keyValue = this.createFeatureValue(literal, featureKey, file, key, isKeyComputed, isKeyUnknown);
            HashMap nls = Maps.newHashMap();
            if (StringUtils.isNotEmpty((String)keyValue.getContextKey().getValue())) {
                nls.put(context.getDefaultLanguageCode(), keyValue.getContextKey().getValue());
            }
            FeaturesCollectorUtil.fillLocalStrings((FeatureValue)keyValue, (Map)nls, (Collection)context.getParameters().getLanguages());
            if (!TranslationUtils.isValidValueForCollectModelType((boolean)keyValue.isComputedValue(), (boolean)keyValue.isUnknown(), (boolean)keyValue.isTag(), (ICollectingParameters.CollectModelType)context.getParameters().getCollectModelType())) continue;
            context.getAddAction().accept(literal, keyValue);
        }
    }

    protected boolean isKeyComputed(StringLiteral literal, String key, List<String> keysList, ContextDefCache contextDefCache, Environments actualEnvs, boolean isRussian) {
        boolean isKeyComputed = false;
        if (StringUtils.isNotEmpty((String)this.internalizeDbViewTermsProvider.getInternalizeEnumValue(key, isRussian))) {
            isKeyComputed = true;
        }
        if (!isKeyComputed && StringUtils.isNotEmpty((String)contextDefCache.getPropertyName(key, actualEnvs, keysList))) {
            isKeyComputed = true;
        }
        return isKeyComputed;
    }

    protected ContextDefCache getContextDefCache(IV8Project project, EObject context) {
        boolean isRussian = project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH);
        return this.contextDefCacheProvider.getContextDefCache(context, isRussian);
    }

    protected List<String> getKeys(StringLiteral literal, boolean checkValidKey) {
        String literalContent = BslUtils.getString(literal);
        StringTokenizer tokenizer = new StringTokenizer(literalContent, KEYS_DELIM);
        if (!tokenizer.hasMoreTokens()) {
            return Collections.emptyList();
        }
        ArrayList<String> keysList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken();
            if (StringUtils.isNotWord((String)key) || checkValidKey && !KeyTypeComputer.isKey((String)key)) continue;
            keysList.add(key);
        }
        return keysList;
    }

    protected FeatureValue createFeatureValue(StringLiteral literal, FeatureKey literalFeatureKey, IFile file, String key, boolean isKeyComputed, boolean isKeyUnknown) {
        return new PersistableFeatureValue(file, literalFeatureKey.skipLast(1).append(key).append("Key"), BslFeatureSettings.Literals.STRING_LITERAL__KEY, key, isKeyComputed, isKeyUnknown, false);
    }

    @Override
    protected boolean isLinesComputedByDefault() {
        return true;
    }

    private IBmObject resolveKeyCommonModule(String key, IBmObject prev, IV8Project project) {
        IBmEngine engine;
        IBmObject result = null;
        if (prev == null && (result = (engine = this.modelManager.getModel(project.getProject()).getEngine()).getTopObjectByFqn(key)) == null) {
            result = engine.getTopObjectByFqn(COMMON_MODULE_PREFIX + key);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private IBmObject resolveKeySubsystemExists(String key, IBmObject prev, IV8Project project) {
        IBmObject result = null;
        if (prev == null) {
            IBmEngine engine = this.modelManager.getModel(project.getProject()).getEngine();
            result = engine.getTopObjectByFqn(key);
            if (result == null) {
                result = engine.getTopObjectByFqn(SUBSYSTEM_PREFIX + key);
            }
        } else {
            IBmObject iBmObject = prev;
            if (iBmObject instanceof Subsystem) {
                void parentSubsystem;
                Subsystem engine = (Subsystem)iBmObject;
                Subsystem cfr_ignored_0 = (Subsystem)iBmObject;
                result = parentSubsystem.getSubsystems().stream().filter(sub -> sub.getName().equalsIgnoreCase(key)).map(IBmObject.class::cast).findFirst().orElse(null);
            }
        }
        return result;
    }

    private boolean isSSLInvocationParentCommonModule(StringLiteral literal) {
        EObject parent = literal.eContainer();
        if (!(parent instanceof Invocation)) {
            return false;
        }
        Invocation invocation = (Invocation)parent;
        String invocationName = invocation.getMethodAccess().getName();
        return SSL_INVOCATIONTS_COMMON_MODULE_NAME.contains(invocationName);
    }

    private boolean isSSLInvocationParentSubsystemExists(StringLiteral literal) {
        EObject parent = literal.eContainer();
        if (!(parent instanceof Invocation)) {
            return false;
        }
        Invocation invocation = (Invocation)parent;
        String invocationName = invocation.getMethodAccess().getName();
        return SSL_INVOCATIONTS_SUBSYSTEM_EXISTS_NAME.contains(invocationName);
    }
}

