/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.KeyTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractStringLiteralLinesProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.KeysCollector;
import com.e1c.langtool.v8.dt.bsl.translator.BslDerivedPropertyCache;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefBslCacheProvider;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class KeysContentProcessor
extends AbstractStringLiteralLinesProcessor {
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    protected ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    private ContextDefBslCacheProvider contextDefCacheProvider;
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private BslPreferences bslPreferences;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, KeysCollector.SUPPORTED_TYPES) && !this.typeComputer.containsAnyType(types, KeysCollector.SKIP_TYPES);
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        List<String> nonContextLines;
        ArrayList newLines;
        EList lines = literal.lines(false);
        if (!this.isChangeScriptVariant(translationProvider) && !this.isChangeDefaultLanguage(translationProvider)) {
            return lines;
        }
        boolean priority = this.isStringLiteralLinesFullTranslationStoredPriority(literal);
        List<Object> list = newLines = priority ? this.getLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor) : this.getContextLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor);
        if (!newLines.isEmpty()) {
            this.updateKeyCache(literal, types, (List<String>)lines, newLines, translationProvider);
            return newLines;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return lines;
        }
        newLines = Lists.newArrayListWithExpectedSize((int)lines.size());
        FeatureKey featureKey = this.translationKeyProvider.getKey((EObject)literal);
        boolean isRussian = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        ContextDefCache contextDefCache = this.contextDefCacheProvider.getContextDefCache((EObject)literal, isRussian);
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)literal, Environmental.class);
        Environments actualEnvs = this.bslPreferences.getLoadEnvs(file.getProject()).intersect(environmental.environments());
        List<String> keysList = this.isChangeScriptVariant(translationProvider) ? this.getKeys(String.join((CharSequence)" ", (Iterable<? extends CharSequence>)lines), true) : Collections.emptyList();
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        boolean hasTanslation = false;
        for (String line : lines) {
            if (monitor.isCanceled()) {
                return lines;
            }
            StringBuilder sb = new StringBuilder();
            List<String> lineKeyList = this.getKeys(line, true);
            int position = 0;
            for (String key : lineKeyList) {
                int index = line.indexOf(key, position);
                if (index > position) {
                    sb.append(line.substring(position, index));
                }
                String translation = this.getKeyTranslation(key, keysList, literal, featureKey, actualEnvs, contextDefCache, file, translationProvider, language, isRussian, monitor);
                if (!key.equalsIgnoreCase(translation = this.fixKeyTranslationCase(key, translation))) {
                    hasTanslation = true;
                }
                sb.append(translation);
                result.add((Pair<String, String>)Tuples.create((Object)key, (Object)translation));
                position = index + key.length();
            }
            if (position < line.length()) {
                sb.append(line.substring(position));
            }
            newLines.add(sb.toString());
        }
        if (!hasTanslation && keysList.size() > 1 && !(nonContextLines = this.getLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor)).isEmpty()) {
            if (lines.size() == 1 && nonContextLines.size() == 1 && !StringUtils.isNotWord((String)((String)lines.get(0)))) {
                String translation = this.fixKeyTranslationCase((String)lines.get(0), (String)newLines.get(0));
                nonContextLines.clear();
                nonContextLines.add(translation);
            }
            this.updateKeyCache(literal, types, (List<String>)lines, nonContextLines, translationProvider);
            return newLines;
        }
        this.updateKeyCache(literal, types, result, translationProvider);
        return newLines;
    }

    protected void updateKeyCache(StringLiteral literal, Collection<LiteralType> types, List<String> lines, List<String> newLines, IProjectTranslationProvider translationProvider) {
        if (this.typeComputer.containsAnyType(types, new String[]{"Key", "Keys"})) {
            ArrayList<Pair<String, String>> translations = new ArrayList<Pair<String, String>>();
            List<String> keyList = this.getKeys(String.join((CharSequence)"", lines), true);
            List<String> translatedKeyList = this.getKeys(String.join((CharSequence)"", newLines), true);
            int i = 0;
            while (i < keyList.size() && i < translatedKeyList.size()) {
                String key = keyList.get(i);
                String translation = translatedKeyList.get(i);
                translations.add((Pair<String, String>)Tuples.create((Object)key, (Object)translation));
                ++i;
            }
            this.updateKeyCache(literal, types, translations, translationProvider);
        }
    }

    protected void updateKeyCache(StringLiteral literal, Collection<LiteralType> types, List<Pair<String, String>> translations, IProjectTranslationProvider translationProvider) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)literal);
        if (node != null && this.typeComputer.containsAnyType(types, new String[]{"Key", "Keys"})) {
            int localOffset = node.getTotalOffset();
            String methodName = "";
            String moduleUri = EcoreUtil.getURI((EObject)EcoreUtil2.getContainerOfType((EObject)literal, Module.class)).toString();
            Method method = (Method)EcoreUtil2.getContainerOfType((EObject)literal, Method.class);
            if (method != null) {
                methodName = method.getName();
                ICompositeNode methodNode = NodeModelUtils.findActualNodeFor((EObject)method);
                localOffset -= methodNode.getTotalOffset();
            }
            BslDerivedPropertyCache cache = (BslDerivedPropertyCache)translationProvider.getCache(BslDerivedPropertyCache.class);
            String nodeText = node.getText();
            int fromIndex = 0;
            for (Pair<String, String> item : translations) {
                int position = nodeText.indexOf((String)item.getFirst(), fromIndex);
                fromIndex += ((String)item.getFirst()).length();
                if (position == -1) continue;
                String translation = (String)item.getSecond();
                fromIndex = position + ((String)item.getFirst()).length();
                cache.putTranslation(moduleUri, methodName, localOffset + position, translation);
            }
        }
    }

    protected String getKeyTranslation(String key, List<String> keysList, StringLiteral literal, FeatureKey literalFeatureKey, Environments actualEnvs, ContextDefCache contextDefCache, IFile file, IProjectTranslationProvider translationProvider, TranslateLanguage language, boolean isRussian, CancelIndicator monitor) {
        ContextTranslationKey contextKey = this.createFeatureValue(literal, literalFeatureKey, file, key);
        String translation = translationProvider.getStoredTranslation(contextKey, language, new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNotEmpty((String)translation)) {
            return translation;
        }
        if (this.isChangeScriptVariant(translationProvider)) {
            translation = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(key, isRussian);
            if (StringUtils.isNotEmpty((String)translation)) {
                return translation;
            }
            translation = contextDefCache.getPropertyName(key, actualEnvs, keysList);
            if (StringUtils.isNotEmpty((String)translation)) {
                return translation;
            }
        }
        return key;
    }

    protected List<String> getKeys(String content, boolean checkValidKey) {
        if (content == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(content, " \t\n\r\f,|[].'\"(){}<>?!@=-;%/\\#&:\u2116$^*");
        if (!tokenizer.hasMoreTokens()) {
            return Collections.emptyList();
        }
        ArrayList<String> keysList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken();
            if (StringUtils.isNotWord((String)key) || checkValidKey && !KeyTypeComputer.isKey((String)key)) continue;
            keysList.add(key);
        }
        return keysList;
    }

    protected ContextTranslationKey createFeatureValue(StringLiteral literal, FeatureKey literalFeatureKey, IFile file, String key) {
        return new ContextTranslationKeyImpl(file, literalFeatureKey.skipLast(1).append(key).append("Key"), BslFeatureSettings.Literals.STRING_LITERAL__KEY, key);
    }

    @Override
    protected boolean isChangeScriptVariant(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeScriptVariant();
    }

    @Override
    protected boolean isChangeDefaultLanguage(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeDefaultLanguage();
    }
}

