/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.ITranslateProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.format.FormatInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.CancelIndicator;

public class NstrContentProcessor
implements TypedStringLiteralContentProcessor {
    @Inject
    protected IStringLiteralTypeComputer typeComputer;
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private TranslationPreferences preferences;
    @Inject
    private IConverterService converterService;
    @Inject
    private FormatInternalizeTokenProvider tokenProvider;
    @Inject
    private BslPreferences bslPreferences;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"NStr"}) && !this.typeComputer.containsAnyType(types, new String[]{"Nstr-format", "Replace-params"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage defaultLanguage, CancelIndicator monitor) {
        IConverterManager manager;
        TranslateLanguage language;
        Map<String, String> localStringsMap;
        EList lines = literal.lines(false);
        if (this.getInterfaceLanguages(translationProvider).isEmpty()) {
            return lines;
        }
        List<String> languageCodes = this.getLanguageCodes(translationProvider);
        ITranslatingProject sourceProject = translationProvider.getProject().getSourceProject();
        String sourceLanguageCode = sourceProject.getDefaultLanguage().getLanguageCode();
        IProject project = sourceProject.getProject();
        TranslatorProperties bslTranslatorProperties = this.bslPreferences.getTranslatorProperties(project);
        boolean alphabeticalLanguageOrderInNStr = bslTranslatorProperties.isAlphabeticalLanguageOrderInNStr();
        Map<String, String> map = localStringsMap = alphabeticalLanguageOrderInNStr ? new TreeMap<String, String>(BslUtils.getNlsLocalStrings(literal)) : BslUtils.getNlsLocalStrings(literal);
        if (localStringsMap.isEmpty() || !localStringsMap.containsKey(sourceLanguageCode)) {
            return lines;
        }
        String sourceString = localStringsMap.get(sourceLanguageCode);
        String[] sourceLanguageCodes = localStringsMap.keySet().toArray(new String[0]);
        int i = 0;
        while (i < sourceLanguageCodes.length) {
            String languageCode = sourceLanguageCodes[i];
            if (!languageCodes.contains(languageCode)) {
                localStringsMap.remove(languageCode);
            }
            ++i;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES, sourceString);
        for (TranslateLanguage language2 : translationProvider.getProject().getInterfaceLanguages()) {
            String translation = this.getTranslation(literal, sourceString, (ContextTranslationKey)contextKey, translationProvider, language2);
            localStringsMap.put(language2.getLanguageCode(), translation.replace("\r", ""));
        }
        if (localStringsMap.containsKey(sourceLanguageCode) && this.isNeedToTranslateToSourceLanguage(sourceString)) {
            String translation = this.getTranslation(literal, sourceString, (ContextTranslationKey)contextKey, translationProvider, sourceProject.getDefaultLanguage());
            localStringsMap.put(sourceLanguageCode, translation.replace("\r", ""));
        }
        String newString = this.formatNstrContent(localStringsMap, literal, sourceString, (ContextTranslationKey)contextKey, translationProvider, defaultLanguage);
        if (this.preferences.getTranslationProperties(project).isEnablePersistentKeyMappingCache() && (language = (manager = this.converterService.getManager(project)).getLanguage()).getLanguageCode().equals(defaultLanguage.getLanguageCode())) {
            FeatureKey convertedFeatureKey = this.translationKeyProvider.getConvertedFeatureKey((EObject)literal, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES, localStringsMap.get(defaultLanguage.getLanguageCode()), (ITranslateProject)translationProvider.getProject());
            Path path = new Path(EcoreUtil.getURI((EObject)literal).trimFragment().toPlatformString(true));
            manager.updateConvertedValues(path.makeRelativeTo(project.getFullPath()), featureKey, convertedFeatureKey);
        }
        return Arrays.asList(newString.split("\n", -1));
    }

    protected String formatNstrContent(Map<String, String> nstrContent, StringLiteral literal, String sourceString, ContextTranslationKey contextKey, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = nstrContent.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String template = BslUtils.formatNStrEntry(entry.getKey(), entry.getValue());
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(template);
            if (!iterator.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    protected String getTranslation(StringLiteral literal, String sourceString, ContextTranslationKey contextKey, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        String translation = translationProvider.getTranslation((EObject)literal, contextKey, language);
        if (StringUtils.isNullOrEmpty((String)translation)) {
            translation = sourceString;
        }
        return translation;
    }

    protected List<TranslateLanguage> getInterfaceLanguages(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().getInterfaceLanguages();
    }

    private List<String> getLanguageCodes(IProjectTranslationProvider translationProvider) {
        ArrayList languageCodes = Lists.newArrayList();
        for (Language language : translationProvider.getProject().getLanguages()) {
            String languageCode = language.getLanguageCode();
            if (StringUtils.isNullOrEmpty((String)languageCode)) continue;
            languageCodes.add(language.getLanguageCode());
        }
        return languageCodes;
    }

    private boolean isNeedToTranslateToSourceLanguage(String content) {
        V8ParametersStringParser parser = new V8ParametersStringParser(content);
        if (parser.getStatus().isOK() && !parser.getParameters().isEmpty()) {
            Map parameters = parser.getParameters();
            for (Map.Entry entry : parameters.entrySet()) {
                if (!this.tokenProvider.isFormatKey((String)entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }
}

