/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.ContentTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;

public class NstrParamTypeComputer
implements ContentTypeComputer {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private IV8ProjectManager projectManager;

    public int order() {
        return 11000;
    }

    public @NonNull String getSupportedType() {
        return "Replace-params";
    }

    public boolean computeWithAnnotations(Collection<LiteralType> types) {
        return types.contains(this.typeComputer.getType("NStr"));
    }

    public boolean computeIsValidForSupportedType(@NonNull StringLiteral literal, @NonNull List<String> content, Collection<LiteralType> contextTypes) {
        if (!this.typeComputer.containsAnyType(contextTypes, new String[]{"NStr"})) {
            return false;
        }
        Map<String, String> nls = BslUtils.getNlsLocalStrings(literal);
        if (nls.isEmpty()) {
            return false;
        }
        String defaultLanguageCode = this.getDefaulLanguageCode(literal);
        if (defaultLanguageCode == null) {
            return false;
        }
        String nlsString = nls.get(defaultLanguageCode);
        if (StringUtils.isNullOrEmpty((String)nlsString)) {
            return false;
        }
        return !Utils.getParamsMapFromNls((String)nlsString).isEmpty();
    }

    private String getDefaulLanguageCode(@NonNull StringLiteral literal) {
        Configuration configuration = this.configurationProvider.getConfiguration((EObject)literal);
        if (configuration != null && configuration.getDefaultLanguage() != null) {
            return configuration.getDefaultLanguage().getLanguageCode();
        }
        IV8Project project = this.projectManager.getProject((EObject)literal);
        if (project != null && project.getDefaultLanguage() != null) {
            return project.getDefaultLanguage().getLanguageCode();
        }
        return null;
    }
}

