/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractQueryPartProcessor;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.ql.QlPartStringParser;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.runtime.Token;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class QueryPartCollector
extends AbstractQueryPartProcessor {
    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Query-part"});
    }

    @Override
    protected void collectContent(StringLiteral literal, CollectingContext context, IProgressMonitor monitor) {
        if (!context.getParameters().isCollectModelStrings() || monitor.isCanceled()) {
            return;
        }
        EList lines = literal.lines(false);
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return;
        }
        IV8Project project = this.v8ProjectManager.getProject((EObject)literal);
        if (project == null) {
            return;
        }
        String literalContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)lines);
        FeatureKey featureKey = context.getFeatureKeyProvider().getKey((EObject)literal);
        boolean isRussian = project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH);
        QlPartStringParser parser = this.getQlPartStringParser(literalContent);
        Iterator iterator = parser.iterator();
        while (iterator.hasNext()) {
            boolean isKeyComputed;
            HashMap nls;
            if (monitor.isCanceled()) {
                return;
            }
            Token token = (Token)iterator.next();
            if (parser.isKeyword(token) || parser.isFunction(token)) continue;
            if (parser.isStringLiteral(token)) {
                String literalText = this.getStringLiteralContent(token, parser).trim();
                if (StringUtils.isBlank((String)literalText) || StringUtils.isNotWord((String)literalText)) continue;
                FeatureValue keyValue = this.createStringLiteralFeatureValue(featureKey, file, literalText);
                nls = Maps.newHashMap();
                nls.put(context.getDefaultLanguageCode(), keyValue.getContextKey().getValue());
                FeaturesCollectorUtil.fillLocalStrings((FeatureValue)keyValue, (Map)nls, (Collection)context.getParameters().getLanguages());
                context.getAddAction().accept(literal, keyValue);
                continue;
            }
            if (parser.isComment(token)) {
                String comment = this.getCommentContent(token, parser).trim();
                if (StringUtils.isBlank((String)comment) || StringUtils.isNotWord((String)comment)) continue;
                FeatureValue keyValue = this.createCommentFeatureValue(featureKey, file, comment);
                nls = Maps.newHashMap();
                nls.put(context.getDefaultLanguageCode(), keyValue.getContextKey().getValue());
                FeaturesCollectorUtil.fillLocalStrings((FeatureValue)keyValue, (Map)nls, (Collection)context.getParameters().getLanguages());
                context.getAddAction().accept(literal, keyValue);
                continue;
            }
            String key = this.getKey(token, parser);
            if (key == null || !TranslationUtils.isValidValueForCollectModelType((boolean)(isKeyComputed = this.isKeyComputed(literal, key, isRussian)), (boolean)false, (boolean)false, (ICollectingParameters.CollectModelType)context.getParameters().getCollectModelType())) continue;
            FeatureValue keyValue = this.createKeyFeatureValue(featureKey, file, key, isKeyComputed);
            HashMap nls2 = Maps.newHashMap();
            nls2.put(context.getDefaultLanguageCode(), keyValue.getContextKey().getValue());
            FeaturesCollectorUtil.fillLocalStrings((FeatureValue)keyValue, (Map)nls2, (Collection)context.getParameters().getLanguages());
            context.getAddAction().accept(literal, keyValue);
        }
    }

    protected boolean isKeyComputed(StringLiteral literal, String key, boolean isRussian) {
        boolean isKeyComputed = false;
        if (StringUtils.isNotEmpty((String)this.internalizeDbViewTermsProvider.getInternalizeEnumValue(key, isRussian))) {
            isKeyComputed = true;
        }
        return isKeyComputed;
    }

    @Override
    protected boolean isLinesComputedByDefault() {
        return true;
    }

    protected FeatureValue createKeyFeatureValue(FeatureKey featureKey, IFile file, String key, boolean isKeyComputed) {
        return new PersistableFeatureValue(this.createKeyContextTranslationKey(file, featureKey, key), isKeyComputed);
    }

    protected FeatureValue createStringLiteralFeatureValue(FeatureKey featureKey, IFile file, String content) {
        return new PersistableFeatureValue(this.createStringLiteralContextTranslationKey(file, featureKey, content), false);
    }

    protected FeatureValue createCommentFeatureValue(FeatureKey featureKey, IFile file, String content) {
        return new PersistableFeatureValue(this.createCommentContextTranslationKey(file, featureKey, content), false);
    }
}

