/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.QueryTypeComputer;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.util.CancelIndicator;

public class QueryPartTypeComputer
extends QueryTypeComputer {
    private static final String KEYWORD_PATTERN_START = "(?:^|[\\s\\W]+)(";
    private static final String KEYWORD_PATTERN_END = ")(?:$|[\\s\\W]+)";
    private static final Pattern PATTERN_KEYWORD_RU = Pattern.compile("(?:^|[\\s\\W]+)(" + String.join((CharSequence)"|", "\u0410\u0412\u0422\u041e\u0423\u041f\u041e\u0420\u042f\u0414\u041e\u0427\u0418\u0412\u0410\u041d\u0418\u0415", "\u0410\u0412\u0422\u041e\u041d\u041e\u041c\u0415\u0420\u0417\u0410\u041f\u0418\u0421\u0418", "\u0411\u0423\u041b\u0415\u0412\u041e", "\u0412\u041d\u0415\u0428\u041d\u0415\u0415", "\u0412\u041d\u0423\u0422\u0420\u0415\u041d\u041d\u0415\u0415", "\u0412\u041e\u0417\u0420", "\u0412\u0421\u0415", "\u0412\u042b\u0411\u041e\u0420", "\u0412\u042b\u0411\u0420\u0410\u0422\u042c", "\u0412\u042b\u0420\u0410\u0417\u0418\u0422\u042c", "\u0413\u0414\u0415", "\u0413\u041e\u0414", "\u0413\u0420\u0423\u041f\u041f\u0418\u0420\u0423\u042e\u0429\u0418\u041c", "\u0414\u0410\u0422\u0410", "\u0414\u0410\u0422\u0410\u0412\u0420\u0415\u041c\u042f", "\u0414\u0415\u041a\u0410\u0414\u0410", "\u0414\u0415\u041d\u042c", "\u0414\u0415\u041d\u042c\u0413\u041e\u0414\u0410", "\u0414\u0415\u041d\u042c\u041d\u0415\u0414\u0415\u041b\u0418", "\u0414\u041b\u042f\u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u042f", "\u0414\u041e\u0411\u0410\u0412\u0418\u0422\u042c\u041a\u0414\u0410\u0422\u0415", "\u0415\u0421\u0422\u042c", "\u0415\u0421\u0422\u042cNULL", "\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415", "\u0418\u0415\u0420\u0410\u0420\u0425\u0418\u0418", "\u0418\u0415\u0420\u0410\u0420\u0425\u0418\u042f", "\u0418\u0417", "\u0418\u041b\u0418", "\u0418\u041c\u0415\u042e\u0429\u0418\u0415", "\u0418\u041d\u0410\u0427\u0415", "\u0418\u041d\u0414\u0415\u041a\u0421\u0418\u0420\u041e\u0412\u0410\u0422\u042c \u041f\u041e", "\u0418\u0421\u0422\u0418\u041d\u0410", "\u0418\u0422\u041e\u0413\u0418", "\u041f\u041e", "\u041a\u0410\u041a", "\u041a\u0412\u0410\u0420\u0422\u0410\u041b", "\u041a\u041e\u0413\u0414\u0410", "\u041a\u041e\u041b\u0418\u0427\u0415\u0421\u0422\u0412\u041e", "\u041a\u041e\u041d\u0415\u0426\u041f\u0415\u0420\u0418\u041e\u0414\u0410", "\u041a\u041e\u041d\u0415\u0426", "\u041b\u0415\u0412\u041e\u0415", "\u041b\u041e\u0416\u042c", "\u041c\u0410\u041a\u0421\u0418\u041c\u0423\u041c", "\u041c\u0415\u0416\u0414\u0423", "\u041c\u0415\u0421\u042f\u0426", "\u041c\u0418\u041d\u0418\u041c\u0423\u041c", "\u041c\u0418\u041d\u0423\u0422\u0410", "\u041d\u0410\u0411\u041e\u0420\u0410\u041c", "\u041d\u0410\u0427\u0410\u041b\u041e\u041f\u0415\u0420\u0418\u041e\u0414\u0410", "\u041d\u0415", "\u041d\u0415\u0414\u0415\u041b\u042f", "\u041d\u0415\u041e\u041f\u0420\u0415\u0414\u0415\u041b\u0415\u041d\u041e", "\u041e\u0411\u0429\u0418\u0415", "\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c", "\u041f\u0415\u0420\u0412\u042b\u0415", "\u041f\u0415\u0420\u0418\u041e\u0414\u0410\u041c\u0418", "\u041f\u041e\u0414\u041e\u0411\u041d\u041e", "\u041f\u041e\u0414\u0421\u0422\u0420\u041e\u041a\u0410", "\u041f\u041e\u041b\u041d\u041e\u0415", "\u041f\u041e\u041b\u0423\u0413\u041e\u0414\u0418\u0415", "\u041f\u041e\u041c\u0415\u0421\u0422\u0418\u0422\u042c", "\u041f\u0420\u0410\u0412\u041e\u0415", "\u041f\u0420\u0415\u0414\u0421\u0422\u0410\u0412\u041b\u0415\u041d\u0418\u0415", "\u041f\u0420\u0415\u0414\u0421\u0422\u0410\u0412\u041b\u0415\u041d\u0418\u0415\u0421\u0421\u042b\u041b\u041a\u0418", "\u041f\u0423\u0421\u0422\u0410\u042f\u0422\u0410\u0411\u041b\u0418\u0426\u0410", "\u0420\u0410\u0417\u041b\u0418\u0427\u041d\u042b\u0415", "\u0420\u0410\u0417\u041d\u041e\u0421\u0422\u042c\u0414\u0410\u0422", "\u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d\u041d\u042b\u0415", "\u0421\u0413\u0420\u0423\u041f\u041f\u0418\u0420\u041e\u0412\u0410\u0422\u042c \u041f\u041e", "\u0421\u0413\u0420\u0423\u041f\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u041e\u041f\u041e", "\u0421\u0415\u041a\u0423\u041d\u0414\u0410", "\u0421\u041e\u0415\u0414\u0418\u041d\u0415\u041d\u0418\u0415", "\u0421\u041f\u0415\u0426\u0421\u0418\u041c\u0412\u041e\u041b", "\u0421\u0420\u0415\u0414\u041d\u0415\u0415", "\u0421\u0421\u042b\u041b\u041a\u0410", "\u0421\u0422\u0420\u041e\u041a\u0410", "\u0421\u0423\u041c\u041c\u0410", "\u0422\u041e\u0413\u0414\u0410", "\u0422\u0418\u041f", "\u0422\u0418\u041f\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u042f", "\u0422\u041e\u041b\u042c\u041a\u041e", "\u0423\u0411\u042b\u0412", "\u0423\u041f\u041e\u0420\u042f\u0414\u041e\u0427\u0418\u0422\u042c \u041f\u041e", "\u0427\u0410\u0421", "\u0427\u0418\u0421\u041b\u041e", "\u0423\u041d\u0418\u0427\u0422\u041e\u0416\u0418\u0422\u042c") + ")(?:$|[\\s\\W]+)", 256);
    private static final Pattern PATTERN_KEYWORD_RU2 = Pattern.compile(String.join((CharSequence)"|", "(^|\\s+)\u0412\\s*\\(", "(^|\\s+)\u0418\\s+", "\u0418\\s+\u041d\u0435\\s+"), 256);
    private static final Pattern PATTERN_UNIVERSAL = Pattern.compile(" = &");
    private static final Pattern PATTERN_KEYWORD_EN = Pattern.compile("(?:^|[\\s\\W]+)(" + String.join((CharSequence)"|", "AUTOORDER", "RECORDAUTONUMBER", "BOOLEAN", "IN", "OUTER", "INNER", "ASC", "ALL", "CASE", "SELECT", "CAST", "WHERE", "YEAR", "GROUPING", "DATE", "DATETIME", "TENDAYS", "DAY", "DAYOFYEAR", "WEEKDAY", "FOR UPDATE", "DATEADD", "IS", "ISNULL", "VALUE", "AND", "HIERARCHY", "FROM", "OR", "HAVING", "ELSE", "INDEX BY", "TRUE", "TOTALS", "BY", "AS", "QUARTER", "WHEN", "COUNT", "ENDOFPERIOD", "END", "LEFT", "FALSE", "MAX", "BETWEEN", "MONTH", "MIN", "MINUTE", "SETS", "BEGINOFPERIOD", "NOT", "WEEK", "UNDEFINED", "OVERALL", "UNION", "TOP", "PERIODS", "LIKE", "SUBSTRING", "FULL", "HALFYEAR", "INTO", "RIGHT", "PRESENTATION", "REFPRESENTATION", "EMPTYTABLE", "DISTINCT", "DATEDIFF", "ALLOWED", "GROUP BY", "GROUPEDBY", "SECOND", "JOIN", "ON", "ESCAPE", "AVG", "REFS", "STRING", "SUM", "THEN", "TYPE", "VALUETYPE", "ONLY", "DESC", "ORDER BY", "HOUR", "NUMBER", "DROP") + ")(?:$|[\\s\\W]+)", 256);
    @Inject
    private IV8ProjectManager projectManager;

    public int order() {
        return 12000;
    }

    public @NonNull String getSupportedType() {
        return "Query-part";
    }

    public @NonNull IStatus validate(@NonNull StringLiteral literal, @NonNull List<String> content, @NonNull CancelIndicator monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public boolean computeIsValidForSupportedType(@NonNull StringLiteral literal, @NonNull List<String> content, Collection<LiteralType> contextTypes) {
        IV8Project project = this.projectManager.getProject((EObject)literal);
        if (project == null) {
            return false;
        }
        boolean isRu = project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        Pattern keywordPattern = isRu ? PATTERN_KEYWORD_RU : PATTERN_KEYWORD_EN;
        for (String line : content) {
            if ((line = line.stripLeading()).isBlank() || line.startsWith("//")) continue;
            if (line.startsWith("\u0412\u042b\u0411\u0420\u0410\u0422\u042c") || line.startsWith("SELECT")) {
                return false;
            }
            if (PATTERN_UNIVERSAL.matcher(line).find() || isRu && PATTERN_KEYWORD_RU2.matcher(line).find()) {
                return true;
            }
            Matcher matcher = keywordPattern.matcher(line);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

