/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.KeyTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.KeysCollector;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;

public class SortColumnsCollector
extends KeysCollector {
    public static final String FQN_COLUMN = "Column";
    public static final String ASC = "Asc";
    public static final String DESC = "Desc";
    public static final String ASC_RU = "\u0412\u043e\u0437\u0440";
    public static final String DESC_RU = "\u0423\u0431\u044b\u0432";
    public static final Set<String> DIRECTION_KEYS = ImmutableSet.builder().add((Object)"Asc".toLowerCase()).add((Object)"\u0412\u043e\u0437\u0440".toLowerCase()).add((Object)"Desc".toLowerCase()).add((Object)"\u0423\u0431\u044b\u0432".toLowerCase()).build();

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Sort-Columns"});
    }

    @Override
    protected List<String> getKeys(StringLiteral literal, boolean checkValidKey) {
        EList lines = literal.lines(true);
        List<String> columns = Arrays.asList(String.join((CharSequence)"", (Iterable<? extends CharSequence>)lines).split(","));
        ArrayList<String> keyList = new ArrayList<String>();
        for (String column : columns) {
            String[] sort = column.trim().split(" ");
            String key = null;
            if (!(sort.length == 1 || sort.length == 2 && DIRECTION_KEYS.contains(sort[1].trim().toLowerCase()))) {
                return Collections.emptyList();
            }
            key = sort[0].trim();
            if (checkValidKey && !KeyTypeComputer.isKey((String)key)) continue;
            keyList.add(key);
        }
        return keyList;
    }

    @Override
    protected boolean isKeyComputed(StringLiteral literal, String key, List<String> keysList, ContextDefCache contextDefCache, Environments actualEnvs, boolean isRussian) {
        return super.isKeyComputed(literal, key, Collections.emptyList(), contextDefCache, actualEnvs, isRussian);
    }

    @Override
    protected FeatureValue createFeatureValue(StringLiteral literal, FeatureKey literalFeatureKey, IFile file, String key, boolean isKeyComputed, boolean isKeyUnknown) {
        return new PersistableFeatureValue(file, literalFeatureKey.skipLast(1).append(FQN_COLUMN).append(key).append("Key"), BslFeatureSettings.Literals.STRING_LITERAL__KEY, key, isKeyComputed, isKeyUnknown, false);
    }
}

