/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameService;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class TypeContentProcessor
implements TypedStringLiteralContentProcessor {
    protected final IStringLiteralTypeComputer typeComputer;
    protected final IQualifiedNameConverter qualifiedNameConverter;
    protected final ITranslatedSymbolicNameService translatedSymbolicNameService;
    protected final IScopeProvider scopeProvider;
    private final BslPreferences bslPreferences;
    private final IResourceLookup resourceLookup;

    @Inject
    public TypeContentProcessor(IStringLiteralTypeComputer typeComputer, IQualifiedNameConverter qualifiedNameConverter, ITranslatedSymbolicNameService translatedSymbolicNameService, IScopeProvider scopeProvider, BslPreferences bslPreferences, IResourceLookup resourceLookup) {
        this.typeComputer = typeComputer;
        this.qualifiedNameConverter = qualifiedNameConverter;
        this.translatedSymbolicNameService = translatedSymbolicNameService;
        this.scopeProvider = scopeProvider;
        this.bslPreferences = bslPreferences;
        this.resourceLookup = resourceLookup;
    }

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Type"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        EList lines = literal.lines(false);
        if (lines.isEmpty()) {
            return lines;
        }
        String typeName = String.join((CharSequence)"", (Iterable<? extends CharSequence>)lines).trim();
        String newTypeName = this.getTypeName(typeName, (EObject)literal, translationProvider);
        String content = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)lines);
        return Arrays.asList(content.replace(typeName, newTypeName).split("\n", -1));
    }

    public String getTypeName(String typeName, EObject context, IProjectTranslationProvider translationProvider) {
        String translatedTypeName;
        boolean isRu = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        if (!StringUtils.isBlank((String)typeName) && !StringUtils.isBlank((String)(translatedTypeName = this.getTypeNameInternal(typeName, context, translationProvider, isRu)))) {
            return translatedTypeName;
        }
        return this.getReplaceText(typeName, context, translationProvider, isRu);
    }

    private String getTypeNameInternal(String typeName, EObject context, IProjectTranslationProvider translationProvider, boolean isRu) {
        QualifiedName fqn;
        IScope scope = this.scopeProvider.getScope(context, McorePackage.Literals.TYPE_DESCRIPTION__TYPES);
        IEObjectDescription obj = scope.getSingleElement(fqn = this.qualifiedNameConverter.toQualifiedName(typeName));
        if (obj != null) {
            TypeItem type = (TypeItem)obj.getEObjectOrProxy();
            String newTypeName = null;
            newTypeName = isRu ? McoreUtil.getTypeNameRu((TypeItem)type) : McoreUtil.getTypeName((TypeItem)type);
            if (fqn.getSegmentCount() > 1 && newTypeName != null && newTypeName.toLowerCase().contains(fqn.getSegment(1).toLowerCase())) {
                QualifiedName newTypeFqn = this.qualifiedNameConverter.toQualifiedName(newTypeName);
                String translated = this.translatedSymbolicNameService.generateSymbolicName((EObject)type, context, McorePackage.Literals.TYPE_DESCRIPTION__TYPES, translationProvider);
                QualifiedName transFqn = this.qualifiedNameConverter.toQualifiedName(translated);
                if (transFqn.getSegmentCount() == fqn.getSegmentCount()) {
                    newTypeName = this.qualifiedNameConverter.toString(this.qualifiedNameConverter.toQualifiedName(newTypeFqn.getFirstSegment()).append(transFqn.skipFirst(1)));
                } else if (transFqn.getSegmentCount() == fqn.getSegmentCount() - 1) {
                    newTypeName = this.qualifiedNameConverter.toString(this.qualifiedNameConverter.toQualifiedName(newTypeFqn.getFirstSegment()).append(transFqn));
                }
            }
            if (StringUtils.isNotEmpty((String)newTypeName)) {
                return newTypeName;
            }
        }
        return null;
    }

    private String getReplaceText(String typeName, EObject context, IProjectTranslationProvider translationProvider, boolean isRu) {
        IProject project = this.resourceLookup.getProject(context);
        TranslatorProperties properties = this.bslPreferences.getTranslatorProperties(project);
        if (!properties.isReplaceUnknownTypesInDocumentationComment()) {
            return typeName;
        }
        String[] splitted = typeName.split("\\.");
        if (splitted.length == 0) {
            return typeName;
        }
        String coreType = splitted[0];
        String translatedTypeName = this.getTypeNameInternal(coreType, context, translationProvider, isRu);
        if (StringUtils.isNotEmpty((String)translatedTypeName)) {
            return translatedTypeName;
        }
        return isRu ? "\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e" : "Undefined";
    }
}

