/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslCommentUtils;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.LinkPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TextPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.comment.BslCommentFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentKeyComputer;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.BslCommentTextProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.BslTranslationLogger;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.Pair;

public final class BslCommentClearableTextProcessor
extends BslCommentTextProcessor {
    private final DocCommentKeyComputer keyComputer;
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final IResourceLookup resourceLookup;
    private final IV8ProjectManager v8ProjectManager;
    private final IScopeProvider scopeProvider;
    private final MultiTextEdit edit;
    private final TranslatorProperties translatorProperties;
    private final boolean isMethodDescription;

    public BslCommentClearableTextProcessor(IFile file, FeatureKey featureKeyPreffix, BslDocumentationComment comment, List<INode> lines, MultiTextEdit edit, IProjectTranslationProvider translationProvider, Function<EObject, String> eObjectReplaceProvider, TranslatorProperties translatorProperties, BslTranslationLogger problemLogger, Method method, BmOperationContext typeComputationContext, DocCommentKeyComputer keyComputer, ITranslationFeatureKeyProvider featureKeyProvider, IResourceLookup resourceLookup, IV8ProjectManager v8ProjectManager, IScopeProvider scopeProvider) {
        super(file, featureKeyPreffix, comment, lines, edit, translationProvider, eObjectReplaceProvider, translatorProperties, problemLogger, method, typeComputationContext);
        this.edit = edit;
        this.translatorProperties = translatorProperties;
        this.isMethodDescription = BslCommentClearableTextProcessor.isMethodDescription(this.rootObject);
        this.keyComputer = keyComputer;
        this.featureKeyProvider = featureKeyProvider;
        this.resourceLookup = resourceLookup;
        this.v8ProjectManager = v8ProjectManager;
        this.scopeProvider = scopeProvider;
    }

    public BslCommentClearableTextProcessor(IFile file, EObject context, FeatureKey featureKeyPreffix, BslDocumentationComment comment, List<INode> lines, MultiTextEdit edit, IProjectTranslationProvider translationProvider, Function<EObject, String> eObjectReplaceProvider, TranslatorProperties translatorProperties, BslTranslationLogger problemLogger, BmOperationContext typeComputationContext, DocCommentKeyComputer keyComputer, ITranslationFeatureKeyProvider featureKeyProvider, IResourceLookup resourceLookup, IV8ProjectManager v8ProjectManager, IScopeProvider scopeProvider) {
        super(file, context, featureKeyPreffix, comment, lines, edit, translationProvider, eObjectReplaceProvider, translatorProperties, problemLogger, typeComputationContext, (Method)EcoreUtil2.getContainerOfType((EObject)context, Method.class));
        this.edit = edit;
        this.translatorProperties = translatorProperties;
        this.isMethodDescription = BslCommentClearableTextProcessor.isMethodDescription(this.rootObject);
        this.keyComputer = keyComputer;
        this.featureKeyProvider = featureKeyProvider;
        this.resourceLookup = resourceLookup;
        this.v8ProjectManager = v8ProjectManager;
        this.scopeProvider = scopeProvider;
    }

    @Override
    protected <T> void doProcess(DocCommentProcessor.Parent parent, T object, Class<T> clazz) {
        if (object instanceof TypeSection.FieldDefinition) {
            this.processReturnParam(parent, (TypeSection.FieldDefinition)object);
        } else {
            super.doProcess(parent, object, clazz);
        }
    }

    @Override
    protected void doProcessTranslatable(BslDocumentationComment.Description object, FeatureValue fv) {
        TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
        String translation = this.translationProvider.getStoredTranslation(fv.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNullOrEmpty((String)translation) && this.translatorProperties.clearMethodDescriptions() && this.isMethodDescription) {
            translation = "";
        } else if (StringUtils.isNullOrEmpty((String)translation) && !this.isMethodDescription) {
            translation = "";
        } else if (StringUtils.isNullOrEmpty((String)translation)) {
            return;
        }
        this.translateDocComment(object, translation, this.isMethodDescription);
    }

    @Override
    protected void replaceLinkPart(LinkPart link) {
        if (this.isRealLink(link)) {
            super.replaceLinkPart(link);
        } else if (link.getParent() instanceof TypeSection.TypeDefinition) {
            this.addReplace((INode)this.lines.get(link.getLineNumber()), link.getOffset(), link.getInitialContent(), "", false);
        }
    }

    @Override
    protected boolean isRealLink(LinkPart link) {
        if (link.getLinkText().startsWith("http")) {
            return true;
        }
        List<Pair> parts = link.getPartsWithOffset().stream().filter(p -> !((String)p.getFirst()).isBlank()).toList();
        boolean isObjectFound = false;
        int i = 0;
        while (i < parts.size()) {
            boolean isLastPart = i == parts.size() - 1;
            EObject obj = link.getActualObjectForPart(i, this.scopeProvider, this.context, this.v8ProjectManager, this.typeComputationContext);
            if (obj != null && !isObjectFound) {
                isObjectFound = true;
            } else if (isObjectFound && obj == null && isLastPart) {
                return false;
            }
            ++i;
        }
        return isObjectFound;
    }

    @Override
    protected void translateDocComment(BslDocumentationComment.Description object, String translation, boolean methodDescription) {
        String[] newParts = translation.replace("\r", "").split("\n", -1);
        List<IDescriptionPart> textParts = object.getParts().stream().filter(p -> p instanceof TextPart && !this.isSkipTextPart(object, (TextPart)p) || p instanceof LinkPart).collect(Collectors.toList());
        int index = 0;
        int currentLine = -1;
        index = this.processTextParts(object, translation, methodDescription, newParts, textParts, index, currentLine);
        this.processNewParts(newParts, textParts, index);
    }

    @Override
    protected void replaceTypes(TypeSection.TypeDefinition typeDef) {
        super.replaceTypes(typeDef);
        if (typeDef.getLinkToExtensionFields() != null) {
            this.addReplaceLinkPart(new String[0], 0, 0, (IDescriptionPart)typeDef.getLinkToExtensionFields(), false);
        }
    }

    private int processTextParts(BslDocumentationComment.Description object, String translation, boolean methodDescription, String[] newParts, List<IDescriptionPart> textParts, int index, int currentLine) {
        boolean firstPart = true;
        for (IDescriptionPart part : textParts) {
            if (part.getLineNumber() > this.lines.size()) continue;
            if (part instanceof TextPart) {
                TextPart textPart = (TextPart)part;
                if (textPart.getText().matches("/+")) continue;
                String replace = "";
                if (index < newParts.length && currentLine < part.getLineNumber()) {
                    replace = newParts[index];
                    ++index;
                }
                replace = this.processSectionDash(object, part, textPart, replace);
                int depOffset = 0;
                INode node = (INode)this.lines.get(part.getLineNumber());
                depOffset = this.processDeprecated(object, part, textPart, node, depOffset);
                if (StringUtils.isNullOrEmpty((String)translation) && !methodDescription && !textPart.getText().stripLeading().startsWith("-")) {
                    this.clearCodeComments(node, textPart);
                } else {
                    String text = node.getText().trim().replaceFirst("//", "").trim();
                    depOffset = this.replaceDeprecated(text, node.getOffset() + textPart.getOffset(), methodDescription);
                    this.addReplace(node, part.getOffset() + depOffset, textPart.getText(), replace, firstPart);
                }
            } else if (part instanceof LinkPart) {
                index = this.addReplaceLinkPart(newParts, index, currentLine, part, firstPart);
            }
            currentLine = part.getLineNumber();
            firstPart = false;
        }
        return index;
    }

    private String processSectionDash(BslDocumentationComment.Description object, IDescriptionPart part, TextPart textPart, String replace) {
        String text;
        if (object.getParts().indexOf(part) == 0 && !((String)replace).stripLeading().startsWith("-") && (text = textPart.getText()).stripLeading().startsWith("-")) {
            String preffix = text.substring(0, text.length() - text.stripLeading().substring(1).stripLeading().length());
            replace = preffix + ((String)replace).stripLeading();
        }
        return replace;
    }

    private int processDeprecated(BslDocumentationComment.Description object, IDescriptionPart part, TextPart textPart, INode node, int depOffset) {
        if (object.getParts().indexOf(part) == 0 && textPart.getText().startsWith("\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.") || textPart.getText().startsWith("Deprecated.")) {
            boolean isRu = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            String source = isRu ? "Deprecated." : "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.";
            String translation = !isRu ? "Deprecated." : "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.";
            depOffset = translation.length();
            textPart.setText(textPart.getText().trim().replaceFirst(source, ""));
        }
        return depOffset;
    }

    private void processNewParts(String[] newParts, List<IDescriptionPart> textParts, int index) {
        if (index < newParts.length && !textParts.isEmpty()) {
            String content;
            int defaulOffset = textParts.get(0).getOffset() - 2;
            IDescriptionPart lastPart = textParts.get(textParts.size() - 1);
            if (lastPart instanceof TextPart) {
                content = ((TextPart)lastPart).getText();
            } else if (lastPart instanceof LinkPart) {
                content = ((LinkPart)lastPart).getInitialContent();
            } else {
                return;
            }
            if (content.startsWith(" ")) {
                ++defaulOffset;
            }
            int lineNumber = lastPart.getLineNumber();
            INode node = (INode)this.lines.get(lineNumber);
            int lastOffset = node.getOffset() + node.getLength();
            int i = index;
            while (i < newParts.length) {
                String string = newParts[i];
                StringBuilder sb = new StringBuilder();
                sb.append("//");
                int j = 0;
                while (j < defaulOffset) {
                    sb.append(" ");
                    ++j;
                }
                sb.append(string);
                sb.append(System.lineSeparator());
                this.edit.addChild((TextEdit)new InsertEdit(lastOffset, sb.toString()));
                ++i;
            }
        }
    }

    private int addReplaceLinkPart(String[] newParts, int index, int currentLine, IDescriptionPart part, boolean firstPart) {
        LinkPart link = (LinkPart)part;
        if (this.isRealLink(link)) {
            return index;
        }
        String replace = "";
        if (index < newParts.length && currentLine < part.getLineNumber()) {
            replace = newParts[index];
            ++index;
        }
        INode node = (INode)this.lines.get(part.getLineNumber());
        this.addReplace(node, link.getOffset(), link.getInitialContent(), replace, firstPart);
        return index;
    }

    private void clearCodeComments(INode node, TextPart textPart) {
        int start = node.getTotalStartLine();
        String text = node.getText();
        int offset = node.getOffset();
        int length = node.getTotalLength();
        int shift = 0;
        if (start > 1 && text.endsWith(System.lineSeparator())) {
            shift = System.lineSeparator().length();
        } else if (start > 1 && text.endsWith("\n")) {
            shift = 1;
        }
        length -= shift;
        for (INode prev = node; prev != null && prev.hasPreviousSibling(); prev = prev.getPreviousSibling()) {
            int prevStart = prev.getTotalStartLine();
            String prevText = prev.getText();
            int prevEnd = prev.getTotalEndLine();
            if (!(prev instanceof ILeafNode) || !((ILeafNode)prev).isHidden()) break;
            if (prevEnd == start && prevStart == start) {
                offset = prev.getOffset();
                length += prev.getTotalLength();
                continue;
            }
            if (prevEnd == start && prevStart < start && prevText.equals(System.lineSeparator())) {
                offset -= System.lineSeparator().length();
                length += System.lineSeparator().length();
                break;
            }
            if (prevEnd == start && prevStart < start && prevText.equals("\n")) {
                offset -= "\n".length();
                length += "\n".length();
                break;
            }
            if (prevEnd != start || prevStart >= start || !BslCommentUtils.isCommentNode((ILeafNode)((ILeafNode)prev))) continue;
            length += shift;
            break;
        }
        this.addChild(node, textPart, text, offset, length);
    }

    private void addChild(INode node, TextPart textPart, String text, int offset, int length) {
        int targetLength;
        int targetOffset = textPart.getOffset() >= 2 ? node.getOffset() + textPart.getOffset() : offset;
        int n = targetLength = textPart.getOffset() >= 2 ? textPart.getText().length() : length;
        if (textPart.getOffset() > 2 && (text.contains("\u0421\u043c.") || text.contains("\u0441\u043c.") || text.contains("See") || text.contains("see") || textPart.getOffset() > 3)) {
            targetLength = textPart.getText().trim().length();
        }
        String source = text.trim().replaceFirst("//", "").trim();
        int depLength = this.replaceDeprecated(source, targetOffset, this.isMethodDescription);
        this.edit.addChild((TextEdit)new DeleteEdit(targetOffset += depLength, targetLength));
    }

    private int replaceDeprecated(String sourceText, int targetOffset, boolean methodDescription) {
        int length = 0;
        if (sourceText.startsWith("\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.") || sourceText.startsWith("Deprecated.")) {
            boolean isRu = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            String source = isRu ? "Deprecated." : "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.";
            String translated = !isRu ? "Deprecated." : "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.";
            String keyword = sourceText.substring(0, source.length());
            if (!methodDescription) {
                this.edit.addChild((TextEdit)new ReplaceEdit(targetOffset, keyword.length(), translated));
            }
            length = source.length();
        }
        return length;
    }

    private void processReturnParam(DocCommentProcessor.Parent parent, TypeSection.FieldDefinition field) {
        FeatureKey featureKeyPreffix;
        Method fieldMethod;
        if (StringUtils.isNullOrEmpty((String)field.getName()) || !this.keyComputer.isSupported(field)) {
            return;
        }
        FeatureKey key = this.keyComputer.getFeatureKey(parent, field);
        if (key != null) {
            key = key.append(BslCommentFeatureSettings.Literals.FIELD_DEFINITION__NAME.getName());
        }
        if (key == null || key.isEmpty()) {
            return;
        }
        String featureValue = field.getName();
        if (featureValue.startsWith("\"") && featureValue.endsWith("\"")) {
            featureValue = featureValue.substring(1, featureValue.length() - 1);
        }
        if ((fieldMethod = this.method) == null) {
            fieldMethod = (Method)EcoreUtil2.getContainerOfType((EObject)this.context, Method.class);
        }
        Module fieldModule = null;
        if (fieldMethod == null) {
            fieldModule = (Module)EcoreUtil2.getContainerOfType((EObject)this.context, Module.class);
        }
        if (fieldMethod != null) {
            featureKeyPreffix = this.featureKeyProvider.getKey((EObject)fieldMethod);
        } else if (fieldModule != null) {
            featureKeyPreffix = this.featureKeyProvider.getKey((EObject)fieldModule);
        } else {
            return;
        }
        FeatureKey featureKey = featureKeyPreffix.append(key);
        boolean computedValue = this.isComputedValue(parent, field);
        IFile resourceFile = this.resourceLookup.getPlatformResource(this.context);
        PersistableFeatureValue fv = new PersistableFeatureValue(resourceFile, featureKey, BslCommentFeatureSettings.Literals.FIELD_DEFINITION__NAME, featureValue, computedValue);
        String defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)this.context, (IV8ProjectManager)this.v8ProjectManager);
        fv.getLocalStrings().put(defaultLanguageCode, featureValue);
        TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
        String translation = this.translationProvider.getStoredTranslation((ContextTranslationKey)fv, language, new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNullOrEmpty((String)translation)) {
            INode node = (INode)this.lines.get(field.getLineNumber());
            int targetOffset = node.getOffset() + field.getNameOffset();
            this.edit.addChild((TextEdit)new DeleteEdit(targetOffset, field.getName().length()));
        } else {
            super.doProcess(parent, field, TypeSection.FieldDefinition.class);
        }
    }
}

