/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.LinkPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TagPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TextPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.BslContextDefMethod;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com._1c.g5.v8.dt.mcore.Parameter;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.metadata.mdclass.AbstractForm;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.comment.BslCommentFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypeContentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.AbstractBslCommentTextProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.BslDerivedPropertyCache;
import com.e1c.langtool.v8.dt.bsl.translator.BslTranslationLogger;
import com.e1c.langtool.v8.dt.bsl.translator.InternalizeCommentTermsProvider;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.Pair;

public class BslCommentTextProcessor
extends AbstractBslCommentTextProcessor {
    @Inject
    private InternalizeCommentTermsProvider internalizeCommentTermsProvider;
    @Inject
    private TypeContentProcessor typeContentProcessor;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    protected final EObject context;
    private final MultiTextEdit edit;
    private final TranslatorProperties translatorProperties;
    private final BslTranslationLogger problemLogger;
    private final boolean isMethodDescription;

    public BslCommentTextProcessor(IFile file, EObject context, FeatureKey featureKeyPreffix, BslDocumentationComment comment, List<INode> lines, MultiTextEdit edit, IProjectTranslationProvider translationProvider, Function<EObject, String> eObjectReplaceProvider, TranslatorProperties translatorProperties, BslTranslationLogger problemLogger, BmOperationContext typeComputationContext, Method method) {
        super(file, featureKeyPreffix, (IDescriptionPart)comment, lines, ICollectingParameters.DEFAULT, context, translationProvider, eObjectReplaceProvider, typeComputationContext, method);
        this.setAddAction(this::doProcessTranslatable);
        this.edit = edit;
        this.translatorProperties = translatorProperties;
        this.problemLogger = problemLogger;
        this.context = context;
        this.isMethodDescription = BslCommentTextProcessor.isMethodDescription(this.rootObject);
    }

    public BslCommentTextProcessor(IFile file, FeatureKey featureKeyPreffix, BslDocumentationComment comment, List<INode> lines, MultiTextEdit edit, IProjectTranslationProvider translationProvider, Function<EObject, String> eObjectReplaceProvider, TranslatorProperties translatorProperties, BslTranslationLogger problemLogger, Method method, BmOperationContext typeComputationContext) {
        super(file, featureKeyPreffix, (IDescriptionPart)comment, lines, ICollectingParameters.DEFAULT, translationProvider, eObjectReplaceProvider, method, typeComputationContext);
        this.setAddAction(this::doProcessTranslatable);
        this.edit = edit;
        this.translatorProperties = translatorProperties;
        this.problemLogger = problemLogger;
        this.context = method;
        this.isMethodDescription = BslCommentTextProcessor.isMethodDescription(this.rootObject);
    }

    @Override
    protected <T> void doProcess(DocCommentProcessor.Parent parent, T object, Class<T> clazz) {
        if (object instanceof BslDocumentationComment.ParametersSection) {
            this.replaceHeaderKeyword(parent, (BslDocumentationComment.Section)object);
        } else if (object instanceof BslDocumentationComment.ReturnSection) {
            this.replaceHeaderKeyword(parent, (BslDocumentationComment.Section)object);
        } else if (!(object instanceof TypeSection)) {
            if (object instanceof BslDocumentationComment.Section) {
                this.replaceHeaderKeyword(parent, (BslDocumentationComment.Section)object);
            } else if (object instanceof TypeSection.FieldDefinition && parent.getCurrent() instanceof BslDocumentationComment.ParametersSection) {
                this.replaceParameter((TypeSection.FieldDefinition)object);
            } else if (object instanceof TypeSection.FieldDefinition) {
                this.computeDerivedPropertyCache(parent, (TypeSection.FieldDefinition)object);
            } else if (object instanceof LinkPart) {
                this.replaceLinkPart((LinkPart)object);
            } else if (object instanceof TagPart) {
                this.replaceTags(parent, (TagPart)object);
            } else if (object instanceof TypeSection.TypeDefinition) {
                this.replaceTypes((TypeSection.TypeDefinition)object);
            } else if (object instanceof BslDocumentationComment) {
                this.replaceDeprecation((BslDocumentationComment)object);
            }
        }
        super.doProcess(parent, object, clazz);
    }

    /*
     * Unable to fully structure code
     */
    protected void replaceLinkPart(LinkPart link) {
        if (!this.isChangeScriptVariant() && !this.isChangeDefaultLanguage() || !this.isRealLink(link)) {
            return;
        }
        content = link.getInitialContent();
        linkText = link.getLinkText();
        node = (INode)this.lines.get(link.getLineNumber());
        isRussian = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        if (this.isChangeScriptVariant() && !StringUtils.isBlank((String)linkText)) {
            keyword = content.trim();
            if (keyword.startsWith("(")) {
                keyword = keyword.substring(1);
            }
            if (keyword.endsWith(")")) {
                keyword = keyword.substring(0, keyword.length() - 1);
            }
            if ((newKeyword = this.internalizeCommentTermsProvider.getInternalizeEnumValue(keyword = keyword.substring(0, keyword.length() - linkText.length()).trim(), isRussian)) == null && "See".equalsIgnoreCase(keyword)) {
                newKeyword = "\u0421\u043c.";
            } else if (newKeyword == null && "\u0421\u043c.".equalsIgnoreCase(keyword)) {
                newKeyword = "See";
            }
            if (StringUtils.isNotEmpty((String)newKeyword) && (offset = node.getText().indexOf(keyword, link.getOffset())) != -1) {
                this.addReplaceIfNotEmpty(node.getOffset() + offset, keyword, newKeyword, link);
            }
        }
        isSourceRu = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN) != false && this.isChangeScriptVariant() == false || this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.ENGLISH) != false && this.isChangeScriptVariant() != false;
        total = link.getPartsWithOffset().size();
        i = 0;
        while (i < total) {
            block32: {
                block33: {
                    block34: {
                        part = (Pair)link.getPartsWithOffset().get(i);
                        offset = node.getText().indexOf((String)part.getFirst(), (int)((Integer)part.getSecond()));
                        if (offset == -1) break block32;
                        if (i != 0 || !this.isChangeScriptVariant()) break block33;
                        first = link.getMdObjectFirstSegment(isSourceRu);
                        ref = (EReference)first.get(name = new CaseInsensitiveString((String)part.getFirst()));
                        if (ref == null) break block34;
                        entry = link.getMdObjectFirstSegment(isSourceRu == false).entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(org.eclipse.emf.ecore.EReference java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((EReference)ref)).findFirst();
                        if (entry.isPresent()) {
                            replace = ((CaseInsensitiveString)entry.get().getKey()).getString();
                            this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                        }
                        break block32;
                    }
                    manager = (EReference)link.getMdObjectManagers(isSourceRu).get(name);
                    if (manager == null) ** GOTO lbl-1000
                    entry = link.getMdObjectManagers(isSourceRu == false).entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(org.eclipse.emf.ecore.EReference java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((EReference)manager)).findFirst();
                    if (entry.isPresent()) {
                        replace = ((CaseInsensitiveString)entry.get().getKey()).getString();
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    }
                    break block32;
                }
                if (i == 2 && i + 1 < total && this.isChangeScriptVariant() && ("\u0424\u043e\u0440\u043c\u0430".equalsIgnoreCase((String)part.getFirst()) || "Form".equalsIgnoreCase((String)part.getFirst())) && link.getActualObjectForPart(i + 1, this.scopeProvider, this.context, this.v8ProjectManager, this.getTypeComputationContext()) instanceof AbstractForm) {
                    replace = isRussian != false ? "\u0424\u043e\u0440\u043c\u0430" : "Form";
                    this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                } else lbl-1000:
                // 2 sources

                {
                    if (!this.isChangeDefaultLanguage()) break;
                    object = link.getActualObjectForPart(i, this.scopeProvider, this.context, this.v8ProjectManager, this.getTypeComputationContext());
                    if (object instanceof AbstractForm) {
                        object = ((AbstractForm)object).getMdForm();
                    }
                    if (object != null) {
                        replace = this.getReplaceText(object);
                        source = (String)part.getFirst();
                        if (replace != null && replace.split("\\.").length == 2 && i == 1) {
                            firstPart = (Pair)link.getPartsWithOffset().get(0);
                            source = String.format("%s.%s", new Object[]{firstPart.getFirst(), part.getFirst()});
                            offset = (Integer)firstPart.getSecond();
                        }
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, source, replace, link);
                    } else if (i > 1 && ("\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b".equalsIgnoreCase((String)part.getFirst()) || "Items".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b" : "Items";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    } else if (i > 1 && ("\u041c\u0430\u043a\u0435\u0442".equalsIgnoreCase((String)part.getFirst()) || "Template".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u041c\u0430\u043a\u0435\u0442" : "Template";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    } else if (i > 1 && ("\u0422\u0430\u0431\u043b\u0438\u0446\u0430".equalsIgnoreCase((String)part.getFirst()) || "Table".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u0422\u0430\u0431\u043b\u0438\u0446\u0430" : "Table";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    } else if (i > 1 && ("\u041a\u0443\u0431".equalsIgnoreCase((String)part.getFirst()) || "Cube".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u041a\u0443\u0431" : "Cube";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    } else if (i > 1 && ("\u0422\u0430\u0431\u043b\u0438\u0446\u0430\u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f".equalsIgnoreCase((String)part.getFirst()) || "DimensionTable".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u0422\u0430\u0431\u043b\u0438\u0446\u0430\u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f" : "DimensionTable";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    } else if (i == 2 && ("\u0422\u0430\u0431\u043b\u0438\u0446\u044b".equalsIgnoreCase((String)part.getFirst()) || "Tables".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u0422\u0430\u0431\u043b\u0438\u0446\u044b" : "Tables";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    } else if (i == 2 && ("\u041a\u0443\u0431\u044b".equalsIgnoreCase((String)part.getFirst()) || "Cubes".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u041a\u0443\u0431\u044b" : "Cubes";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    } else if (i == 4 && ("\u0422\u0430\u0431\u043b\u0438\u0446\u044b\u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439".equalsIgnoreCase((String)part.getFirst()) || "DimensionTables".equalsIgnoreCase((String)part.getFirst()))) {
                        replace = isRussian != false ? "\u0422\u0430\u0431\u043b\u0438\u0446\u044b\u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439" : "DimensionTables";
                        this.addReplaceIfNotEmpty(node.getOffset() + offset, (String)part.getFirst(), replace, link);
                    }
                }
            }
            ++i;
        }
    }

    protected void replaceTypes(TypeSection.TypeDefinition typeDef) {
        if (!this.isChangeScriptVariant() && !this.isChangeDefaultLanguage()) {
            return;
        }
        INode node = (INode)this.lines.get(typeDef.getLineNumber());
        String typeName = typeDef.getTypeName().trim();
        if (!StringUtils.isBlank((String)typeName)) {
            int nameOffset = typeDef.getNameOffset();
            String text = node.getText();
            if (text.length() > nameOffset && text.indexOf(typeName, nameOffset) > nameOffset) {
                nameOffset = text.indexOf(typeName, nameOffset);
            }
            String newTypeName = this.typeContentProcessor.getTypeName(typeName, this.context, this.translationProvider);
            this.addReplaceIfNotEmpty(node.getOffset() + nameOffset, typeName, newTypeName, typeDef);
            if (this.isChangeScriptVariant() && !typeDef.getContainTypes().isEmpty()) {
                int start = nameOffset + typeName.length();
                TypeSection.TypeDefinition first = (TypeSection.TypeDefinition)typeDef.getContainTypes().get(0);
                int end = first.getNameOffset();
                if (first instanceof TypeSection.LinkContainsTypeDefinition) {
                    LinkPart link = ((TypeSection.LinkContainsTypeDefinition)first).getLink();
                    end = link.getOffset();
                }
                if (text.length() > end && end > start) {
                    String keywordOfContent = text.substring(start, end);
                    this.addReplaceKeyword(typeDef, node, keywordOfContent, start);
                }
            }
        }
        if (typeDef.getLinkToExtensionFields() != null) {
            this.replaceLinkPart(typeDef.getLinkToExtensionFields());
        }
    }

    protected void doProcessTranslatable(BslDocumentationComment.Description object, FeatureValue fv) {
        TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
        String translation = this.translationProvider.getStoredTranslation(fv.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNullOrEmpty((String)translation) && this.translatorProperties.clearMethodDescriptions() && this.isMethodDescription) {
            translation = "";
        } else if (StringUtils.isNullOrEmpty((String)translation)) {
            return;
        }
        this.translateDocComment(object, translation, this.isMethodDescription);
    }

    protected void doProcessTranslatable(TagPart object, FeatureValue fv) {
        if (fv.isTag()) {
            return;
        }
        TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
        String translation = this.translationProvider.getStoredTranslation(fv.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNullOrEmpty((String)translation) && this.translatorProperties.clearMethodDescriptions() && this.isMethodDescription) {
            translation = "";
        } else if (StringUtils.isNullOrEmpty((String)translation)) {
            return;
        }
        this.translateTagDescription(object, translation);
    }

    protected void translateDocComment(BslDocumentationComment.Description object, String translation, boolean methodDescription) {
        String[] newParts = translation.replace("\r", "").split("\n", -1);
        List textParts = object.getParts().stream().filter(p -> p instanceof TextPart && !this.isSkipTextPart(object, (TextPart)p) || p instanceof LinkPart && !this.isRealLink((LinkPart)p) || p instanceof TagPart).collect(Collectors.toList());
        int index = 0;
        int currentLine = -1;
        boolean firstPart = true;
        for (IDescriptionPart part : textParts) {
            if (part.getLineNumber() > this.lines.size()) continue;
            if (part instanceof TextPart) {
                String text;
                TextPart textPart = (TextPart)part;
                if (BslUtils.getTextWithoutSplashes(textPart.getText()).isEmpty()) continue;
                int depOffset = 0;
                if (object.getParts().indexOf(part) == 0 && (textPart.getText().toLowerCase().startsWith("\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.".toLowerCase()) || textPart.getText().toLowerCase().startsWith("Deprecated.".toLowerCase())) && this.isMethodDescription) {
                    boolean isRu = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
                    String keyword = textPart.getText().substring(0, isRu ? "Deprecated.".length() : "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.".length());
                    depOffset = keyword.length();
                    String newText = textPart.getText().substring(depOffset);
                    textPart.setText(newText);
                    if (textPart.getText().length() == 0) continue;
                }
                Object replace = "";
                if (index < newParts.length && currentLine < part.getLineNumber()) {
                    replace = newParts[index];
                    ++index;
                }
                if (object.getParts().indexOf(part) == 0 && !((String)replace).stripLeading().startsWith("-") && (text = textPart.getText()).stripLeading().startsWith("-")) {
                    String preffix = text.substring(0, text.length() - text.stripLeading().substring(1).stripLeading().length());
                    replace = preffix + ((String)replace).stripLeading();
                }
                INode node = (INode)this.lines.get(part.getLineNumber());
                this.addReplace(node, part.getOffset() + depOffset, textPart.getText(), (String)replace, firstPart);
            } else if (part instanceof LinkPart) {
                LinkPart link = (LinkPart)part;
                String replace = "";
                if (index < newParts.length && currentLine < part.getLineNumber()) {
                    replace = newParts[index];
                    ++index;
                }
                INode node = (INode)this.lines.get(part.getLineNumber());
                this.addReplace(node, part.getOffset(), link.getInitialContent(), replace, firstPart);
            }
            currentLine = part.getLineNumber();
            firstPart = false;
        }
        if (index < newParts.length && !textParts.isEmpty()) {
            int defaulOffset = ((IDescriptionPart)textParts.get(0)).getOffset() - 2;
            IDescriptionPart lastPart = (IDescriptionPart)textParts.get(textParts.size() - 1);
            if (lastPart instanceof TextPart) {
                if (((TextPart)lastPart).getText().startsWith(" ")) {
                    ++defaulOffset;
                }
                int lineNumber = lastPart.getLineNumber();
                INode node = (INode)this.lines.get(lineNumber);
                int lastOffset = node.getOffset() + node.getLength();
                int i = index;
                while (i < newParts.length) {
                    String string = newParts[i];
                    StringBuilder sb = new StringBuilder();
                    sb.append("//");
                    int j = 0;
                    while (j < defaulOffset) {
                        sb.append(" ");
                        ++j;
                    }
                    sb.append(string);
                    sb.append(System.lineSeparator());
                    this.edit.addChild((TextEdit)new InsertEdit(lastOffset, sb.toString()));
                    ++i;
                }
            }
        }
    }

    protected void translateTagDescription(TagPart part, String translation) {
        INode node = (INode)this.lines.get(part.getLineNumber());
        this.addReplace(node, part.getDescriptionOffset(), part.getDescription(), translation, true);
    }

    protected void addReplace(INode bslNode, int partOffset, String original, String replace, boolean firstPart) {
        int index;
        int length;
        int offset = bslNode.getOffset();
        if (offset + (length = bslNode.getLength()) < offset + partOffset + original.length()) {
            return;
        }
        if (original.length() < length) {
            length = original.length();
        }
        Object newReplace = replace;
        if (original.length() > 1 && replace.length() > 0) {
            if (original.startsWith("- ") && (replace.trim().length() < 1 || !replace.trim().substring(0, 1).equals("-"))) {
                newReplace = "- " + (String)newReplace;
            }
            if (original.startsWith(" ") && !replace.substring(0, 1).equals(" ")) {
                newReplace = " " + (String)newReplace;
            }
            if (original.endsWith(" ") && !replace.substring(replace.length() - 1).equals(" ")) {
                newReplace = (String)newReplace + " ";
            }
        }
        String nodeText = bslNode.getText().replace("//", "").trim();
        if (!(firstPart || nodeText.equals(original) || nodeText.startsWith(original) || (index = nodeText.indexOf(original)) <= 0 || nodeText.charAt(index - 1) != ' ' || this.hasOverlapping((TextEdit)this.edit, offset + partOffset - 1, length + 1))) {
            ++length;
            --partOffset;
        }
        if (!original.equals(newReplace)) {
            try {
                this.edit.addChild((TextEdit)new ReplaceEdit(offset + partOffset, length, (String)newReplace));
            }
            catch (MalformedTreeException e) {
                String message = MessageFormat.format("Cannot translate string literal: {0}", EcoreUtil.getURI((EObject)this.context));
                BslPlugin.log(BslPlugin.createErrorStatus(message, e));
            }
            if (BslPlugin.getDefault().isDebugging()) {
                System.out.println(original + " = " + (String)newReplace);
            }
        }
    }

    protected static boolean isMethodDescription(Object rootObject) {
        if (rootObject instanceof BslDocumentationComment) {
            return ((BslDocumentationComment)rootObject).getMethod() != null;
        }
        return false;
    }

    private boolean hasOverlapping(TextEdit parent, int offset2, int length2) {
        TextEdit[] textEditArray = parent.getChildren();
        int n = textEditArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit edit1 = textEditArray[n2];
            int offset1 = edit1.getOffset();
            int length1 = edit1.getLength();
            if ((offset1 != offset2 || length1 != 0 || length2 != 0) && offset1 + length1 > offset2 && offset2 + length2 > offset1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addReplaceIfNotEmpty(int offset, String source, String replace, Object contex) {
        if (StringUtils.isNotEmpty((String)replace) && !source.equals(replace)) {
            this.edit.addChild((TextEdit)new ReplaceEdit(offset, source.length(), replace));
        }
        if (this.problemLogger != null && !this.lines.isEmpty()) {
            this.problemLogger.logDocComment(offset, source, replace, contex, (INode)this.lines.get(this.lines.size() - 1));
        }
    }

    private void replaceHeaderKeyword(DocCommentProcessor.Parent parent, BslDocumentationComment.Section section) {
        boolean isRussian;
        INode node = (INode)this.lines.get(section.getLineNumber());
        if (node.getOffset() < 0) {
            return;
        }
        String keyword = node.getText().substring(section.getOffset(), section.getOffset() + section.getHeaderKeywordLength());
        String newKeyword = this.internalizeCommentTermsProvider.getInternalizeEnumValue(keyword, isRussian = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN));
        if (StringUtils.isNotEmpty((String)newKeyword)) {
            this.edit.addChild((TextEdit)new ReplaceEdit(node.getOffset() + section.getOffset(), section.getHeaderKeywordLength(), newKeyword));
        }
    }

    private void replaceParameter(TypeSection.FieldDefinition field) {
        if (!this.isChangeDefaultLanguage()) {
            return;
        }
        String name = field.getName();
        Optional<FormalParam> param = this.method.getFormalParams().stream().filter(p -> p.getName().equalsIgnoreCase(name)).findFirst();
        if (param.isPresent()) {
            URI objectUri = EcoreUtil.getURI((EObject)((EObject)param.get()));
            Provider provider = () -> {
                FormalParam object = (FormalParam)param.get();
                return Optional.ofNullable((String)this.eObjectReplaceProvider.apply(object)).orElse(object.getName());
            };
            ModelNameTranslationCache cache = (ModelNameTranslationCache)this.translationProvider.getCache(ModelNameTranslationCache.class);
            String translation = cache.getTranslation(objectUri, provider);
            INode node = (INode)this.lines.get(field.getLineNumber());
            this.addReplaceIfNotEmpty(node.getOffset() + field.getNameOffset(), name, translation, field);
        }
    }

    private void replaceDeprecation(BslDocumentationComment comment) {
        if (!this.isChangeScriptVariant() || !comment.isDeprecated()) {
            return;
        }
        BslDocumentationComment.Description description = comment.getDescription();
        List parts = description.getParts();
        for (IDescriptionPart part : parts) {
            if (!(part instanceof TextPart) || ((TextPart)part).getText().isEmpty()) continue;
            boolean isRussian = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            String keyword = ((TextPart)part).getText().substring(0, isRussian ? "Deprecated.".length() : "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.".length());
            String newKeyword = isRussian ? "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430." : "Deprecated.";
            INode node = (INode)this.lines.get(comment.getLineNumber());
            int offset = "//".length() + "\n".length() + node.getOffset();
            this.addReplaceIfNotEmpty(offset, keyword, newKeyword, comment);
            break;
        }
    }

    private void replaceTags(DocCommentProcessor.Parent parent, TagPart tagPart) {
        INode node;
        int offset;
        String name = tagPart.getTagName();
        TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
        IFile file = this.resourceLookup.getPlatformResource(this.context);
        boolean computedValue = StringUtils.isNotWord((String)name);
        FeatureKey commonFeatureKeyPreffix = this.featureKeyProvider.getKey(this.context).append(BslCommentFeatureSettings.Literals.COMMENT__TAG_NAME.getName()).append(name);
        FeatureKey featureKey = commonFeatureKeyPreffix.append(BslCommentFeatureSettings.Literals.FIELD_DEFINITION__NAME.getName());
        PersistableFeatureValue featureValue = new PersistableFeatureValue(file, featureKey, BslCommentFeatureSettings.Literals.COMMENT__TAG_NAME, name, computedValue, false, true);
        featureValue.getLocalStrings().put(language.getLanguageCode(), name);
        String translation = this.translationProvider.getStoredTranslation(featureValue.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNotEmpty((String)translation) && (offset = (node = (INode)this.lines.get(tagPart.getLineNumber())).getText().indexOf(name, tagPart.getOffset())) != -1) {
            this.addReplaceIfNotEmpty(node.getOffset() + offset, name, translation, tagPart);
        }
        this.replaceTagParams(tagPart, language, file);
    }

    private void replaceTagParams(TagPart object, TranslateLanguage language, IFile file) {
        for (String param : object.getParameters()) {
            INode node;
            int offset;
            boolean computedValue = StringUtils.isNotWord((String)param);
            FeatureKey commonFeatureKeyPreffix = this.featureKeyProvider.getKey(this.context).append(BslCommentFeatureSettings.Literals.COMMENT__TAG_PARAM.getName()).append(param);
            FeatureKey featureKey = commonFeatureKeyPreffix.append(BslCommentFeatureSettings.Literals.FIELD_DEFINITION__NAME.getName());
            PersistableFeatureValue featureValue = new PersistableFeatureValue(file, featureKey, BslCommentFeatureSettings.Literals.COMMENT__TAG_PARAM, param, computedValue, false, true);
            String translation = this.translationProvider.getStoredTranslation(featureValue.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
            if (!StringUtils.isNotEmpty((String)translation) || (offset = (node = (INode)this.lines.get(object.getLineNumber())).getText().indexOf(param, object.getOffset())) == -1) continue;
            this.addReplaceIfNotEmpty(node.getOffset() + offset, param, translation, object);
        }
    }

    private void addReplaceKeyword(TypeSection.TypeDefinition typeDef, INode node, String keywordText, int keywordStartOffset) {
        String keyword = keywordText.trim();
        if ("of".equalsIgnoreCase(keyword) || "\u0438\u0437".equalsIgnoreCase(keyword)) {
            boolean isRussian = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            String newKeyword = isRussian ? "\u0438\u0437" : "of";
            int shift = keywordText.indexOf(keyword);
            int offset = node.getOffset() + keywordStartOffset + shift;
            this.addReplaceIfNotEmpty(offset, keyword, newKeyword, typeDef);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doProcessTranslatable(Object object, FeatureValue fv) {
        if (!this.isChangeDefaultLanguage() && !this.isChangeScriptVariant()) {
            return;
        }
        if (object instanceof BslDocumentationComment.Description) {
            this.doProcessTranslatable((BslDocumentationComment.Description)object, fv);
        } else if (object instanceof TypeSection.FieldDefinition) {
            this.doProcessTranslatable((TypeSection.FieldDefinition)object, fv);
        } else {
            Object object2 = object;
            if (object2 instanceof TagPart) {
                void tagPart;
                TagPart tagPart2 = (TagPart)object2;
                TagPart cfr_ignored_0 = (TagPart)object2;
                this.doProcessTranslatable((TagPart)tagPart, fv);
            }
        }
    }

    private void doProcessTranslatable(TypeSection.FieldDefinition object, FeatureValue fv) {
        Object translation;
        if (this.method == null) {
            return;
        }
        BslDerivedPropertyCache cache = (BslDerivedPropertyCache)this.translationProvider.getCache(BslDerivedPropertyCache.class);
        String content = object.getName();
        String name = content.startsWith("\"") && content.endsWith("\"") ? content.substring(1, content.length() - 1) : content;
        Provider provider = () -> {
            TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
            String translation = this.translationProvider.getStoredTranslation(fv.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
            Optional<String> value = Optional.ofNullable(translation);
            return value.orElse(name);
        };
        INode node = (INode)this.lines.get(object.getLineNumber());
        ICompositeNode methodNode = NodeModelUtils.findActualNodeFor((EObject)this.method);
        int localOffset = node.getOffset() - methodNode.getTotalOffset() + object.getNameOffset();
        URI uri = EcoreUtil.getURI((EObject)this.module);
        if (fv.isComputedValue()) {
            TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
            String translation2 = this.translationProvider.getStoredTranslation(fv.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT});
            if (StringUtils.isNotEmpty((String)translation2)) {
                cache.putTranslation(uri.toString(), this.method.getName(), localOffset, translation2);
            }
        }
        if (StringUtils.isNullOrEmpty((String)(translation = cache.getTranslation(uri, this.method.getName(), localOffset, (Provider<String>)provider))) || name.equals(translation)) {
            return;
        }
        if (content.startsWith("\"") && content.endsWith("\"") && !((String)translation).startsWith("\"") && !((String)translation).endsWith("\"")) {
            translation = "\"" + (String)translation + "\"";
        }
        this.addReplaceIfNotEmpty(node.getOffset() + object.getNameOffset(), content, (String)translation, object);
    }

    private String getReplaceText(EObject object) {
        if (object instanceof MdObject) {
            return this.getReplaceText((MdObject)object);
        }
        if (object instanceof BslContextDefMethod) {
            return this.getReplaceText((BslContextDefMethod)object);
        }
        if (object instanceof Parameter) {
            return this.getReplaceText((Parameter)object);
        }
        if (object instanceof Property) {
            return this.getReplaceText((Property)object);
        }
        if (object instanceof DuallyNamedElement) {
            return this.getReplaceText((DuallyNamedElement)object);
        }
        if (object instanceof NamedElement) {
            return this.getReplaceText((NamedElement)object);
        }
        return (String)this.eObjectReplaceProvider.apply(object);
    }

    private String getReplaceText(MdObject object) {
        URI objectUri = EcoreUtil.getURI((EObject)object);
        Provider provider = () -> Optional.ofNullable((String)this.eObjectReplaceProvider.apply(object)).orElse(object.getName());
        ModelNameTranslationCache cache = (ModelNameTranslationCache)this.translationProvider.getCache(ModelNameTranslationCache.class);
        return cache.getTranslation(objectUri, provider);
    }

    private String getReplaceText(BslContextDefMethod object) {
        URI objectUri = object.getSourceUri();
        Provider provider = () -> Optional.ofNullable((String)this.eObjectReplaceProvider.apply(object)).orElse(object.getName());
        ModelNameTranslationCache cache = (ModelNameTranslationCache)this.translationProvider.getCache(ModelNameTranslationCache.class);
        return cache.getTranslation(objectUri, provider);
    }

    private String getReplaceText(Parameter object) {
        URI objectUri = EcoreUtil.getURI((EObject)object);
        Provider provider = () -> Optional.ofNullable((String)this.eObjectReplaceProvider.apply(object)).orElse(object.getName());
        ModelNameTranslationCache cache = (ModelNameTranslationCache)this.translationProvider.getCache(ModelNameTranslationCache.class);
        return cache.getTranslation(objectUri, provider);
    }

    private String getReplaceText(Property object) {
        if (object instanceof DerivedProperty && ((DerivedProperty)object).getSource() != null) {
            return this.getReplaceText(((DerivedProperty)object).getSource());
        }
        return this.getReplaceText((DuallyNamedElement)object);
    }

    private String getReplaceText(DuallyNamedElement object) {
        String translation;
        if (object.getName().equalsIgnoreCase(object.getNameRu())) {
            translation = this.getReplaceText((NamedElement)object);
        } else {
            boolean isRu = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            translation = isRu ? object.getNameRu() : object.getName();
            String[] parts = translation.split("\\.");
            if (parts.length == 2) {
                translation = this.translateLastSegment(parts, object);
            }
        }
        return translation;
    }

    private String translateLastSegment(String[] parts, DuallyNamedElement object) {
        String lastSegment = parts[parts.length - 1];
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)object, MdObject.class);
        if (mdObject != null) {
            String replace = this.getReplaceText(mdObject);
            if (!StringUtils.isBlank((String)lastSegment) && !lastSegment.equals(replace)) {
                parts[parts.length - 1] = replace;
            }
        }
        return String.join((CharSequence)".", parts);
    }

    private String getReplaceText(NamedElement object) {
        URI objectUri = EcoreUtil.getURI((EObject)object);
        Provider provider = () -> Optional.ofNullable((String)this.eObjectReplaceProvider.apply(object)).orElse(object.getName());
        ModelNameTranslationCache cache = (ModelNameTranslationCache)this.translationProvider.getCache(ModelNameTranslationCache.class);
        return cache.getTranslation(objectUri, provider);
    }

    private boolean isChangeDefaultLanguage() {
        return this.translationProvider.getProject().isChangeDefaultLanguage();
    }

    private boolean isChangeScriptVariant() {
        return this.translationProvider.getProject().isChangeScriptVariant();
    }

    private static /* synthetic */ boolean lambda$2(EReference eReference, Map.Entry e) {
        return ((EReference)e.getValue()).equals(eReference);
    }

    private static /* synthetic */ boolean lambda$3(EReference eReference, Map.Entry e) {
        return ((EReference)e.getValue()).equals(eReference);
    }
}

