/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bsl.model.BslContextDefPackage;
import com._1c.g5.v8.dt.bsl.model.SourceObjectLinkProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.translator.DuallyNamedElementNameProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BslContextDefMethodOrPropertyNamedProvider
extends DuallyNamedElementNameProvider {
    private final INamedEObjectNameProvider namedEObjectNameProvider;
    private final IBmModelManager modelManager;

    @Inject
    public BslContextDefMethodOrPropertyNamedProvider(IV8ProjectManager v8ProjectManager, INamedEObjectNameProvider namedEObjectNameProvider, IBmModelManager modelManager) {
        super(v8ProjectManager);
        this.namedEObjectNameProvider = namedEObjectNameProvider;
        this.modelManager = modelManager;
    }

    public @Nullable Pair<String, String> getTranslatedName(@Nullable EObject object, @NonNull IProjectTranslationProvider translationProvider) {
        if (object instanceof SourceObjectLinkProvider) {
            SourceObjectLinkProvider named = (SourceObjectLinkProvider)object;
            String name = this.getName(object);
            URI objectUri = named.getSourceUri();
            Provider provider = () -> {
                Pair translation;
                IBmModel model = this.modelManager.getModel(objectUri);
                if (model != null) {
                    Pair translation2;
                    EObject source = model.getEngine().resolve(objectUri, EcorePackage.Literals.EOBJECT);
                    if (source != null && source.eIsProxy()) {
                        source = EcoreUtil.resolve((EObject)source, (EObject)object);
                    }
                    if (source != null && (translation2 = this.namedEObjectNameProvider.getTranslatedName(source, translationProvider)) != null && ((String)translation2.getKey()).equalsIgnoreCase(name)) {
                        return (String)translation2.getValue();
                    }
                }
                if ((translation = super.getTranslatedName(object, translationProvider)) != null) {
                    return (String)translation.getValue();
                }
                return name;
            };
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            String translation = cache.getTranslation(objectUri, provider);
            if (StringUtils.isBlank((String)translation)) {
                return super.getTranslatedName(object, translationProvider);
            }
            return new Pair((Object)name, (Object)translation);
        }
        return null;
    }

    public @NonNull Collection<EClass> getSupportEClass() {
        return List.of(BslContextDefPackage.Literals.BSL_CONTEXT_DEF_METHOD, BslContextDefPackage.Literals.BSL_CONTEXT_DEF_PROPERTY);
    }

    public int order() {
        return 4000;
    }

    public Collection<EClass> orderBeforeEClass() {
        return List.of(McorePackage.Literals.DUALLY_NAMED_ELEMENT, McorePackage.Literals.NAMED_ELEMENT);
    }
}

