/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslCommentUtils;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.DescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.LinkPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TextPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.Block;
import com._1c.g5.v8.dt.bsl.model.DeclareStatement;
import com._1c.g5.v8.dt.bsl.model.ForEachStatement;
import com._1c.g5.v8.dt.bsl.model.ForToStatement;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.typesystem.util.TypeSystemUtil;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class BslDocCommentParser {
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final IScopeProvider scopeProvider;
    private final IQualifiedNameConverter qualifiedNameConverter;
    private final IResourceLookup resourceLookup;
    private final BslPreferences preferences;

    @Inject
    public BslDocCommentParser(IQualifiedNameConverter qualifiedNameConverter, ITranslationFeatureKeyProvider featureKeyProvider, IResourceLookup resourceLookup, BslPreferences preferences) {
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        this.scopeProvider = (IScopeProvider)rsp.get(IScopeProvider.class);
        this.featureKeyProvider = featureKeyProvider;
        this.qualifiedNameConverter = qualifiedNameConverter;
        this.resourceLookup = resourceLookup;
        this.preferences = preferences;
    }

    public BslDocumentationComment parse(List<INode> nodes, boolean isOldCommentFormat) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        List<String> text = BslUtils.getCommentLines(nodes);
        Variable variable = BslUtils.getCommentNodeVariable((ILeafNode)nodes.get(0));
        EObject parent = this.getVariableParent(variable);
        boolean isDocComment = parent != null;
        boolean dashAdded = this.addDashSymbol(text, isDocComment);
        this.addReturnsStatement(nodes, text, isDocComment);
        BslDocumentationComment comment = BslCommentUtils.parseTemplateComment(text, (boolean)isOldCommentFormat);
        if (variable != null && this.isCommentHasIncorrectReturnTypes(comment, (EObject)variable)) {
            this.restoreCommentDescription(comment, text, (EObject)variable);
        }
        if (dashAdded) {
            this.removeLastDashInCommentDescription(comment);
            this.removeLastDashInReturnDesctription(comment);
        }
        return comment;
    }

    public boolean isCommentStartsWithAtSymbol(List<String> text, int contentIdx) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (text.isEmpty()) {
            return false;
        }
        return text.get(contentIdx).replace("//", "").trim().startsWith("@");
    }

    public void removeReturnsStatement(List<String> text) {
        if (text.size() > 1 && this.isStartsWithReturns(text)) {
            text.remove(0);
        }
    }

    public boolean isCommentHasIncorrectReturnTypes(BslDocumentationComment comment, EObject context) {
        BslDocumentationComment.ReturnSection returnSection = comment.getReturnSection();
        if (returnSection == null) {
            return false;
        }
        List returnTypes = returnSection.getReturnTypes();
        if (this.isCommentHasIncorrectReturnDescription(comment, returnSection, returnTypes)) {
            return true;
        }
        return this.isReturnTypesIncorrect(returnTypes, context);
    }

    public void restoreCommentDescription(BslDocumentationComment comment, List<String> text, EObject context) {
        BslDocumentationComment.Description description = comment.getDescription();
        if (!description.getParts().isEmpty()) {
            return;
        }
        IProject project = this.resourceLookup.getProject(context);
        if (project == null) {
            return;
        }
        BslDocumentationComment.ReturnSection returnSection = comment.getReturnSection();
        List types = returnSection.getReturnTypes();
        TranslatorProperties properties = this.preferences.getTranslatorProperties(project);
        if (properties.isReplaceUnknownTypesInDocumentationComment() && !this.typeDefinitionsHasWhitespaces(types)) {
            return;
        }
        this.removeReturnsStatement(text);
        List descriptionParts = returnSection.getDescription().getParts();
        int lineIdx = 0;
        while (lineIdx < text.size()) {
            boolean isTypesEmpty;
            int offset = 0;
            if (!types.isEmpty()) {
                offset = ((TypeSection)types.get(0)).getOffset();
            }
            if (offset == 0 && lineIdx < descriptionParts.size()) {
                offset = ((IDescriptionPart)descriptionParts.get(lineIdx)).getOffset();
            }
            String original = text.get(lineIdx);
            String line = original.replace("//", "").trim();
            int lineNumber = lineIdx + 1;
            Triple trimLine = BslCommentUtils.trim((String)original.substring("//".length(), original.length()));
            trimLine = Tuples.create((Object)((String)trimLine.getFirst()), (Object)((Integer)trimLine.getSecond() + "//".length()), (Object)((Integer)trimLine.getThird()));
            boolean startWithDash = line.startsWith("-");
            boolean bl = isTypesEmpty = comment.getReturnSection() != null && comment.getReturnSection().getReturnTypes().isEmpty();
            if (startWithDash && !isTypesEmpty && (Integer)trimLine.getSecond() < offset) {
                offset = (Integer)trimLine.getSecond();
            }
            TextPart part = new TextPart((IDescriptionPart)description, lineNumber, offset, line);
            description.addPart((DescriptionPart)part);
            ++lineIdx;
        }
        returnSection.getReturnTypes().clear();
        descriptionParts.clear();
        this.removeLastDashInCommentDescription(comment);
    }

    public FeatureKey getVariableFeatureKey(EObject owner, EObject variable, Map<Variable, Block> blockVariables, String keyPreffix) {
        FeatureKey featureKey;
        if (variable == null) {
            return this.featureKeyProvider.getKey(owner);
        }
        Block block = (Block)EcoreUtil2.getContainerOfType((EObject)owner, Block.class);
        if (blockVariables.containsKey(variable) && blockVariables.get(variable).equals(block) || !this.isFirstVariableComment(variable)) {
            Method method = (Method)EcoreUtil2.getContainerOfType((EObject)owner, Method.class);
            if (method != null) {
                featureKey = this.featureKeyProvider.getKey((EObject)method).append("Comment");
                if (!keyPreffix.isEmpty()) {
                    featureKey = featureKey.append(keyPreffix);
                }
            } else {
                featureKey = this.featureKeyProvider.getKey(variable).append("Comment");
                if (!keyPreffix.isEmpty()) {
                    featureKey = featureKey.append(keyPreffix);
                }
            }
        } else {
            featureKey = this.featureKeyProvider.getKey(variable);
            if (featureKey == null) {
                featureKey = this.featureKeyProvider.getKey(owner);
            }
            if (variable != null) {
                blockVariables.put((Variable)variable, block);
            }
        }
        return featureKey;
    }

    public boolean isCommentStartWithDash(List<String> commentContent) {
        int dashPosition;
        if (commentContent.size() < 2) {
            return false;
        }
        String line = commentContent.get(1);
        boolean startWithDash = (line = line.substring(2, line.length()).trim()).startsWith("-");
        int n = dashPosition = startWithDash ? line.indexOf("-", 1) : line.indexOf("-");
        if (dashPosition != -1) {
            return false;
        }
        return startWithDash;
    }

    private boolean typeDefinitionsHasWhitespaces(List<TypeSection> types) {
        for (TypeSection type : types) {
            for (TypeSection.TypeDefinition definition : type.getTypeDefinitions()) {
                String[] splitted;
                String[] stringArray = splitted = definition.getTypeName().split(",");
                int n = splitted.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeName = stringArray[n2];
                    Matcher matcher = Pattern.compile("\\s").matcher(typeName);
                    if (matcher.find()) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private boolean isFirstVariableComment(EObject variable) {
        if (!(variable instanceof Variable)) {
            return false;
        }
        EObject parent = this.getVariableParent((Variable)variable);
        Block block = (Block)EcoreUtil2.getContainerOfType((EObject)variable, Block.class);
        if (block == null) {
            return false;
        }
        ICompositeNode blockNode = NodeModelUtils.findActualNodeFor((EObject)block);
        if (blockNode == null) {
            return false;
        }
        List commentContent = TypeSystemUtil.getCommentAfterObject((EObject)parent, (INode)blockNode, (boolean)false);
        return commentContent != null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isReturnTypesIncorrect(List<TypeSection> returnTypes, EObject context) {
        IScope scope = this.scopeProvider.getScope(context, McorePackage.Literals.TYPE_DESCRIPTION__TYPES);
        for (TypeSection section : returnTypes) {
            List definitions = section.getTypeDefinitions();
            if (definitions.isEmpty()) {
                return true;
            }
            for (TypeSection.TypeDefinition definition : definitions) {
                void linkContains;
                TypeSection.TypeDefinition typeDefinition;
                QualifiedName fqn;
                String typeName = definition.getTypeName();
                if (StringUtils.isNotEmpty((String)typeName)) {
                    fqn = this.qualifiedNameConverter.toQualifiedName(typeName);
                    IEObjectDescription obj = scope.getSingleElement(fqn);
                    if (obj == null) {
                        return true;
                    }
                    TypeItem type = (TypeItem)EcoreUtil.resolve((EObject)obj.getEObjectOrProxy(), (EObject)context);
                    if (type.getName() == null) {
                        return true;
                    }
                }
                if (!((typeDefinition = definition) instanceof TypeSection.LinkContainsTypeDefinition)) continue;
                fqn = (TypeSection.LinkContainsTypeDefinition)typeDefinition;
                TypeSection.LinkContainsTypeDefinition cfr_ignored_0 = (TypeSection.LinkContainsTypeDefinition)typeDefinition;
                LinkPart link = linkContains.getLink();
                return this.isHttpLink(link);
            }
        }
        return false;
    }

    private boolean isHttpLink(LinkPart link) {
        return link.getLinkText().stripLeading().startsWith("http");
    }

    private boolean isCommentHasIncorrectReturnDescription(BslDocumentationComment comment, BslDocumentationComment.ReturnSection returnSection, List<TypeSection> returnTypes) {
        return returnTypes.isEmpty() && comment.getDescription().getParts().isEmpty() && !returnSection.getDescription().getParts().isEmpty() && returnSection.getDescription().getParts().stream().noneMatch(p -> p.getClass().equals(LinkPart.class));
    }

    private void removeLastDashInCommentDescription(BslDocumentationComment comment) {
        List parts = comment.getDescription().getParts();
        if (parts.isEmpty()) {
            return;
        }
        int lastIdx = parts.size() - 1;
        if (!(parts.get(lastIdx) instanceof TextPart)) {
            return;
        }
        this.replaceLastPartDescription(parts, lastIdx, (IDescriptionPart)comment.getDescription());
    }

    private void removeLastDashInReturnDesctription(BslDocumentationComment comment) {
        List descriptionParts = comment.getDescription().getParts();
        if (!descriptionParts.isEmpty()) {
            return;
        }
        List returnParts = comment.getReturnSection().getReturnTypes();
        if (returnParts.isEmpty()) {
            return;
        }
        for (TypeSection returnPart : returnParts) {
            int lastIdx;
            List parts = returnPart.getDescription().getParts();
            if (parts.isEmpty() || !(parts.get(lastIdx = parts.size() - 1) instanceof TextPart)) continue;
            this.replaceLastPartDescription(parts, lastIdx, (IDescriptionPart)returnPart.getDescription());
        }
    }

    private void replaceLastPartDescription(List<IDescriptionPart> parts, int lastIdx, IDescriptionPart parent) {
        TextPart lastPart = (TextPart)parts.get(lastIdx);
        String text = lastPart.getText();
        if (text.trim().endsWith("-")) {
            text = new StringBuilder(text.trim()).reverse().replace(0, 1, "").reverse().toString();
            TextPart newPart = new TextPart(parent, lastPart.getLineNumber(), lastPart.getOffset(), text);
            parts.set(lastIdx, (IDescriptionPart)newPart);
        }
    }

    private boolean isStartsWithReturns(List<String> text) {
        if (text.isEmpty()) {
            return false;
        }
        return text.get(0).equals("//Returns:") || text.get(0).equals("//\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:");
    }

    private EObject getVariableParent(Variable object) {
        Variable e = object;
        while (e != null) {
            if (e instanceof ForEachStatement || e instanceof DeclareStatement || e instanceof ForToStatement || e instanceof StaticFeatureAccess || e instanceof SimpleStatement) {
                return e;
            }
            if (e instanceof Method) {
                return null;
            }
            e = e.eContainer();
        }
        return null;
    }

    private boolean addDashSymbol(List<String> text, boolean isDocComment) {
        String comment;
        boolean dashAdded = false;
        if (isDocComment && !StringUtils.isBlank((String)(comment = text.stream().map(s -> s.replaceFirst("//", "")).collect(Collectors.joining(" ")))) && comment.split(",").length > 1 && !comment.contains("-")) {
            int lastIdx = text.size() - 1;
            text.set(lastIdx, text.get(lastIdx) + "-");
            dashAdded = true;
        }
        return dashAdded;
    }

    private void addReturnsStatement(List<INode> lines, List<String> text, boolean isDocComment) {
        if (isDocComment && !this.isCommentStartsWithAtSymbol(text, 0)) {
            String textReturn = "//Returns:";
            lines.add(0, (INode)new VirturalHiddenLeadNode(textReturn));
            text.add(0, textReturn);
        }
    }

    private final class VirturalCompositeNode
    extends CompositeNode {
        private final String text;

        VirturalCompositeNode(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public ICompositeNode getRootNode() {
            return this;
        }

        public int getOffset() {
            return -1;
        }

        public int getStartLine() {
            return -1;
        }
    }

    private final class VirturalHiddenLeadNode
    extends HiddenLeafNode {
        private final String text;

        VirturalHiddenLeadNode(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public int getOffset() {
            return -1;
        }

        public int getStartLine() {
            return -1;
        }

        public ICompositeNode getRootNode() {
            return new VirturalCompositeNode(this.text);
        }
    }
}

