/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.common.IModuleExtensionService;
import com._1c.g5.v8.dt.bsl.common.IModuleExtensionServiceProvider;
import com._1c.g5.v8.dt.bsl.contextdef.IBslModuleContextDefService;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.Pragma;
import com._1c.g5.v8.dt.bsl.util.BslUtil;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class ExtensionModulePragmaValueProvider {
    private final INamedEObjectNameProvider namedEObjectNameProvider;
    private final IModuleExtensionService moduleExtensionService;
    private final IBslModuleContextDefService contextDefService;

    @Inject
    public ExtensionModulePragmaValueProvider(INamedEObjectNameProvider namedEObjectNameProvider, IBslModuleContextDefService contextDefService) {
        this.namedEObjectNameProvider = namedEObjectNameProvider;
        this.moduleExtensionService = IModuleExtensionServiceProvider.INSTANCE.getModuleExtensionService();
        this.contextDefService = contextDefService;
    }

    public String getTranslation(Pragma pragma, @NonNull IProjectTranslationProvider translationProvider) {
        String handlerName;
        Event event;
        Method extentionMethod = (Method)EcoreUtil2.getContainerOfType((EObject)pragma, Method.class);
        Map methods = this.moduleExtensionService.getSourceMethod(extentionMethod);
        Method sourceMethod = (Method)methods.get(pragma);
        if (sourceMethod != null) {
            String replace = this.getReplaceText(sourceMethod, translationProvider);
            if (StringUtils.isNotEmpty((String)replace)) {
                return "\"" + replace + "\"";
            }
        } else if (extentionMethod.isEvent() && (event = this.getEvents(extentionMethod, handlerName = pragma.getValue().replace("\"", ""))) != null) {
            if (translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN)) {
                return "\"" + event.getNameRu() + "\"";
            }
            return "\"" + event.getName() + "\"";
        }
        return pragma.getValue();
    }

    private String getReplaceText(Method method, @NonNull IProjectTranslationProvider translationProvider) {
        Pair names = this.namedEObjectNameProvider.getTranslatedName((EObject)method, translationProvider);
        if (names != null) {
            return (String)names.getValue();
        }
        return null;
    }

    private Event getEvents(Method method, String handlerName) {
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)method, Module.class);
        if (module == null) {
            return null;
        }
        Map eventHandlers = BslUtil.transformToMapOfEvent((List)this.contextDefService.getModuleEvents(module));
        List events = (List)eventHandlers.get(new CaseInsensitiveString(handlerName));
        for (Event event : events) {
            if (!handlerName.equalsIgnoreCase(event.getName()) && !handlerName.equalsIgnoreCase(event.getNameRu())) continue;
            return event;
        }
        return null;
    }
}

