/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.IDescriptionPart;
import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.Method;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.AbstractBslCommentTextProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.BslDerivedPropertyCache;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Provider;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ExternalDocCommentFieldProcessor
extends AbstractBslCommentTextProcessor {
    public ExternalDocCommentFieldProcessor(IFile file, Method method, FeatureKey featureKeyPreffix, BslDocumentationComment comment, List<INode> lines, IProjectTranslationProvider translationProvider, Function<EObject, String> eObjectReplaceProvider, BmOperationContext typeComputationContext) {
        super(file, featureKeyPreffix, (IDescriptionPart)comment, lines, ICollectingParameters.DEFAULT, translationProvider, eObjectReplaceProvider, method, typeComputationContext);
        this.setAddAction(this::doProcessTranslatable);
    }

    @Override
    protected <T> void doProcess(DocCommentProcessor.Parent parent, T object, Class<T> clazz) {
        if (object instanceof TypeSection.FieldDefinition && !(parent.getCurrent() instanceof BslDocumentationComment.ParametersSection)) {
            this.computeDerivedPropertyCache(parent, (TypeSection.FieldDefinition)object);
        }
        super.doProcess(parent, object, clazz);
    }

    private void doProcessTranslatable(Object object, FeatureValue fv) {
        if (!this.isChangeDefaultLanguage() && !this.isChangeScriptVariant()) {
            return;
        }
        if (object instanceof TypeSection.FieldDefinition) {
            this.doProcessTranslatable((TypeSection.FieldDefinition)object, fv);
        }
    }

    private void doProcessTranslatable(TypeSection.FieldDefinition object, FeatureValue fv) {
        String translation;
        BslDerivedPropertyCache cache = (BslDerivedPropertyCache)this.translationProvider.getCache(BslDerivedPropertyCache.class);
        Provider provider = () -> {
            TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
            String translation = this.translationProvider.getStoredTranslation(fv.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
            Optional<String> value = Optional.ofNullable(translation);
            return value.orElse(object.getName());
        };
        INode node = (INode)this.lines.get(object.getLineNumber());
        ICompositeNode methodNode = NodeModelUtils.findActualNodeFor((EObject)this.method);
        int localOffset = node.getOffset() - methodNode.getTotalOffset() + object.getNameOffset();
        URI uri = EcoreUtil.getURI((EObject)this.module);
        if (fv.isComputedValue()) {
            TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
            String translation2 = this.translationProvider.getStoredTranslation(fv.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT});
            if (StringUtils.isNotEmpty((String)translation2)) {
                cache.putTranslation(uri.toString(), this.method.getName(), localOffset, translation2);
            }
        }
        if (StringUtils.isNullOrEmpty((String)(translation = cache.getTranslation(uri, this.method.getName(), localOffset)))) {
            cache.putTranslation(uri.toString(), this.method.getName(), localOffset, (String)provider.get());
        }
    }

    private boolean isChangeDefaultLanguage() {
        return this.translationProvider.getProject().isChangeDefaultLanguage();
    }

    private boolean isChangeScriptVariant() {
        return this.translationProvider.getProject().isChangeScriptVariant();
    }
}

