/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.resource.BslResource;
import com._1c.g5.v8.dt.bsl.scoping.BslCachedScopeProvider;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.v8.dt.bsl.translator.BslTextProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.QueryFieldTranslationCache;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IScopedVariableTranslationStorageService;
import com.e1c.langtool.v8.dt.xtext.AbstractXtextObjectTextEditor;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import com.google.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.CancelIndicator;

public class ModuleTextEditor
extends AbstractXtextObjectTextEditor {
    private final Module module;
    private final IProjectTranslationProvider translationProvider;
    private final BmOperationContext typeComputationContext;
    @Inject
    private IScopedVariableTranslationStorageService scopedVariableTranslationStorageService;

    public ModuleTextEditor(Module module, IProjectTranslationProvider translationProvider, BmOperationContext typeComputationContext) {
        super((EObject)module);
        this.module = module;
        this.translationProvider = translationProvider;
        this.typeComputationContext = typeComputationContext;
        BslPlugin.getDefault().getInjector().injectMembers((Object)this);
    }

    protected MultiTextEditParseTreeVisitor createTreeVisitor(MultiTextEdit edit, EObject root, IProgressMonitor monitor) {
        BslTextProcessor treeVisitor = new BslTextProcessor(edit, (CancelIndicator)new MonitorBasedCancelIndicator(monitor), this.translationProvider, this.module, this.typeComputationContext);
        BslPlugin.getDefault().getInjector().injectMembers((Object)treeVisitor);
        return treeVisitor;
    }

    public IStatus process(IProgressMonitor monitor) {
        if (this.module.eResource() instanceof BslResource) {
            BslResource moduleResource = (BslResource)this.module.eResource();
            StringBuilder sb = new StringBuilder();
            if (!moduleResource.isDeepAnalysing()) {
                sb.append("isDeepAnalysing = False; ");
            }
            if (!moduleResource.isLocalResolveCrossReference()) {
                sb.append("isLocalResolveCrossReference = False; ");
            }
            if (!moduleResource.isLinkedBatch()) {
                sb.append("isLinkedBatch = False; ");
            }
            if (sb.length() > 0) {
                String message = MessageFormat.format("LT BSL translation module \"{0}\" loaded not well: {1}", EcoreUtil.getURI((EObject)this.module), sb.toString());
                Exception trace = new Exception(message);
                IStatus status = BslPlugin.createWarningStatus(message, trace);
                BslPlugin.log(status);
            }
        } else {
            String message = MessageFormat.format("BSL module \"{0}\" loaded into non-BslResource: {1}", EcoreUtil.getURI((EObject)this.module), this.module.eResource());
            Exception trace = new Exception(message);
            IStatus status = BslPlugin.createWarningStatus(message, trace);
            BslPlugin.log(status);
        }
        return super.process(monitor);
    }

    protected void dispose() {
        Resource moduleResource = this.module.eResource();
        QueryFieldTranslationCache fieldCache = (QueryFieldTranslationCache)this.translationProvider.getCache(QueryFieldTranslationCache.class);
        fieldCache.clear(moduleResource);
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        BslCachedScopeProvider cache = (BslCachedScopeProvider)resourceServiceProvider.get(BslCachedScopeProvider.class);
        cache.clearScopes(this.module);
        this.scopedVariableTranslationStorageService.clearScopes(this.module.getUniqueName());
    }
}

